#
# JIG - Debian Administration Manager
#
# Documentation for jig (wajig and gjig)
#
# Copyright (c) Graham.Williams@togaware.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import const

#
# VERSION
#
def version():
    print "JIG " + const.version +\
          """ - Command line system admin for Debian GNU/Linux
Copyright (c) Graham.Williams@togaware.com

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

On Debian systems, this may be found in /usr/share/common-licenses/GPL.

Wajig development takes place at http://sarovar.org/projects/wajig.

"""

#
# USAGE
#
def usage():
    print """Usage:
        wajig [options] [command] [packages|files] ...

	Wajig is a command line system manager for Debian GNU/Linux

        For a list of common commands try `wajig help'.
        For a list of all commands try `wajig commands'.
        Basic documentation available with `wajig doc | less'

        Gnome-jig (gjig) provides a Gnome interface to JIG.
"""

#
# HELP
#
def help(verbose):

#
# COMMON COMMANDS
#
    if verbose == 0:
        print """Common JIG commands:

 update         Update the list of down-loadable packages

 new            List packages that became available since last update
 newupgrades    List packages newly available for upgrading

 install        Install (or upgrade) one or more packages or .deb files
 remove         Remove one or more packages (see also purge)

 upgrade	Upgrade all of the installed packages or just those listed

 listfiles	List the files that are supplied by the named package
 listnames	List all known packages or those containing supplied string
 whatis		For each package named obtain a one line description
 whichpkg	Find the package that supplies the given command or file 

Run LIST-COMMANDS for a complete list of commands and
DOC for fuller documentation.
"""

#
# ALL COMMANDS AND OPTIONS
#
    elif verbose == 1:
      print """All JIG commands:

 addcdrom       Add a CD-ROM to the list of available sources of packages
 auto-clean	Remove superseded deb files from the download cache
 auto-download  Do an update followed by a download of all updated packages
 auto-install   Perform an install without asking questions (non-interactive)
 available      List versions of packages available for installation
 bug		Check reported bugs in package using the Debian Bug Tacker
 build		Retrieve/unpack sources and build .deb for the named packages
 build-depend	Retrieve packages required to build listed packages
 changelog	Retrieve latest changelog for the package
 clean		Remove all deb files from the download cache
 commands	List all the JIG commands and one line descriptions for each
 daily-upgrade  Perform an update then a dist-upgrade
 dependees	List of packages which depend on the specified package
 describe	One line description of packages (-v and -vv for more detail)
 describe-new	One line description of new packages
 detail  	Provide a detailed description of package (describe -vv)
 detail-new  	Provide a detailed description of new packages (describe -vv)
 dist-upgrade	Upgrade to new distribution (installed and new rqd packages)
 docs           Equivalent to help with -verbose=2
 download       Download package files ready for an install
 file-download  Download packages listed in file ready for an install
 file-install   Install packages listed in a file
 file-remove    Remove packages listed in a file
 find-file      Search for a file within installed packages
 find-pkg       Search for an unofficial Debian package at apt-get.org
 fix-configure  Perform dpkg --configure -a (to fix interrupted configure)
 fix-install    Perform apt-get -f install (to fix broken dependencies)
 fix-missing    Perform apt-get --fix-missing upgrade
 force		Install packages and ignore file overwrites and depends
 help           Print documentation (detail depends on --verbose)
 hold		Place listed packages on hold so they are not upgraded
 init           Initialise or reset the JIG archive files
 install        Install (or upgrade) one or more packages or .deb files
 installr       Install package and associated recommended packages
 installrs      Install package and recommended and suggested packages
 installs       Install package and associated suggested packages
 install/dist   Install packages from specified distribution
 integrity      Check the integrity of installed packages (through checksums)
 large          List size of all large (>10MB) installed packages
 last-update    Identify when an update was last performed
 list           List the status and description of installed packages
 list-all       List a one line description of every known package
 list-alts	List the objects that can have alternatives configured
 list-cache     List the contents of the download cache
 list-commands	List all the JIG commands and one line descriptions for each
 list-daemons   List the daemons that JIG can start/stop/restart
 list-files	List the files that are supplied by the named package
 list-hold      List those packages on hold
 list-installed List packages (with optional argument substring) installed
 list-names	List all known packages or those containing supplied string
 list-orphans   List libraries not required by any installed package
 list-status    Same as list but only prints first two columns, not truncated
 list-wide      Same as list but avoids truncating package names
 local-dist-upgrade Dist-upgrade using packages already downloaded
 local-upgrade  Upgrade using packages already downloaded, but not any others
 move		Move packages in the download cache to a local Debian mirror
 new            List packages that became available since last update
 news		Obtain the latest news about the package
 new-upgrades   List packages newly available for upgrading
 non-free     	List installed packages that do not meet the DFSG
 orphans        List libraries not required by any installed package
 package        Generate a .deb file for an installed package
 policy         From preferences file show priorities/policy (available)
 purge          Remove one or more packages and configuration files
 purge-depend   Purge package and those it depend on and not required by others
 purge-orphans  Purge orphaned libraries (not required by installed packages)
 rec-download	Download package and any it depends on
 recommended    Install package and associated recommended packages
 reconfigure    Reconfigure the named installed packages or run gkdebconf
 reinstall      Reinstall each of the named packages
 reload 	Reload daemon configs, e.g., gdm, apache (see list-daemons)
 remove         Remove one or more packages (see also purge)
 remove-depend  Remove package and those it depend on and not required by others
 remove-orphans Remove orphaned libraries (not required by installed packages)
 repackage      Generate a .deb file for an installed package
 reset          Initialise or reset the JIG archive files
 restart	Stop then start a daemon, e.g., gdm, apache (see list-daemons)
 rpm2deb	Convert a RedHat .rpm file to a Debian .deb file
 rpminstall	Install a RedHat .rpm package
 rpmtodeb	Convert a RedHat .rpm file to a Debian .deb file
 search         Search for packages containing listed words
 search-apt     Find local Debian archives suitable for sources.list
 setup  	Configure the sources.list file which locates Debian archives
 show    	Provide a detailed description of package [same as detail]
 showdistupgrade Trace the steps that a dist-upgrade would perform
 showinstall    Trace the steps that an install would perform
 showremove     Trace the steps that a remove would perform
 showupgrade    Trace the steps that an upgrade would perform
 size		Print out the size (in K) of all, or listed, installed packages
 sizes		Print out the size (in K) of all, or listed, installed packages
 source		Retrieve and unpack sources for the named packages
 start		Start a daemon, e.g., gdm, apache (see list-daemons)
 status		Show the version and available version of packages
 status-match	Show the version and available version of matching packages
 status-search	Show the version and available version of matching packages
 stop		Stop a daemon, e.g., gdm, apache (see list-daemons)
 suggested      Install package and associated suggested packages
 tasksel	Run the Gnome task selector to install groups of packages
 toupgrade      List packages with newer versions available for upgrading
 unhold         Remove listed packages from hold so they are again upgraded
 unofficial     Search for an unofficial Debian package at apt-get.org
 update         Update the list of down-loadable packages
 update-alts	Update default alternative for things like x-window-manager
 upgrade	Upgrade all of the installed packages or just those listed
 whatis		A synonym for describe
 whichpkg	Find the package that supplies the given command or file 

Command line options:

 -h|--help      Print usage message.
 -q|--quiet     Do system commands everything quietly.
 -s|--simulate  Trace but don't execute the sequence of underlying commands.
 -t|--teaching  Trace the sequence of commands performed.
 -v|--verbose=n Increase (or set) the level of verbosity (to n).

Run DOC for fuller documentation.
"""

#
# FULL DOCUMENTATION
#
    else:
      print """Welcome to JIG, bringing the pieces of system
administration together - a tool for Debian GNU/Linux.

JIG is Copyright (c) Graham.Williams@togaware.com
Available as GPL Open Source from any Debian archive and from:

	deb http://www.togaware.com/debian ./
	deb-src http://www.togaware.com/debian ./

JIG consists of two interfaces: WAJIG is a command line interface and
GJIG is a Gnome interface.

WAJIG commands are entered as the first argument to WAJIG. For
example:"wajig install gnome". GJIG has buttons for many of the
commands, but also allows commands to be typed directly.

The word JIG has a couple of meanings, as WordNet and Webster's 1913
Dictionary will confirm. It is a small machine or handy tool used to
guide other tools. It is also a quick dance, generally an old rustic
dance involving kicking and leaping, as well as a light, humorous
piece of writing, especially in rhyme, a farce in verse, or a ballad.
"A jig shall be clapped at, and every rhyme praised and applauded."

For WAJIG, `wa' is Japanese, indicating `harmony' and `team spirit and
unity.'

Development of WAJIG happens at wajig.sarovar.org.

------------------------------------------------------------------------
USING JIG

JIG expects a command and will call upon other Debian tools to perform
the command. You can obtain a list of common commands with HELP and a
list of all commands with LIST-COMMANDS. Fuller documentation is
available with DOC.

JIG will accept commands in mixed case with hyphens and underscore,
but internally maps them to the one command.  Thus, the JIG commands
`Install', `INSTALL', `install' and even `in-stall' are interpreted as
being identical. For this documentation we list all JIG commands in
all capitals simply to make them stand out. We also use hyphens to
make the commands clearer.

------------------------------------------------------------------------
HISTORY

If you've tried to remember all the different commands to get
different information about different aspects of Debian package
management and then used other commands to install and remove packages
then you'll know that it can become a little too much.
 
Swapping between dselect, deity, deity-gtk, aptitude, apt-get, dpkg,
gnome-apt, apt-cache, and so on is interesting but cumbersome.  Plus
personally I find dselect, deity, and aptitude confusing and even
though I've spent hours understanding each of them, I don't think the
time was particularly well spent. The newer synaptic graphical package
is quite nice and easier to use, but does not yet have all of the
functionality I'm after.

This Python script simply collects together what I have learnt over
the years about various commands!  Clearly I have yet to learn all
there is.

Another effort called feta has a similar goal of being a front end to
APT and I have extended and refined JIG to match feta to some
extent. JIG aims to offer more than just package management though.

------------------------------------------------------------------------
GETTING STARTED - USING SUDO

The aim of JIG is to operate as a user command and to do super user
privileged commands as necessary. The easiest way to do this is to use
the `sudo' package which will ask you for your (user) password and
then run the command as the super user. If you don't have sudo
installed then JIG will use `su' to run as super user, but you will
need to enter the super user password frequently. If `sudo' is
installed but not set up for you to access the appropriate APT
commands you will see a permission denied message.

Installing sudo is straight forward. As root run the command `visudo'
to edit the configuration file.  Add the lines:

  Cmnd_Alias  APT = /usr/bin/apt-get, /usr/bin/apt-cache, /usr/bin/dpkg, \ 
                    /usr/sbin/dpkg-reconfigure, /usr/bin/dpkg-repack, \ 
                    /etc/init.d/*, /usr/sbin/update-alternatives, \ 
                    /usr/lib/apt-move/fetch, /usr/bin/dselect, \ 
                    /usr/bin/alien, /usr/sbin/apt-setup

and

  kayon     ALL=(ALL) APT

in the appropriate places. Then user `kayon' can run the APT and
related commands as the super user.

------------------------------------------------------------------------
AVAILABLE PACKAGES

You will generally need to update the list of packages available for
downloading, unless you are staying with the `stable' release where
you generally only need to get the list of available packages once.
The command 

        UPDATE

is used to update the information about what is available for
downloading.  This relies on the entries in the sources.list file in
/etc/apt to know where to get the list of available packages from.
You can modify this file with:
	
	SETUP

But you will need to understand the format of the file, which is
explained in the sources.list manual page:

	$ man sources.list

If you have a Debian CD-ROM or DVD-ROM then you can tell APT what is
available on it using:

	ADD-CD-ROM

If you want to check when you last did an UPDATE then:

	LAST-UPDATE

------------------------------------------------------------------------
FINDING PACKAGES

Once the list of available packages is updated you can see what new
packages have been added to Debian with the command

        NEW

Note that after the first time you use `wajig UPDATE' all packages
will be considered new!

Packages that you already have installed may have been upgraded in the
archive. The command:

        NEW-UPGRADES

will list the packages that have been upgraded on the archive since
the last time an update was done.

For a complete list of packages that have newer versions available on
the archive use:

        TO-UPGRADE

To check the version of any installed package plus the version
available from the archive previously and now and the so called
Desired and Status flags, use:

	STATUS <package names>

Without a list of package names this command will list all installed
packages.

A variation is to list the status of all packages with a given string
in their name:

        STATUS-SEARCH <string>


To check for a particular package for which you might guess at part of
its name you can use:

	LIST-NAMES <string>

Without the <string> argument all known package names will be listed.

To list the names and current install status of installed packages then
use:

	LIST

You can also list just the names of the packages installed with:

	LIST-INSTALLED

And if you are looking for a particular installed package with a name
containing a particular string then use:

	LIST-INSTALLED <string>

Each package supplies a number of files and sometimes you like to see
where those files go, or even just view the list of files
supplied. The command to use is:

	LIST-FILES <package name>

For a one line description of a package use:

	WHAT-IS <package name>

The more detailed description of a package is available with:

	DETAIL <package-name>

The latest version of the appropriate change log file (i.e., the
latest news) can be retrieved with:

	NEWS <package names>

or else obtain the complete changelog with:

	CHANGELOG <package names>

And to find which package supplies a given command or file use:

	WHICH-PKG <command or file path>

For unofficial packages (i.e., you came across a package but it doesn't
seem to be in Debian yet) search for a site with:

        SEARCH-PKG <package-name>

------------------------------------------------------------------------
INSTALLING PACKAGES

To install a new package (or even update an already installed package)
all you need do is:

        INSTALL <package name>

Instead of INSTALL you could equivalently say UPDATE. If instead you
say DOWNLOAD then the packages will be downloaded but not installed so
that a follow up INSTALL will do the install without having to
download the packages. This is useful when you are installing many
packages that need to be downloaded, but you don't want to wait for
the download, yet you want to be there for the install!

Another option is to use RECDOWNLOAD which not only downloads the
package but recursively downloads all dependencies. This is useful if
you want to obtain a package to install on another machine (perhaps
with a slow or no Internet connection). Use RECDOWNLOAD to obtain the
package and all dependencies, then burn them to CD-RW. If a
RECDOWNLOAD command fails for dependency problems on some package
(usually in unstable) you can tell wajig to not download that package
by including the package name on the command lie, but with a minus (-)
sign, as in:

        RECDOWNLOAD openoffice.org perlapi-5.8.0-

To install a specific version of a package include the version number
after an "=", as in:

	INSTALL xlibs=4.1.0-11

To install a package from a specific distribution of Debian (e.g.,
from the stable release) include the distribution name after a slash
as in:

	INSTALL xlibs/stable

To install a package from a specific distribution of Debian (e.g.,
from the unstable release) and to also install any packages it depends
on from this same release include the distribution name after the INSTALL
command itself as in:

	INSTALL/unstable xlibs

Wildcards and other regular expressions can be used to identify the
packages. Some examples:

	INSTALL '^gnome-*'	(All packages beginning with gnome-)
        INSTALL 'gnome*'		(All packages with gnome in name)

You can list multiple packages to install with the one command.
Replacing <package name> with "-" will read the list of packages from
standard input.

You can use the INSTALL-R, INSTALL-S, and INSTALL-RS commands to
install a package (or packages) and all of the packages they
recommended or suggest (or both).

The INSTALL command will also accept a .deb file.  So, for example, if
you have downloaded a Debian package file (with the .deb extension)
you can install it with:

        INSTALL <.deb file>

The .deb file will be searched for in both the current directory and
in the apt archive at /var/cache/apt/archive/.

You can list multiple .deb files to install.

If the .deb package file you wish to install is available on the
Internet you can give its address and wajig will download then install
it:

  INSTALL http://togaware.com/debian/wajig_1.0.1-1_i386.deb

Particular versions of packages can easily be installed:

	INSTALL xlibs-dev=4.1.0-17

If the package you specify is already installed the INSTALL command
will simply tell you so. To force the package to be reinstalled:

	REINSTALL <package name>

Sometimes two packages provide the same file (this happens occasionally
at transitory times in the unstable distribution, and can also happen
when using RedHat packages). The normal install will fail indicating
that some other package has already installed a file.  If you are sure
you'd still like to go ahead, then use:

	FORCE <package name>

This command can also be used to force the installation of a package
even though some of the packages it depends on are missing.

Once a package is installed remove it with:

	REMOVE <package name>

Once again, you can list multiple packages to remove with the one command.

A REMOVE will not remove configuration files.  To get rid of the
configuration files as well use:

	PURGE <package name>

You can upgrade all installed packages with:

	UPGRADE

Or you can just upgrade security patches with:

	UPGRADE/SECURITY

And you can upgrade all installed packages and install all newly
required packages in the distribution with:

	DIST-UPGRADE

If you regularly keep your system up to date through the use
of a cron entry (not particularly recommended with the unstable
distribution, but many do!) then as a single command you can UPDATE
and DIST-UPGRADE with:

	DAILY-UPGRADE

A variation to this is to have a cron job running overnight to update
the list of available packages and then to download them (without
installing them) ready for you if you should decide to do a
DIST-UPGRADE in the morning!

	AUTO-DOWNLOAD

Suppose you were downloading a large collection of packages in a
UPGRADE or DIST-UPGRADE and the download is interrupted before all
packages are obtained. You can install the downloaded packages which
can be installed (i.e., dependencies are satisfied) using either one
of the commands:

	LOCAL-UPGRADE
        LOCAL-DIST-UPGRADE

If you have a list of packages you want installed stored in a file (as
you might create with the LIST-INSTALLED command run on a different
Debian machine) you can use FILE-INSTALL or FILE-DOWNLOAD to install or
download the packages:

	FILE-INSTALL newpkgs.txt

The file can be any format, perhaps one package per line or all
packages on one line separated by white space.

A more intuitive alternative might be:

        INSTALL -f newpkgs.txt

------------------------------------------------------------------------
ALTERNATIVE PACKAGES

Many packages with Debian supply the same functionality.  For example,
less, most and more are all `pagers' (they allow you to page through a
text document. Similarly, the packages mawk and gawk both provide
alternative implementations of the `awk' tool.

Debian manages such alternatives allowing a user to select which
alternative is to be used by default.  To find a list of all such
alternatives use:

	LIST-ALTS

You can choose which package, from amongst those installed, you which
to be associated with an `alternative' using, for example:

	UPADTE-ALTS pager

------------------------------------------------------------------------
BUILDING PACKAGES

You can download the source code for a package, perhaps modify it, and
generate your own .deb file for installation. You will need deb-src
lines in your sources.list file, such as the following:

	deb-src http://ftp.debian.org/debian unstable main contrib non-free

Generally you can add the `-src' to copies of pre-existing `deb' lines.

To retrieve and unpack a source Debian package use:

	SOURCE <package names>

Note that you can list several packages.

This command downloads the .tar.gz file and the .dsc file for the
package. The .tar.gz file contains the source code and associated
files. The .dsc file contains test information that is used by the
packaging system. The .tar.gz file will be extracted to create a
subdirectory consisting of the package name and version.

To go one step further and also configure, compile and generate a
Debian .deb package from source code (useful if you need to compile a
package for your setup specifically) then use instead:

	BUILD <package names>

If the build actually depends on other packages to be installed, and
they are not installed, the build will of course fail.  You can ensure
all required packages are installed with:

        BUILD-DEPEND <package names>

A particularly useful command is one that allows you to generate a
`.deb' file for an install package from the installed files, just in
case you want to install the package on another machine, for example,
and you can't get the package any other way:

	REPACKAGE <package name>

------------------------------------------------------------------------
MANAGING LOCAL PACKAGE ARCHIVE

When packages are installed the corresponding .deb files are stored in
/var/cache/apt/archive. This can become quite populated with older
versions of packages and we can clean out these older versions with:

	AUTO-CLEAN

Note however that it is sometimes useful to have older versions
hanging around if you are tracking unstable. Sometimes the newer
versions of packages are broken and you need to revert to an older
version.

Nonetheless, if you get short of disk space then you might want to
remove all the downloaded .deb files with:

	CLEAN

If instead you want to create a partial Debian mirror on your own web
server then the following command is useful after you have set up
apt-move to move the Debian packages from /var/cache/apt/archive to
/var/www/pub/debian:

	MOVE

------------------------------------------------------------------------
MANAGING DAEMONS OR SERVICES

Wajig also allows you to start, stop, reload, and restart services.
The commands all follow the same pattern:

	RESTART <service name>

The START and STOP commands are obvious.  The RESTART command
generally performs a stop followed by a start. The RELOAD command
will ask the daemon to reload its configuration files generally
without stopping the daemon, if this is possible.  The services you
can specify here depend on what you have installed.  Common services
include:

	apache		  Web server
	cron		  Regular task scheduler
	exim		  Email delivery system
	gdm		  The Gnome Windows Display Manager (for logging on)
	nfs-kernel-server Network File System
	ssh		  The Secure Shell daemon

You can get a list of daemons known on your system with the
LIST-DAEMONS command.

------------------------------------------------------------------------
MISCELLANEOUS

If you find a bug in some package then you can find out if it is a
known problem and whether there is a work around with:

	BUG <package name>

------------------------------------------------------------------------
HOW IT WORKS

Wajig maintains state information in ~/.wajig/$(hostname).  It records
the list of available packages prior to the most recent UPDATE.  The
state information is created whenever wajig notices that it does not
exist, typically the first time you run wajig.

The hostname is included in the state file for those environments
where a collection of Debian machines share the /home directories
through NFS, for example. Each machine may well be managed separately
(e.g., by the primary user of that machine who need not know the root
password) and so have a different collection of previously available
packages.

------------------------------------------------------------------------
LIMITATIONS

There are some know limitations particularly where a network of
machines share /var/cache/apt/archives (to share the downloading of
packages).  Occasionally one wajig will not be able to lock this
shared directory because at the same time another wajig on another
machine has it locked.

------------------------------------------------------------------------
TODO

	Document: findfile, integrity, orphans, remove-orphans,
		  reconfigure, search, hold, unhold

------------------------------------------------------------------------
ACKNOWLEDGEMENTS

JIG is written by Graham J. Williams and licensed under the GNU GPL.
It is Copyright (c) Graham.Williams@togaware.com.

The idea for JIG came from my regularly jotting down notes about
different commands within Debian for different tasks, all to do with
package management and system administration.

Dirk Eddelbuettel <edd@debian.org> has been most helpful and
encouraging in getting JIG included in Debian and making many useful
suggestions for improving and enhancing JIG.
"""

#  LocalWords:  Debian wajig gjig const newupgrades listfiles listnames whatis
#  LocalWords:  whichpkg elif addcdrom changelog dependees vv rqd org dpkg init
#  LocalWords:  installr installrs DFSG gkdebconf configs gdm RedHat rpminstall
#  LocalWords:  rpmtodeb showdistupgrade showinstall showremove showupgrade GPL
#  LocalWords:  toupgrade unhold src WordNet wa dselect gtk SUDO sudo su visudo
#  LocalWords:  Cmnd kayon DVD RECDOWNLOAD RW openoffice xlibs Wildcards dev
#  LocalWords:  cron newpkgs txt mawk awk UPADTE contrib pre dsc exim nfs TODO
#  LocalWords:  hostname findfile Eddelbuettel
