/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "Browser.h"

@implementation GestBrowser : NSObject

- (int)browser:(NSBrowser *)sender numberOfRowsInColumn:(int)column
{
	NSFileManager* fm = [NSFileManager defaultManager];
	NSString *ptc = [sender pathToColumn: column];
	NSArray *files = [fm directoryContentsAtPath: ptc];
	int ret = 0;

	if (files != nil) ret = [files count];
	return ret;
}

- (void)browser:(NSBrowser *)sender willDisplayCell:(id)cell atRow:(int)row column:(int)column
{
	NSFileManager *fm = [NSFileManager defaultManager];
	NSString *ptc = [sender pathToColumn: column];
	NSArray *files = [fm directoryContentsAtPath: ptc];
	NSMutableString *s = AUTORELEASE ([[NSMutableString alloc] initWithString: ptc]);
	BOOL exists = NO, is_dir = NO;
	int count = 0;

	if (files != nil) count = [files count];

	if (row >= count)
	return;

	[s appendString: @"/"];
	[s appendString: [files objectAtIndex: row]];
	exists = [fm fileExistsAtPath: s isDirectory: &is_dir];

	if ((exists) && (is_dir)) [cell setLeaf: NO];
	else [cell setLeaf: YES];

	[cell setStringValue: [files objectAtIndex: row]];
	//NSLog (@"Taille du fichier %@ : %@ path : %@ ", [files objectAtIndex: row], 
	//	[[[fm fileAttributesAtPath: s traverseLink: YES] objectForKey: NSFileSize] stringValue], s);
	[cell setFile: 
		[[File alloc] initWithName: [files objectAtIndex: row] 
		/*withLocalPath: ptc */ 
		withSize: [[[fm fileAttributesAtPath: s traverseLink: YES] objectForKey: NSFileSize] intValue]
		withType: is_dir]];
	[[cell getFile ] setLocalPath: ptc]; 
}

- (NSString *)browser:(NSBrowser *)sender titleOfColumn:(int)column
{
	return [sender pathToColumn: column];
}


@end

