/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "waiho.h"

@implementation MyDelegate : NSObject

- (void) getParametersOfConnection: (id) sender {
    [self countBookmarks];
    params = AUTORELEASE([[ParametersWindowController alloc] init]);
    [myWindow setDialing];
    [params showWindow: self];
}
- connectWithAddress: (NSString*) adr withLogin: (NSString*) login withPassword: (NSString*) password {

    FTPInterface = [[FTP alloc] initWithAddress: adr withLogin: login withPassword: password];
    DataTransfertIn = [[FTP alloc] initWithAddress: adr withLogin: login withPassword: password];
    DataTransfertOut = [[FTP alloc] initWithAddress: adr withLogin: login withPassword: password];
    
    if ([FTPInterface isConnected]) [myWindow setConnected];

    [DistributedCenter addObserver: self
	selector: @selector (receive:)
	name: @"ChunkOfFile"
	object: @"DataTransfert"];
    [DistributedCenter addObserver: self
	selector: @selector (send:)
	name: @"ChunkOfFileUploaded"
	object: @"DataTransfert"];
    [DistributedCenter addObserver: self
	selector: @selector (FileSaved:)
	name: @"FileSaved"
	object: @"DataTransfert"];
    [DistributedCenter addObserver: self
	selector: @selector (FileSend:)
	name: @"FileSend"
	object: @"DataTransfert"];
    return self;
}
- (void) disconnectRemote: (id) sender {
	NSLog (@"disconnectRemote");
	[myWindow setDisconnected];
	[downloadQueue dealloc];
	[uploadQueue dealloc];
        downloadQueue = [[NSMutableArray alloc] init];
        uploadQueue = [[NSMutableArray alloc] init];
        [myWindow refreshUploadTable];
        [myWindow refreshDownloadTable];
}
- (void) getNameDir: (id) sender {
    namedir = AUTORELEASE([[GetNameDirController alloc] init]);
    [namedir showWindow: self];
}
- (void) disconnectFromFTP: (id) sender {
    NSLog (@"On se deconnecte\n");
    [FTPInterface shutdown];
    [DataTransfertIn shutdown];
    [DataTransfertOut shutdown];
    [myWindow setDisconnected];
    [downloadQueue dealloc];
    [uploadQueue dealloc];
    downloadQueue = [[NSMutableArray alloc] init];
    uploadQueue = [[NSMutableArray alloc] init];
    [myWindow refreshUploadTable];
    [myWindow refreshDownloadTable];
    NSLog (@"FTP closed\n");
}

- (void) getFile: (id) sender {
    int i;
    NSArray* rfiles = [myWindow remoteViewSelectedCells];

    NSLog (@"remote path : %@\n", [myWindow remotePath]);
    NSLog (@"local path : %@\n", [myWindow localPath]);
    NSLog (@"rfiles count : %i", [rfiles count]);

    for (i = 0; i < [rfiles count]; i++)
    {
	File* f = AUTORELEASE ([(File*)[File alloc] initWithFile: [[rfiles objectAtIndex: i] getFile]]);
	
	[f setRemotePath: [myWindow remotePath]];
	[f setLocalPath: [myWindow localPath]];
	NSLog (@"on a mis dans le fichier %@ (%i) le localpath : %@", [f name], [f size], [f localpath]);
	[f setID: [downloadQueue count]];
	[downloadQueue addObject: f];
    }
    for (i = 0; i < [downloadQueue count]; i++)
    {
	File* f = [downloadQueue objectAtIndex: i];
	NSLog (@"fichier %i : <%i><%@>", i, [f getID], [f name]);
    }
    [myWindow refreshDownloadTable];
    [self downloadFiles];
}
- (void) putFile: (id) sender {
    int i;
    NSArray* lfiles = [myWindow localViewSelectedCells];

    NSLog (@"remote path : %@\n", [myWindow remotePath]);
    NSLog (@"local path : %@\n", [myWindow localPath]);
    NSLog (@"lfiles count : %i", [lfiles count]);

    NSLog (@"A uploadQueue count : %i", [uploadQueue count]);
    for (i = 0; i < [lfiles count]; i++)
    {
	//File* f = [[lfiles objectAtIndex: i] getFile];
	File* f = AUTORELEASE ([(File*)[File alloc] initWithFile: [[lfiles objectAtIndex: i] getFile]]);
	[f setRemotePath: [myWindow remotePath]];
	NSLog (@"[%i] on a mis dans le fichier %@ le remotepath : %@ (%i) ", i, [f name], [f remotepath], [f size]);
	[f setID: [uploadQueue count]];
	[uploadQueue addObject: f];
    }
    NSLog (@"B uploadQueue count : %i", [uploadQueue count]);
    for (i = 0; i < [uploadQueue count]; i++)
    {
	File* f = [uploadQueue objectAtIndex: i];
	NSLog (@"*** fichier %i : <%i> <%@>", i, [f getID], [f name]);
    }
    [myWindow refreshUploadTable];
    [self uploadFiles];
}
- (void) createMenu {
    NSMenu *menu;
    NSMenu *infoMenu;
    NSMenuItem* menuItem;

    menu = AUTORELEASE ([NSMenu new]);
    infoMenu = AUTORELEASE ([NSMenu new]);

    [infoMenu addItemWithTitle: @"Info Panel ..."
     action: @selector (orderFrontStandardInfoPanel:)
     keyEquivalent: @""];

    [infoMenu addItemWithTitle: @"Help..."
     action: @selector (orderFrontHelpPanel:)
     keyEquivalent: @"?"];

    menuItem = [menu addItemWithTitle: @"Info.."
                action: NULL
                keyEquivalent: @""];

    [menu addItemWithTitle: @"Quit"
     action: @selector (terminate:)
     keyEquivalent: @"q"];

    [menu setSubmenu: infoMenu forItem: menuItem];

    [NSApp setMainMenu: menu];
}
- (MainWindowController*) window {
    return myWindow;
}

- (void) downloadFiles {
    int i, ret;
    for (i = 0; i < [downloadQueue count]; i++)
    {
	File* f = [downloadQueue objectAtIndex: i];

	NSLog (@"DOWNLOADFILES : [%@] <%@> de <%@> a <%@>", [f getStatus], [f name], [f remotepath], [f localpath]);

	if (![f isDone]) // si le fichier n'est pas telecharge
	{
	    if (![f isCurrent]) // si on a pas encore fait la demande de telechargement
	    {
		NSMutableString* filename = [NSMutableString stringWithString: [f localpath]];
		NSMutableString* path = [NSMutableString stringWithString: [f remotepath]];
		
		[filename appendString: @"/"];
		[filename appendString: [f name]];
		[path appendString: @"/"];
		[path appendString: [f name]];

		[f setCurrent: YES];

		NSLog (@"DOWNLOAD fichier path : %@ dans : %@", path, filename);
		ret = [DataTransfertIn get: path withSavedName: filename withID: [f getID]];
		if (ret >= 400) // erreur
		{
		    [f setError];
		}
		[myWindow refreshDownloadTable];
		return;
	    }
	    else return; // si on a trouve un fichier en cours de telechargement, on arrete les frais
	}
	else // s'il est telecharge, on enleve l'etat "current"
	{
	    [f setCurrent: NO];
	}
    }
}
- (void) uploadFiles {
    int i, ret;
    for (i = 0; i < [uploadQueue count]; i++)
    {
	File* f = [uploadQueue objectAtIndex: i];

	NSLog (@"UPLOADFILES : [%@] <%@> de <%@> a <%@>", [f getStatus], [f name], [f localpath], [f remotepath]);

	if (![f isDone]) // si le fichier n'est pas telecharge
	{
	    if (![f isCurrent]) // si on a pas encore fait la demande de telechargement
	    {
		NSMutableString* filename = [NSMutableString stringWithString: [f localpath]];
		NSMutableString* path = [NSMutableString stringWithString: [f remotepath]];
		[filename appendString: @"/"];
		[filename appendString: [f name]];
		[path appendString: @"/"];
		[path appendString: [f name]];
		[f setCurrent: YES];

		NSLog (@"UPLOAD fichier path : %@ vers : %@ ", filename, path);
		ret = [DataTransfertOut put: filename withSavedName: path withID: [f getID]];
		if (ret >= 400) // erreur
		{
		    [f setError];
		}
		[myWindow refreshUploadTable];
		return;
	    }
	    else return; // si on a trouve un fichier en cours de telechargement, on arrete les frais
	}
	else // s'il est telecharge, on enleve l'etat "current"
	{
	    [f setCurrent: NO];
	}
    }
}

- (void) FileSaved: (NSNotification*) notification {
    int ID;
    NSDictionary * info;

    NSLog (@"Notification de fichier sauvegarde !");
    info = [notification userInfo];
    ID = [[info objectForKey: @"ID"] intValue];
    NSLog (@"fichier : %i", ID);
    
    if (ID < [downloadQueue count])
    {
	File* f = [downloadQueue objectAtIndex: ID];
	[f setDone];
    }
    [myWindow refreshDownloadTable];
    [myWindow refreshLocal];
    [self downloadFiles];
}

- (void) FileSend: (NSNotification*) notification {
    int ID;
    NSDictionary * info;
    NSLog (@"Notification de fichier envoye !");

    info = [notification userInfo];
    ID = [[info objectForKey: @"ID"] intValue];
    NSLog (@"fichier : %i", ID);
    
    if (ID < [uploadQueue count])
    {
	File* f = [uploadQueue objectAtIndex: ID];
	[f setDone];
    }

    [myWindow refreshUploadTable];
    [myWindow refreshRemote];
    [self uploadFiles];
}

- (void) receive: (NSNotification*) notification {
    NSDictionary* userInfo;
    int size = 0;
    int i;

    userInfo = [notification userInfo];
    size = [[userInfo objectForKey: @"size"] intValue];

    if (size > 0)
    {
	for (i = 0; i < [downloadQueue count]; i++)
	{
	    File* f = [downloadQueue objectAtIndex: i];

	    NSLog (@"RECEIVE <%@> <%@> <size: %i> <isDone: %i> <isCurrent: %i>", 
		    [f name], [f getStatus], [f currentsize], [f isDone], [f isCurrent]);

	    if (![f isDone])
	    {
		if ([f isCurrent])
		{
		    [f addToSize: size];
		    [myWindow refreshDownloadTable];
		    return;
		}
	    }
	}
    }
}
- (void) send: (NSNotification*) notification {
    NSDictionary* userInfo;
    int size = 0;
    int i;

//    NSLog (@"Notification dans le App");

    userInfo = [notification userInfo];
    size = [[userInfo objectForKey: @"size"] intValue];

    if (size > 0)
    {
	for (i = 0; i < [uploadQueue count]; i++)
	{
	    File* f = [uploadQueue objectAtIndex: i];

	    NSLog (@"SEND <%@> <%@> <size: %i / %i> <isDone: %i> <isCurrent: %i>", 
		    [f name], [f getStatus], [f currentsize], [f size], [f isDone], [f isCurrent]);

	    if (![f isDone])
	    {
//		NSLog (@"Traitement de %@", [f name]);
		if ([f isCurrent])
		{
		    [f addToSize: size];
		    [myWindow refreshUploadTable];
		    return;
		}
	    }
	}
    }
}

- (FTP*) ftp {
    return FTPInterface;
}
- (NSArray*) downloadQueue {
    return downloadQueue;
}
- (NSArray*) uploadQueue {
    return uploadQueue;
}
- (Sites*) bookmarks { 
    return bookmarks;
}
- (void) countBookmarks {
    NSLog (@"on compte les bookmarks...\n");
    NSLog (@"on a %d bookmarks.\n", [bookmarks count]);
}

- (void) dealloc {
    RELEASE (myWindow);
    RELEASE (downloadQueue);
    RELEASE (uploadQueue);
    //RELEASE (bookmarks);
}
- (void) applicationWillFinishLaunching: (NSNotification *) not {
    //Bookmark* testbookmark = [[Bookmark alloc] initWithSite: @"127.0.0.1" withLogin: @"nico" withPassword: @"xkbmdu"];
    //Bookmark* testbookmark2 = [[Bookmark alloc] initWithAnonymousSite: @"ftp.lip6.fr"];
    //NSLog (@"bkm 1 : %@ (l/p : %@/%@)\n", [testbookmark site], [testbookmark login], [testbookmark password]);
    //NSLog (@"bkm 2 : %@ (l/p : %@/%@)\n", [testbookmark2 site], [testbookmark2 login], [testbookmark2 password]);
    //[bookmarks addSite: testbookmark];
    //[bookmarks addSite: testbookmark2];
    //[bookmarks writeFile: @"~/bookmarks.waiho"];
    //printf ("On a crit le fichier de bookmarks !\n");

    [self createMenu];
    myWindow = [[MainWindowController alloc] init];
    NSLog (@"tudieu");
    downloadQueue = [[NSMutableArray alloc] init];
    uploadQueue = [[NSMutableArray alloc] init];
    //center = [NSNotificationCenter defaultCenter];
    DistributedCenter = [NSDistributedNotificationCenter defaultCenter];
    NSLog (@"on arrive");
    bookmarks = [(Sites*)[Sites alloc] initWithFile: @"~/bookmarks.waiho"];
    [self countBookmarks];
}
- (void) applicationDidFinishLaunching: (NSNotification *) not {
    int choice;
    [[myWindow window] makeKeyAndOrderFront: nil];
    [self countBookmarks];
}

@end

