/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "parametersController.h"
#import "waiho.h"

@implementation ParametersWindowController

- (void) dealloc
{
}

- (id) init
{
	ParametersWindow* theWindow;
	sitesCombo = [[SitesCombo alloc] initWithBook: [[NSApp delegate] bookmarks]];
	NSLog (@"Count externe du bookmark : \n");
	NSLog (@"count: %d\n", [sitesCombo count]);
	[sitesCombo addObserver: self];

	theWindow = [[ParametersWindow alloc] initWithContentRect: NSMakeRect (300,300,300,120)
				styleMask: 	(NSTitledWindowMask |
						NSClosableWindowMask |
						NSMiniaturizableWindowMask)
				backing: NSBackingStoreBuffered
				defer: YES];

	[super initWithWindow: theWindow];
	[theWindow layoutWindow];
	[theWindow setDelegate: self];
	
	login = [theWindow login];
	password = [theWindow password];
	server = [theWindow server];
	go = [theWindow go];
	cancel = [theWindow cancel];
	
	[server setUsesDataSource: YES];
	[server setDataSource: sitesCombo];
	[server setDelegate: sitesCombo];
	
	[server setNextKeyView: login];	
	[login setNextKeyView: password];
	[password setNextKeyView: cancel];
	[cancel setNextKeyView: go];
	[go setNextKeyView: server];

	[go setAction: @selector (connect:)];
	[cancel setAction: @selector (cancel:)];

	[[self window] setTitle: @"Parametres..."];
	return self;
}

- (void) setLogin: (NSString*) plogin Password: (NSString*) ppassword {
    NSString* l = [[NSString alloc] initWithString: plogin];
    NSString* p = [[NSString alloc] initWithString: ppassword];
    NSLog (@"on mets login : %@ password : %@\n", l, p);
    [login setStringValue: l];
    [password setStringValue: p];
}

- (IBAction) cancel: (id) sender
{
	NSLog (@"On est dans le cancel... \n");
	[self close];
	[[(MyDelegate*)[NSApp delegate] window] setDisconnected];
}

- (IBAction) connect: (id) sender
{
	NSLog (@"On est dans le connect ... \n");	
	NSLog (@"Login : %@ Password %@ sur le serveur : %@\n", [login stringValue], [password stringValue],
			[server stringValue]);
			[self close];
	[(MyDelegate*)[NSApp delegate] connectWithAddress: [server stringValue] withLogin: [login stringValue] 
		withPassword: [password stringValue]];
}

@end
