/*
 * Simple MPEG/DVB parser to achieve network/service information without initial tuning data
 *
 * Copyright (C) 2006, 2007, 2008 Winfried Koehler 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 * Or, point your browser to http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * The author can be reached at: handygewinnspiel AT gmx DOT de
 *
 * The project's page is http://wirbel.htpc-forum.de/w_scan/index2.html
 */

#include <stdio.h>
#include "dump-dvbscan.h"
#include <linux/dvb/frontend.h>

static const char *fec_name [] = {
	"NONE",
	"1/2",
	"2/3",
	"3/4",
	"4/5",
	"5/6",
	"6/7",
	"7/8",
	"8/9",
	"AUTO"
};


static const char *qam_name [] = {
	"QPSK",	/* FIXME: sometimes Modulation cannot be found, returns QPSK */
	"QAM16",
	"QAM32",
	"QAM64",
	"QAM128",
	"QAM256",
	"AUTO",
	"8VSB",
	"16VSB",
};


static const char *bw_name [] = {
	"8MHz",
	"7MHz",
	"6MHz",
	"AUTO"
};


static const char *mode_name [] = {
	"2k",
	"8k",
	"AUTO"
};

static const char *guard_name [] = {
	"1/32",
	"1/16",
	"1/8",
	"1/4",
	"AUTO"
};


static const char *hierarchy_name [] = {
	"NONE",
	"1",
	"2",
	"4",
	"AUTO"
};

void dvbscan_dump_tuningdata (	FILE *f, 
				fe_type_t type,
				struct dvb_frontend_parameters *p,
				uint16_t index) {
	if (index == 0) {
		fprintf (f, "# file automatically generated by w_scan\n");
		fprintf (f, "# (http://wirbel.htpc-forum.de/w_scan/index2.html)\n");
		switch (type) {
			case FE_ATSC:
				fprintf (f, "# freq mod\n");
				break;
			case FE_QAM:
				fprintf (f, "# freq sr fec mod\n");
				break;
			case FE_OFDM:
				fprintf (f, "# T freq bw fec_hi fec_lo mod");
				fprintf (f, " transmission-mode guard-interval hierarchy\n");
				break;
			default:
				;
			};
		}	/* end if index == 0 */

	switch (type) {
		case FE_ATSC:
			fprintf (f, "A ");
			fprintf (f, "%i ", p->frequency);
			fprintf (f, "%s\n",  qam_name[p->u.vsb.modulation]);
			break;
		case FE_QAM:
			fprintf (f, "C ");
			fprintf (f, "%i ", p->frequency);
			fprintf (f, "%i ", p->u.qpsk.symbol_rate);
			fprintf (f, "%s ", fec_name[p->u.qpsk.fec_inner]);
			fprintf (f, "%s\n",  qam_name[p->u.qam.modulation]);
			break;
		case FE_OFDM:
			fprintf (f, "T ");
			fprintf (f, "%i ", p->frequency);
			fprintf (f, "%s ", bw_name[p->u.ofdm.bandwidth]);
			fprintf (f, "%s ", fec_name[p->u.ofdm.code_rate_HP]);
			fprintf (f, "%s ", fec_name[p->u.ofdm.code_rate_LP]);
			fprintf (f, "%s ", qam_name[p->u.ofdm.constellation]);
			fprintf (f, "%s ", mode_name[p->u.ofdm.transmission_mode]);
			fprintf (f, "%s ", guard_name[p->u.ofdm.guard_interval]);
			fprintf (f, "%s\n",  hierarchy_name[p->u.ofdm.hierarchy_information]);
			break;

		default:
			;
		};
}

