#!/bin/sh
#
# vym2html.sh
#
VERSION="0.7"
# Date: 20040625
# Author: Clemens Kraus (http://www.clemens-kraus.de)
#
# AddOns: Uwe Drechsel
#echo $@


unpacker()
# Unpack vym-file, only if it is one
{
  echo $VYMFILE_EXT | grep -F ".vym" 1>/dev/null

  if [ $? = 0 ] ; then
	  echo ">> Unpacking files ..."
	  unzip $VYMFILE_EXT -d $VYMPATH 1>/dev/null
	  if [ $? -gt 0 ] ; then
		echo ">>> Error in unzip! Aborting."
	  	exit 4
	  fi
  fi
}


transform()
{
  # copy stylesheet
  if [ -z $STYLESHEETP ] ; then
	  echo ">>> Error: could not process stylesheet "$STYLESHEETP"! Aborting."
	  exit 5
  else
	  if [ -n $VYMPATH ] ; then
		  if [ -n "$WIKISTYLEP" ] ; then
		    mkdir -p $VYMPATH/images
			cp `dirname $STYLESHEETP`/wiki/* $VYMPATH/images
			if [ $? -gt 0 ] ; then
				echo ">>> Warning: could not copy images for WIKI style
				\""$STYLESHEETP"/wiki/*\"!"
			else
			  echo ">> WIKI style images \""$STYLESHEETP"/wiki/*\" copied ..."
			fi  
		  fi
	  	cp `dirname $STYLESHEETP`/$CSSFILE $VYMPATH
		if [ $? -gt 0 ] ; then
			echo ">>> Warning: could not copy CSS-file \""$CSSFILE"\"!"
		else
		  echo ">> CSS-file \""$CSSFILE"\" copied ..."
		fi
	  fi
  fi
  
  echo ">> Starting XSLT transformation ..."

  OPTIONS=" -o $VYMFILE.html \
  --stringparam filenamep \"$VYMFILE\" \
  --stringparam wikistylep \"$WIKISTYLEP\" \
  --stringparam genimagep \"$GENIMAGEP\" \
  --stringparam imageonlyp \"$IMAGEONLYP\" \
  --stringparam urlHeadingp \"$URLHEADING\" \
  --stringparam urlImagep \"$URLIMG\" \
  --stringparam stylesheetp $CSSFILE  \
  `dirname $STYLESHEETP`/vym2html.xsl \
  $VYMFILE.xml "
  
  
# echo Executing: xsltproc $OPTIONS 2>&1
#  xsltproc $OPTIONS 2>&1

xsltproc -o $VYMPATH/$VYMNAME".html" --stringparam filenamep "$VYMPATH/$VYMNAME" --stringparam wikistylep "$WIKISTYLEP" --stringparam genimagep "$GENIMAGEP" --stringparam imageonlyp "$IMAGEONLYP" --stringparam urlHeadingp "$URLHEADING" --stringparam urlImagep "$URLIMAGE" --stringparam stylesheetp "$CSSFILE"  `dirname $STYLESHEETP`/vym2html.xsl  $VYMPATH/$VYMNAME".xml" 2>&1

  if [ $? -gt 0 ] ; then
	  echo ">>> Error in xsltproc! Aborting."
	  exit 3
  fi
  
}


txt2html()
# change all txt-files into xml-format
{
  for i in `ls $VYMPATH/notes/$VYMNAME-note-*.txt 2>/dev/null`
  do
    # Check whether already modified
	grep "<note>" $i 1>/dev/null
	
	if [ $? -gt 0 ] ; then
	  echo ">> Modifying: "$i
	  cp $i $i"_tmp"
	  echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" > $i
	  echo "<note>" >> $i
	  if [ -z "$WIKISTYLEP" ] ; then
		  echo "<![CDATA[" >> $i
	  fi
	  
	  cat $i"_tmp" >> $i
  
	  if [ -z "$WIKISTYLEP" ] ; then
		  echo "]]>" >> $i
	  fi
	  echo "</note>" >> $i
  
	  rm $i"_tmp"
	fi
  done
}


remove_files()
# remove all temporary unpacked vym-files
{
  echo $VYMFILE_EXT | grep -F ".vym" 1>/dev/null
	
  if [ $? = 0 ] ; then
	echo ">> Removing temporary files ..."
	for i in `ls $VYMPATH/notes/$VYMNAME-note-*.txt 2>/dev/null`
	do
	  rm $i
	done
  
	for i in `ls $VYMPATH/images/$VYMNAME-image-*.* 2>/dev/null`
	do
	  rm $i
	done
  
	rm $VYMPATH/$VYMFILE".xml" 2>/dev/null
  fi
}


reducesize()
{
  # optional: reducing image-size
  echo ">> reducing image size to 256 colors ..."
  convert -colors 255 $VYMPATH/images/$VYMFILE".png" $VYMPATH/images/$VYMFILE".png"
}


# -------------------- Parameter check -----------------------
GENIMAGEP=""
IMAGEONLYP=""
WIKISTYLEP=""
STYLESHEETP=""
CSSFILE="vym.css"

USAGE="USAGE:\t`basename $0`  vymfile.[vym|xml]  -sp=\077  [Options]\n
\t-sp=\077: absolute stylesheet path (including name of stylesheet)\n
Output:\tvymfile.html\n\n
Options:\n
-image: creates a clickable image at the beginning of the HTML-output\n
-imageonly: creates a clickable image without further HTML-output\n
-URLHeading: if set, URLs will show the heading\n
-URLImage: if set, URLs will show the globe visible in the map\n
-css=\077: tell vym2html to use this CSS-file, default is '$CSSFILE'\n
-v: prints the version of vym2html\n
-wikistyle: activates some wiki-shortcuts\n
\tWiki-style notation overview: \n
\tLines:\n
\t+ Big headlines start with the '+' character.\n
\t- Small headlines start with the '-' character.\n
\t  Normal text doesn't have any starting notation.\n
\t! Notes start with an exclamation.\n
\t. Indented text starts with a dot.\n
\t\077 Questions start with a question-mark, and\n
\t= Answers starts with the equal-sign.\n
\t\052 Points for a item-list\n
\t# clues\n
\n
\tLinks:\n
\tuse '{...}' or '{(Clemens homepage) http://www.clemens-kraus.de/}'\n\tfor external links.\n
\n
\tMarkup:\n
\t|This is bold| text, while |/this text is italic|, \n\t|*this is pre-formatted|, and |!this is a note|"

if [ "$1" = '-v' ]; then
	  echo "vym2html Version: "$VERSION
	  exit 0
fi


if [ $# -lt 2  ]; then 
	echo -e $USAGE
	exit 1
else
	VYMFILE_EXT=$1
	VYMNAME=`echo $VYMFILE_EXT | sed "s/.*\///" | sed "s/\\..*$//"`
	VYMPATH=`dirname $VYMFILE_EXT`
fi

shift 1

for arg do
  if [ "$arg" = '-wikistyle' ]; then
	  WIKISTYLEP="yes"
  elif [ "$arg" = '-image' ]; then
	  GENIMAGEP="yes"
  elif [ "$arg" = '-imageonly' ]; then
	  IMAGEONLYP="yes"
	  GENIMAGEP="yes"
  elif [ ${arg:0:3} = '-sp' ]; then			# take first 3 chars
	  STYLESHEETP=`echo $arg | cut -d= -f2`
  elif [ ${arg:0:4} = '-css' ]; then		# take first 4 chars
	  CSSFILE=`echo $arg | cut -d= -f2`
  elif [ $arg = "-useURLHeading" ]; then
		URLHEADING="yes"		
  elif [ $arg = "-useURLImage" ]; then
		URLIMAGE="yes"		
  elif [ "$arg" = '-help' ]; then
	echo -e $USAGE
	exit 1
  else
	echo -e $USAGE
	exit 1
  fi
done

#Debugging
echo VYMFILE_EXT=$VYMFILE_EXT
echo VYMNAME=$VYMNAME
echo VYMPATH=$VYMPATH
#echo WIKISTYLEP=$WIKISTYLEP


# ---------------------- Los geht's --------------------------
echo ">> Processing file '$VYMFILE_EXT' ..."

# Unpack vym-file
unpacker

# Modify "*-note-x.txt" files
txt2html

# Transform
transform

#reducesize

# clean up
remove_files

echo ">> Ready!"
echo ">> ---------------------"

exit 0


