#ifndef XLINKOBJ_H
#define XLINKOBJ_H

#include "linkablemapobj.h"

enum XLinkState {undefinedXLink,initXLink,activeXLink,deleteXLink};

/////////////////////////////////////////////////////////////////////////////
class XLinkObj:public MapObj {
public:
    XLinkObj ();
    XLinkObj (QCanvas*);
    ~XLinkObj ();
    virtual void init ();
    virtual void copy (XLinkObj*);
	void setBegin (BranchObj*);
	void setEnd   (BranchObj*);
	void setEnd   (QPoint);
	void setColor(QColor);
	QColor getColor();
	void setWidth (int);
	int getWidth ();
	bool activate ();			// Sets pointers in branchObjects
	void deactivate();			// removes those pointers
	bool isUsed();				// true, if at least on branch uses it
	void updateXLink();
	BranchObj* otherBranch (BranchObj*);
	void positionBBox();
	void calcBBoxSize();
	void setVisibility (bool);
	void setVisibility ();
	QString saveToDir ();

private:
	static int arrowSize;
	QColor color;
	int width;
	QCanvasLine *line;
	QCanvasPolygon *poly;
	BranchObj *beginBranch;
	BranchObj *endBranch;
	BranchObj *visBranch;	// the "visible" part of a partially scrolled link
	XLinkState xLinkState;	// init during drawing or active
	QPoint beginPos;
	QPoint   endPos;
};

#endif
