#ifndef ORNAMENTEDOBJ_H
#define ORNAMENTEDOBJ_H

#include "linkablemapobj.h"

class OrnamentedObj:public LinkableMapObj {
public:	
    OrnamentedObj ();
    OrnamentedObj (QCanvas*);
    OrnamentedObj (OrnamentedObj*);
    ~OrnamentedObj ();
    virtual void init ();
    virtual void copy (OrnamentedObj*);

    virtual void setHeading (QString s)=0;  // set the heading, pure virtual 
											// to take care of fontsize
    virtual QString getHeading();			// returns the heading	
	virtual void setLinkColor();			// sets color according to colorhint, overloaded
    virtual void setVisibility(bool,int)=0;	// set visibility
    virtual void setVisibility(bool)=0;	    // set vis. for w
	virtual void setColor(QColor,bool)=0;		// set the color of text and link
	QColor getColor ();						// get color of heading
    virtual void move   (double,double);
    virtual void move   (QPoint);
    virtual void moveBy (double,double);
    virtual void moveBy (QPoint);
    virtual void move2RelPos (QPoint);		// move relativly to parent^
    virtual void move2RelPos (double,double);
    virtual void setNote(QString);			// set note
    virtual void setNote(NoteObj);			// set note
    virtual QString getNote();				// returns note	
	virtual void toggleStandardFlag(QString, bool);
	virtual void activateStandardFlag(QString);
	virtual QString getSystemFlagName (const QPoint &p);
	virtual void updateNoteFlag();

protected:
    HeadingObj *heading;			// Heading
	NoteObj note;					// Notes
	FlagRowObj *systemFlags;		// System Flags
	FlagRowObj *standardFlags;		// Standard Flags
};

#endif
