#include "ornamentedobj.h"
#include "texteditor.h"
#include "mapeditor.h"
#include "linkablemapobj.h"

extern TextEditor *textEditor;
extern FlagRowObj *systemFlagsDefault;
extern FlagRowObj *standardFlagsDefault;


/////////////////////////////////////////////////////////////////
// OrnamentedObj
/////////////////////////////////////////////////////////////////

OrnamentedObj::OrnamentedObj():LinkableMapObj()
{
  //  cout << "Const OrnamentedObj ()\n";
    init ();
}

OrnamentedObj::OrnamentedObj(QCanvas* c) :LinkableMapObj(c)
{
//    cout << "Const OrnamentedObj\n";
    init ();
}

OrnamentedObj::OrnamentedObj (OrnamentedObj* lmo) : LinkableMapObj (lmo->canvas)
{
    copy (lmo);
}

OrnamentedObj::~OrnamentedObj()
{
    delete (heading);
	delete (systemFlags);
	delete (standardFlags);

}


void OrnamentedObj::init ()
{
	heading = new HeadingObj(canvas);
	heading->move (absPos.x(), absPos.y());

	note.setNote("");
	note.setFontHint (textEditor->getFontHintDefault() );

	systemFlags=new FlagRowObj(canvas);
	systemFlags->clone(systemFlagsDefault);
	systemFlags->setName ("systemFlags");
	
	standardFlags=new FlagRowObj(canvas);
	standardFlags->clone(standardFlagsDefault);
	standardFlags->setName ("standardFlags");



}

void OrnamentedObj::copy (OrnamentedObj* other)
{
    LinkableMapObj::copy(other);
	heading->copy(other->heading);
    setColor   (other->heading->getColor(),false);	

	note.copy (other->note);
	systemFlags->copy (other->systemFlags);
	standardFlags->copy (other->standardFlags);

}

QString OrnamentedObj::getHeading()
{
    return heading->text();
}

void OrnamentedObj::setLinkColor()
{
	if (mapEditor->getLinkColorHint()==HeadingColor)
		LinkableMapObj::setLinkColor (heading->getColor());
	else	
		LinkableMapObj::setLinkColor (mapEditor->getDefLinkColor());
}

QColor OrnamentedObj::getColor ()
{
    return heading->getColor();
}


void OrnamentedObj::move (double x, double y)
{
	MapObj::move (x,y);
	double dx=frame->getBorder()/2;  // care for border around object
	double dy=frame->getBorder()/2;
	systemFlags-> move (x + dx, y + dy);

	// vertical align heading to bottom
	int h=max (systemFlags->getBBox().height(), standardFlags->getBBox().height());
	h=max (h,heading->getHeight());
    heading->move (x + dx + systemFlags->getBBox().width(),
					y + dy  + h - heading->getHeight() 
					);
	standardFlags->move (x + heading->getWidth() + systemFlags->getBBox().width(), y + dy );				

	updateLink();
	requestReposition();
}

void OrnamentedObj::move (QPoint p)
{
	move (p.x(), p.y());
}	

void OrnamentedObj::moveBy (double x, double y)
{

	MapObj::moveBy (x,y);
    frame->moveBy (x,y);
    systemFlags->moveBy (x,y);
    standardFlags->moveBy (x,y);
    heading->moveBy (x,y);
	updateLink();
	requestReposition();
}

void OrnamentedObj::moveBy (QPoint p)
{
	moveBy (p.x(), p.y());
}	

void OrnamentedObj::move2RelPos(double x, double y)
{
	if (!parObj) return;
	move (parObj->getChildPos().x()+x, parObj->getChildPos().y()+y);
}

void OrnamentedObj::move2RelPos(QPoint p)
{
	if (!parObj) return;
	move (parObj->getChildPos().x() + p.x(), parObj->getChildPos().y() + p.y() );
}

void OrnamentedObj::setNote(QString s)
{
	note.setNote(s);
	if (!note.isEmpty())
		systemFlags->activate("note");
	else		
		systemFlags->deactivate("note");
	calcBBoxSize();
	positionBBox();	
	move (absPos.x(), absPos.y() );
	forceReposition();
}

void OrnamentedObj::setNote(NoteObj n)
{
	note=n;
	if (!note.isEmpty())
		systemFlags->activate("note");
	else		
		systemFlags->deactivate("note");
	calcBBoxSize();
	positionBBox();	
	move (absPos.x(), absPos.y() );
	forceReposition();
	
}

QString OrnamentedObj::getNote()
{
    return note.getNote();
}

void OrnamentedObj::toggleStandardFlag(QString f, bool exclusive)
{
	standardFlags->toggle(f,exclusive);
	calcBBoxSize();
	positionBBox();
	move (absPos.x(), absPos.y() );
	forceReposition();
}

void OrnamentedObj::activateStandardFlag(QString f)
{
	standardFlags->activate(f);
	calcBBoxSize();
	positionBBox();
	move (absPos.x(), absPos.y() );
	forceReposition();
}

QString OrnamentedObj::getSystemFlagName(const QPoint &p)
{
	return systemFlags->getFlagName(p);	
}

void OrnamentedObj::updateNoteFlag()
{
	if (selected) 
	{
		// text in NoteEditor has changed, notify MapEditor 
		mapEditor->setChanged();

		// save text
		setNote( textEditor->getText() );
	
		// save font   
		note.setFontHint (textEditor->getFontHint() );
	}	
}

