#include <qdatetime.h>

#include "mapcenterobj.h"
#include "floatimageobj.h"
#include "mapeditor.h"

/////////////////////////////////////////////////////////////////
// MapCenterObj
/////////////////////////////////////////////////////////////////
MapCenterObj::MapCenterObj() : BranchObj ()
{
//    cout << "Const MapCenterObj\n";
    init();
}

MapCenterObj::MapCenterObj(QCanvas* c) : BranchObj (c)
{
//    cout << "Const MapCenterObj   canvas="<<c<<"\n";
    init();
}

MapCenterObj::~MapCenterObj() 
{
//    cout << "Destr MapCenterObj\n";
}	

void MapCenterObj::clear() 
{
	BranchObj::clear();
    init();
}

void MapCenterObj::init () 
{
	BranchObj::init();
    orientation=OrientUndef;
    absPos=QPoint (canvas->width()/2, canvas->height()/2);

	// FIXME this should be done in TextObj later...
	QFont font ("Sans Serif,16,-1,5,50,0,0,0,0,0");		
	heading->setFont(font);

	depth=0;

	frame->setFrameType (Rectangle);
	move (absPos.x(), absPos.y() );
}

void MapCenterObj::move (double x, double y)
{
	BranchObj::move(x,y);
	positionBBox();
}

void MapCenterObj::moveBy (double x, double y)
{
	BranchObj::moveBy(x,y);
	positionBBox();
}

void MapCenterObj::moveAll (double x, double y)
{
	// Get rel. position
	double dx=x-absPos.x();
	double dy=y-absPos.y();

	// Move myself and branches
	moveAllBy (dx,dy);
}

void MapCenterObj::moveAllBy (double dx, double dy)
{
	// Move myself
	moveBy(dx,dy);

	positionBBox();
}

void MapCenterObj::updateLink()
{
	// set childPos to middle of MapCenterObj
	childPos=QPoint(
		absPos.x() + QSize(getSize() ).width()/2, 
		absPos.y() + QSize(getSize() ).height()/2);
	parPos=childPos;		
	BranchObj *b;
	for (b=branch.first(); b; b=branch.next() )
		b->updateLink();
}

LinkableMapObj* MapCenterObj::findMapObj(QPoint p, LinkableMapObj *excludeLMO)
	{
	BranchObj *bo;
	LinkableMapObj *lmo;

	// Search through child branches
	for (bo=branch.first(); bo; bo=branch.next() )
	{	
		lmo = bo->findMapObj(p, excludeLMO);
		
		if (lmo!= NULL) 
		{
			return lmo;
		}	
	}
	// is p in MapCenter?
	if (inBBox (p) && (this != excludeLMO) ) return this;

	// Search float images
	FloatImageObj *foi;
	for (foi=floatimage.first(); foi; foi=floatimage.next() )
		if (foi->inBBox(p) && (foi != excludeLMO) && foi->getParObj()!= excludeLMO) return foi;

	// nothing found
	return NULL;
}

QString MapCenterObj::saveToDir (const QString &tmpdir,const QString &prefix, int verbose, const QPoint &offset)
{
    QString s,a;

	// save area, if not scrolled
	QString areaAttr=
		attribut("x1",QString().setNum(absPos.x()-offset.x(),10)) +
		attribut("y1",QString().setNum(absPos.y()-offset.y(),10)) +
		attribut("x2",QString().setNum(absPos.x()+width()-offset.x(),10)) +
		attribut("y2",QString().setNum(absPos.y()+height()-offset.y(),10));
	
	 QString urlAttr;
	 if (!url.isEmpty())
	 	urlAttr=attribut ("url",url);
	 
		QString vymLinkAttr;
	 if (!vymLink.isEmpty())
		vymLinkAttr=attribut ("vymLink",convertToRel(mapEditor->getDestPath(),vymLink) );

	
    s=beginElement ("mapcenter" 
		+attribut("absPosX",QString().setNum(absPos.x(),10))
		+attribut("absPosY",QString().setNum(absPos.y(),10))
		+vymLinkAttr
		+urlAttr
		+attribut("frameType",frame->getFrameTypeName()) 
		+areaAttr 
		);
		
    incIndent();
    if (heading->getColor()!=QColor("black"))
		a=attribut ("textColor",QColor(heading->getColor()).name() );
    else	
		a="";
    
	// Save flags. If verbose is set (export to xml dir), also write
	// the flags as picture
	s+=standardFlags->saveToDir(tmpdir+"/flags", "/standardFlag-", verbose);
    s=s+valueElement("heading", getHeading(),a);

	// Reset the counters before saving
	FloatImageObj (canvas).resetSaveCounter();

	// add link to file in s
	if (!note.isEmpty() )
		s+=note.saveToDir();
	
	// Save branches
    BranchObj *bo;
    for (bo=branch.first(); bo; bo=branch.next() )
		s+=bo->saveToDir(tmpdir,prefix, offset);

	// Save FloatImages
	FloatImageObj *fio;
	for (fio=floatimage.first(); fio; fio=floatimage.next() )
		s+=fio->saveToDir (tmpdir,prefix);

	// Save XLinks
	XLinkObj *xlo;
    for (xlo=xlink.first(); xlo; xlo=xlink.next() )
		s+=xlo->saveToDir();

    decIndent();
    s+=endElement   ("mapcenter");
    return s;
}

void MapCenterObj::setVersion (const QString &s)
{
	version=s;
}

bool MapCenterObj::checkVersion ()
{
	// returns true, if vym is able to read file regarding 
	// the version set with setVersion
	QString s1=version.section (".",0,0);
	QString s2=version.section (".",1,1);
	QString s3=version.section (".",2,2);
	bool ok;
	int vv1 =QString(__VYM_VERSION__).section (".",0,0).toInt(&ok,10);
	int vv2 =QString(__VYM_VERSION__).section (".",1,1).toInt(&ok,10);
	int vv3 =QString(__VYM_VERSION__).section (".",2,2).toInt(&ok,10);
	int mv1=0;
	int mv2=0;
	int mv3=0;
	if (!s1.isEmpty() ) mv1=s1.toInt(&ok,10);
	if (!s2.isEmpty() ) mv2=s2.toInt(&ok,10);
	if (!s3.isEmpty() ) mv3=s3.toInt(&ok,10);
	
	if (vv1 > mv1)
		return true;
	if (vv1 < mv1)
		return false;
	if (vv2 > mv2)
		return true;
	if (vv2 < mv2)
		return false;
	if (vv3 > mv3)
		return true;
	if (vv3 < mv3)
		return false;
	return true;	
}

void MapCenterObj::setAuthor (const QString &s)
{
	author=s;
}

QString MapCenterObj::getAuthor()
{
	return author;
}

void MapCenterObj::setComment (const QString &s)
{
	comment=s;
}

QString MapCenterObj::getComment ()
{
	return comment;
}

QString MapCenterObj::getDate ()
{
	return QDate::currentDate().toString ("yyyy-MM-dd");
}

