#include "flagobj.h"

/////////////////////////////////////////////////////////////////
// FlagObj
/////////////////////////////////////////////////////////////////
FlagObj::FlagObj()
{
//    cout << "Const FlagObj ()\n";
    init ();
}

FlagObj::FlagObj(QCanvas* c):MapObj(c) 
{
//    cout << "Const FlagObj\n";
    init ();
}

FlagObj::FlagObj (FlagObj* io)
{
    copy (io);
}

FlagObj::~FlagObj()
{
//    cout << "Destr FlagObj  " << name << "\n";
	delete (icon);
}


void FlagObj::init ()
{
	name="undefined";
	group="undefined";

	icon=new ImageObj (canvas);
	icon->move (absPos.x(), absPos.y() );
	button=NULL;
	state=false;
}

void FlagObj::copy (FlagObj* other)
{
    MapObj::copy(other);
	name=other->name;
	group=other->group;
	tooltip=other->tooltip;
	state=other->state;
	icon->copy(other->icon);
	setVisibility (other->isVisibleObj() );
	// button is not copied, because
	// we won't copy to a parentRow and
	// all others don't need a button
}

void FlagObj::move(double x, double y)
{
    MapObj::move(x,y);
	icon->move(x,y);
	positionBBox();
}

void FlagObj::moveBy(double x, double y)
{
    move (x+absPos.x(),y+absPos.y() );
}

void FlagObj::setVisibility (bool v)
{
    MapObj::setVisibility(v);
	if (v && state)
	    icon->setVisibility(true);
	else
	    icon->setVisibility(false);
}

void FlagObj::load (const QString &fn)
{
	icon->load(fn);
	calcBBoxSize();
	positionBBox();
}

void FlagObj::load (const QPixmap &pm)
{
	icon->load(pm);
	calcBBoxSize();
	positionBBox();
}

void FlagObj::setName(const QString &n)
{
	name=n;
}

const QString FlagObj::getName()
{
	return name;
}

void FlagObj::setGroup (const QString &n)
{
	group=n;
}

const QString FlagObj::getGroup()
{
	return group;
}

void FlagObj::setToolTip(const QString &n)
{
	tooltip=n;
}

const QString FlagObj::getToolTip()
{
	return tooltip;
}

void FlagObj::setButton(QAction* b)
{
    button=b;
}

void FlagObj::updateButton()
{
	if (button)
		button->setOn(state);
	else
		qWarning ("FlagObj::updateButton  no button defined");
}

QPixmap FlagObj::getPixmap()
{
	return icon->getPixmap();
}

bool FlagObj::isActive()
{
	return state;
}

void FlagObj::toggle()
{
	if (state)
		deactivate();
	else
		activate();
}

void FlagObj::activate()
{
	state=true;
	// only show icon, if flag itself is visible 
	if (visible) 
	{
		icon->setVisibility (true);
		calcBBoxSize();
	}	
}

void FlagObj::deactivate()
{
	state=false;
	// if flag itself is invisible we don't need to call 
	if (visible) 
	{
		icon->setVisibility (false);
		calcBBoxSize();
	}	
}

void FlagObj::setEnabled(bool b)
{
	button->setEnabled (b);
}	
	

void FlagObj::setUsed (bool b)
{
	used=b;
}

bool FlagObj::isUsed()
{
	return used;
}

void FlagObj::saveToDir (const QString &tmpdir, const QString &prefix)
{
	QString fn=tmpdir + prefix + name + ".png";
	icon->save (fn,"PNG");
}

void FlagObj::positionBBox()
{
    bbox.setX (absPos.x() );
    bbox.setY (absPos.y() );
}

void FlagObj::calcBBoxSize()
{
	if (visible && state)
	{
		bbox.setSize (	QSize(
			icon->boundingRect().width(), 
			icon->boundingRect().height() ) );
	} else
	{
		bbox.setSize (QSize(0,0));
	}
}

