# Именованные представления

Иногда вам необходимо отображать сразу несколько представлений, а не вкладывать одно из них в другое — например, при создании шаблона с представлением `sidebar` для боковой панели и представлением `main` для основного содержимого. В этой ситуации будет удобно использовать именованные представления. Вместо указания единственного `<router-view>`, можно использовать несколько, присвоив каждому собственное имя. Безымянный `router-view` автоматически получает имя `default`.

``` html
<router-view class="view one"></router-view>
<router-view class="view two" name="a"></router-view>
<router-view class="view three" name="b"></router-view>
```

При использовании нескольких представлений, вместо единственного компонента при описании пути необходимо указывать объект. Убедитесь, что в ключе `components` используете окончание множественного числа (`s`):

``` js
const router = new VueRouter({
  routes: [
    {
      path: '/',
      components: {
        default: Foo,
        a: Bar,
        b: Baz
      }
    }
  ]
})
```

Рабочую демонстрацию этого примера можно найти [здесь](https://jsfiddle.net/posva/6du90epg/).

## Вложенные именованные представления

Возможно и создание более сложных шаблонов, используя именованные представления с вложенными представлениями. При этом вам также нужно будет именовать используемые вложенные компоненты `router-view`. Разберём на примере панели настроек:

```
/settings/emails                                       /settings/profile
+-----------------------------------+                  +------------------------------+
| UserSettings                      |                  | UserSettings                 |
| +-----+-------------------------+ |                  | +-----+--------------------+ |
| | Nav | UserEmailsSubscriptions | |  +------------>  | | Nav | UserProfile        | |
| |     +-------------------------+ |                  | |     +--------------------+ |
| |     |                         | |                  | |     | UserProfilePreview | |
| +-----+-------------------------+ |                  | +-----+--------------------+ |
+-----------------------------------+                  +------------------------------+
```

- `Nav` это просто обычный компонент
- `UserSettings` компонент представления
- `UserEmailsSubscriptions`, `UserProfile`, `UserProfilePreview` вложенные компоненты представлений

**Примечание**: _Давайте опустим как должен выглядеть HTML/CSS для реализации подобного шаблона и сосредоточимся на используемых компонентах_

Секция `<template>` компонента `UserSettings` будет выглядеть примерно так:

```html
<!-- UserSettings.vue -->
<div>
  <h1>Настройки пользователя</h1>
  <NavBar/>
  <router-view/>
  <router-view name="helper"/>
</div>
```

_Вложенные компоненты представлений в примере опущены, но вы можете посмотреть их полные исходные коды [здесь](https://jsfiddle.net/posva/22wgksa3/)_

Затем вы можете скомпоновать шаблона выше в конфигурации маршрута:

```js
{
  path: '/settings',
  // Вы могли также иметь именованные представления выше
  component: UserSettings,
  children: [{
    path: 'emails',
    component: UserEmailsSubscriptions
  }, {
    path: 'profile',
    components: {
      default: UserProfile,
      helper: UserProfilePreview
    }
  }]
}
```

Рабочую демонстрацию этого примера можно найти [здесь](https://jsfiddle.net/posva/22wgksa3/).
