#! /bin/bash

# compile all examples

for f in $@
do
  body=$(basename $f .cc)
  common_flags="-O3 -fno-math-errno -Wno-abi -std=c++11 -march=native -mavx2 -pthread"

  for compiler in g++
  do
  
    echo compiling $body with:

    echo $compiler $common_flags -otv_$body $f -lvigraimpex
    $compiler $common_flags -otv_$body $f -lvigraimpex
    
    echo $compiler -DUSE_VC $common_flags -o$body $f -lVc -lvigraimpex
    $compiler -DUSE_VC $common_flags -o$body $f -lVc -lvigraimpex

  done

done
