#!/bin/sh
# Produce some XML statistics about vservers
USR_SBIN=/usr/sbin
cd /etc/vservers
for vserv in *.conf
do
	vserv=`basename $vserv .conf`
	. /etc/vservers/$vserv.conf
	echo "<m:vserver name=\"$vserv\" onboot=\"$ONBOOT\" HOSTNAME=\"$S_HOSTNAME\">"
	for ip in $IPROOT
	do
		case $ip in
		*:*)
			echo $ip | tr ':' ' ' | (read a b; echo "  <m:ip num=\"$b\"/>")
			;;
		*)
			echo "  <m:ip num=\"$ip\"/>"
			;;
		esac
	done
	echo "  <status>"
	$USR_SBIN/vserver $vserv status
	echo "  </status>"
	echo "</m:vserver>"
done

