/*
	This is the old syscalls for the vserver 1.0x kernels.
	Newer kernels have a single system call number to dispatch
	all the sub-syscall. The system call is now official.
*/
/*
	This tells the system call number for new_s_context and set_ipv4root
	using /proc/self/status. This helps until the vserver project is
	included officially in the kernel (and has its own syscall).

	We rely on /proc/self/status to find the syscall number.

	If it is not there, we rely on adm/unistd.h.

	If this file does not have those system calls (not a patched kernel source)
	we rely on static values in this file.
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <syscall.h>
#include <asm/unistd.h>

// Here is the trick. We keep a copy of the define, then undef it
// and then later, we try to locate the value reading /proc/self/status
// If this fails, we have the old preserved copy.
static int def_NR_set_ipv4root = 227;
#undef __NR_set_ipv4root

static int __NR_set_ipv4root_rev0;
static int __NR_set_ipv4root_rev1;
static int __NR_set_ipv4root_rev2;
static int __NR_set_ipv4root_rev3;
static int rev_ipv4root=0;

_syscall1(int, set_ipv4root_rev0, unsigned long, ip);
_syscall2(int, set_ipv4root_rev1, unsigned long, ip, unsigned long, bcast);
_syscall3(int, set_ipv4root_rev2, unsigned long *, ip, int, nb, unsigned long, bcast);
_syscall4(int, set_ipv4root_rev3, unsigned long *, ip, int, nb, unsigned long, bcast, unsigned long *, mask);

static int def_NR_new_s_context = 226;
#undef __NR_new_s_context
static int __NR_new_s_context_rev0;
static int __NR_new_s_context_rev1;
static int rev_s_context=0;

_syscall3(int, new_s_context_rev0, int, newctx, int, remove_cap, int, flags);
_syscall4(int, new_s_context_rev1, int, nbctx, int *, ctxs, int, remove_cap, int, flags);

#undef __NR_set_ctxlimit
static int __NR_set_ctxlimit=-1;
static int rev_set_ctxlimit=-1;

_syscall2 (int, set_ctxlimit, int, resource, long, limit);

#undef __NR_chrootsafe
static int __NR_chrootsafe=-1;
static int rev_chrootsafe=-1;

_syscall1 (int, chrootsafe, const char *, dir);

static void init()
{
	static int is_init = 0;
	if (!is_init){
		FILE *fin = fopen ("/proc/self/status","r");
		__NR_set_ipv4root_rev0 = def_NR_set_ipv4root;
		__NR_set_ipv4root_rev1 = def_NR_set_ipv4root;
		__NR_set_ipv4root_rev2 = def_NR_set_ipv4root;
		__NR_set_ipv4root_rev3 = def_NR_set_ipv4root;
		__NR_new_s_context_rev1 = def_NR_new_s_context;
		if (fin != NULL){
			char line[100];
			while (fgets(line,sizeof(line)-1,fin)!=NULL){
				int num;
				char title[100],rev[100];
				rev[0] = '\0';
				if (sscanf(line,"%s %d %s",title,&num,rev)>=2){
					if (strcmp(title,"__NR_set_ipv4root:")==0){
						__NR_set_ipv4root_rev0 = num;
						__NR_set_ipv4root_rev1 = num;
						__NR_set_ipv4root_rev2 = num;
						__NR_set_ipv4root_rev3 = num;
						if (strncmp(rev,"rev",3)==0){
							rev_ipv4root = atoi(rev+3);
						}
					}else if (strcmp(title,"__NR_set_ctxlimit:")==0){
						__NR_set_ctxlimit = num;
						if (strncmp(rev,"rev",3)==0){
							rev_set_ctxlimit = atoi(rev+3);
						}
					}else if (strcmp(title,"__NR_chrootsafe:")==0){
						__NR_chrootsafe = num;
						if (strncmp(rev,"rev",3)==0){
							rev_chrootsafe = atoi(rev+3);
						}
					}else if (strcmp(title,"__NR_new_s_context:")==0){
						__NR_new_s_context_rev0 = num;
						__NR_new_s_context_rev1 = num;
						if (strncmp(rev,"rev",3)==0){
							rev_s_context = atoi(rev+3);
						}
					}
				}
			}
			fclose (fin);
		}
		is_init = 1;
	}
}

extern "C" int call_old_new_s_context(int nbctx, int ctxs[], int remove_cap, int flags)
{
	int ret = -1;
	init();
	if (rev_s_context == 0){
		if (nbctx > 1){
			errno = EINVAL;
			fprintf (stderr,"The current kernel does not support new_s_context revision 1\n");
		}else if (nbctx == 0){
			ret = new_s_context_rev0(-2,remove_cap,flags);
		}else if (nbctx == 1){
			ret = new_s_context_rev0(ctxs[0],remove_cap,flags);
		}
	}else if (rev_s_context == 1){
		ret = new_s_context_rev1(nbctx,ctxs,remove_cap,flags);
	}else{
		fprintf (stderr,"kernel support new_s_context version %d and chcontext only support version 0 and 1\n"
			,rev_s_context);
	}
	return ret;
}

extern "C" int call_old_set_ipv4root (
	unsigned long ip[],
	int nb,
	unsigned long bcast,
	unsigned long mask[])
{
	init();
	if (rev_ipv4root == 0){
		if (nb > 1){
			fprintf (stderr,"set_ipv4root: Several IP number specified, but this kernel only supports one. Ignored\n");
		}
		return set_ipv4root_rev0 (ip[0]);
	}else if (rev_ipv4root == 1){
		if (nb > 1){
			fprintf (stderr,"set_ipv4root: Several IP number specified, but this kernel only supports one. Ignored\n");
		}
		return set_ipv4root_rev1 (ip[0],bcast);
	}else if (rev_ipv4root == 2){
		return set_ipv4root_rev2 (ip,nb,bcast);
	}else if (rev_ipv4root == 3){
		return set_ipv4root_rev3 (ip,nb,bcast,mask);
	}else{
		fprintf (stderr,"Kernel support set_ipv4root version %d and chbind only sypport version 0,1,2,3\n"
			,rev_ipv4root);
	}
	errno = EINVAL;
	return -1;
}

extern "C" int call_chrootsafe (const char *dir)
{
	init();
	if (rev_chrootsafe == -1){
		fprintf (stderr,"chrootsafe: Unsupported system call, update kernel\n");
	}else if (rev_chrootsafe == 0){
		return chrootsafe (dir);
	}else{
		fprintf (stderr,"chrootsafe: kernel support version %d, application expects version 0\n"
			,rev_chrootsafe);
	}
	errno = EINVAL;
	return -1;
}

/*
	Return != 0 if chrootsafe is available
*/
extern "C" int has_chrootsafe()
{
	init();
	return rev_chrootsafe != -1;
}

extern "C" int call_old_set_ctxlimit (int res, long limit)
{
	init();
	if (rev_set_ctxlimit == -1){
		fprintf (stderr,"set_ctxlimit: Unsupported system call, update kernel\n");
	}else if (rev_set_ctxlimit == 0){
		return set_ctxlimit (res,limit);
	}else{
		fprintf (stderr,"set_ctxlimit: kernel support version %d, application expects version 0\n"
			,rev_set_ctxlimit);
	}
	errno = EINVAL;
	return -1;
}


