//<copyright>
//
// Copyright (c) 1994-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name :       madjust.h
//
// Purpose :    Interface to class MAdjustable
//
// Created :    12 Apr 94    Bernhard Marschall
// Modified :   19 Jan 95    Bernhard Marschall
//
// $Id: madjust.h,v 1.1 1996/03/12 16:54:59 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: madjust.h,v $
// Revision 1.1  1996/03/12 16:54:59  bmarsch
// Initial revision
//


#ifndef hg_widgets_madjust_h
#define hg_widgets_madjust_h

#include "libwidgets.h"
#include "adjvalue.h"
class Color;


//<class>
//
// Name:    MAdjustable
//
// Purpose: Adjustable to scroll one value and mark an interval
//
// Public Interface:
//
// - MAdjustable(float lower, float upper)
//   Constructor, sets lower and upper bound for scrollable value
//
// - ~MAdjustable()
//   Destructor.
//
// - void set_value(float val)
//   sets the scrollable value.
//
// - virtual float markLower() const
// - virtual float markUpper() const
//   return the boundaries of currently marked interval.
//
// - virtual void startMarking(float lower)
//   start marking a new interval at value 'lower'.
//
// - virtual void stopMarking(float upper)
//   stop marking a new interval at value 'upper'.
//
// - virtual void setMarked(float lower, float upper)
//   set the marked interval to [lower;upper]. MAdjustable do *not*
//   (and cannot) redraw the scrollbar (since it's not known)!
//
// - virtual void resetMarked()
//   clear the marked interval. MAdjustable do *not* (and cannot)
//   redraw the scrollbar (since it's not known)!
//
// - const Color* drawColor() const
//   returns the colour for drawing the marked interval.
//
// - void markColor(const Color*)
//   sets color for "interactively" marked intervals (ie. intervals
//   marked with startMarking/stopMarking, normally called by a
//   MSlider).
//
// - void setColor(const Color*)
//   sets color for "set" marked intervals (ie. intervals set from
//   "outside" with set(lower, upper).
//
//
// Description:
//   MAdjustable adds functionality to AdjValue to be able to mark an
//   interval. It used by MSlider to store the current bounds of the
//   marked interval.
//
//</class>

class MAdjustable : public AdjValue {
public:
  MAdjustable(float lower = 0.0, float upper = 1.0);
  virtual ~MAdjustable();

  void set_value(float val);

  virtual float markLower() const;        // lower bound of marked interval
  virtual float markUpper() const;        // upper bound of marked interval

  virtual void startMarking(float);       // start marking interval at value
  virtual void stopMarking(float);        // stop marking interval at value

  virtual void setMarked(float lower, float upper);  // set marked interval
  virtual void resetMarked();             // clear marked interval

  virtual const Color* drawColor() const; // returns color to draw with
  virtual void markColor(const Color*);
  virtual void setColor(const Color*);

protected:
  float markLower_;         // lower limit of marked interval
  float markUpper_;         // upper limit of marked interval
  boolean marking_;         // true during marking

  const Color* drawColor_;  // colour currently used for drawing
  const Color* markColor_;  // colour for start-/stopMarking()
  const Color* setColor_;   // colour for set()
};


inline float MAdjustable::markLower() const {
  return markLower_;
}

inline float MAdjustable::markUpper() const {
  return markUpper_;
}

inline const Color* MAdjustable::drawColor() const {
  return drawColor_;
}

inline void MAdjustable::resetMarked() {
  setMarked(0.0, 0.0);
}

#endif
