//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>



//<file>
//
//
// Name:        $RCSfile: dateeditor.h,v $
//
// Purpose:     Interface to class DateEditor
//
// Created:     19 Sept. 96 Thomas Starlinger
// Modified:    $Date: 1996/09/20 13:45:37 $
//
// Description: Puts a date and/or time editor to the users disposal. 
//
// Function:    The date and time fields are up and down counted by steppers
//              which control the AdjValue of the FieldEditor31 that has the
//              focus.
//
// $Log: dateeditor.h,v $
// Revision 1.2  1996/09/20 13:45:37  bmarsch
// Corrected includes
//
// Revision 1.1  1996/09/20 13:29:57  bmarsch
// Initial revision
//
// Revision 1.1  1996/09/20 13:08:06  tstar
// Initial revision
//
//
//</file>

#ifndef harmony_widgets_dateeditor_h
#define harmony_widgets_dateeditor_h

#include <InterViews/input.h>
#include <IV-look/kit.h>
#include "libwidgets.h"
#include "adjvalue.h"
#include <hyperg/utils/str.h>
#include <hyperg/utils/environ.h>

class WidgetKit;
class LayoutKit;
class NumberEditor;

//<class>
//
// Name:             DateStepper
//
// Purpose:          Editor for date and time 
//
// Public Interface:
//
// Description:      Stepper button for the DateEditor. Executes action_ repeatedly
//                   after timer interval.
//
//</class>

class DateStepper: public Stepper {
public:
  DateStepper(Glyph* g, Style* s, TelltaleState* t, Action* a): Stepper(g,s,t,a), action_(a) {}
  ~DateStepper() {}

  void press(const Event& e) { start_stepping(); }
  void release(const Event& e) { stop_stepping(); }

protected:
  virtual void adjust() { action_->execute(); }
private:
  Action* action_;
  AdjValue* curAdj_;
};

//<class>
//
// Name:             DateEditor
//
// Purpose:          Editor for date and time 
//
// Public Interface: 
//
// Description:
//
// Public Interface:
//
// -  DateEditor(long now=0, Type type=DATETIME)
// -  DateEditor(RString now, Type type=DATETIME)
//
// -  void init(RString, Type);
//
// -  virtual ~DateEditor();
//
// -  void setValue(RString value): 
// -  void setValue(long now=0): Set the information in the Date/Time Editor.
//           value is string value in Hyper-G date/time format ("96/09/19 12:00:15")
//           now is a long as used in the time.h system interface.
//
// -  RString getValue() const: Get Date/Time Editor information (RString, in
//                              Hyper-G date/time string format.
//
// -  void setLastAdj(int): Set the AdjValue that is controlled by DateStepper.
//
// -  void upStep(), void downStep(): Scroll a small step for- or backward.
//
// Private Interface:
//
// -  int lenFeb(int): Calculate length of month february according to year.
//
// -  void monChanged(): If month or year changes -> see that the day
//                       value is within the correct boundaries.
//
//
//</class>


class DateEditor : public InputHandler {
public:
  enum Type {
    DATE=0x0001,
    TIME=0x0002,
    DATETIME=DATE|TIME,
    TYPEEND
  };

  enum Months { M_JAN=1, M_FEB, M_MAR, M_APR, M_MAI, M_JUN, M_JUL,
                M_AUG, M_SEP, M_OKT, M_NOV, M_DEC, MONTH_END };

  DateEditor(long now=0, Type type=DATETIME)
    : InputHandler(nil, WidgetKit::instance()->style())
  { init(Environ::timeString(now), type); }

  DateEditor(RString now, Type type=DATETIME)
    : InputHandler(nil, WidgetKit::instance()->style())
  { init(now, type); }
  
  void init(RString, Type);

  virtual ~DateEditor();

  void setValue(RString value);     // set value
  void setValue(long now=0) { setValue(Environ::timeString(now)); }
  RString getValue() const;         // read current value

  // Set last AdjValue.
  void setLastAdj(int);
  void upStep() { lastAdj_->scroll_forward(Dimension_X); }
  void downStep() { lastAdj_->scroll_backward(Dimension_X); }

private:
  // Date
  NumberEditor* neYear_;
  AdjValue*     adYear_;
  NumberEditor* neMonth_;
  AdjValue*     adMonth_;
  NumberEditor* neDay_;
  AdjValue*     adDay_;
  // Time
  NumberEditor* neHour_;
  AdjValue*     adHour_;
  NumberEditor* neMinute_;
  AdjValue*     adMinute_;
  NumberEditor* neSecond_;
  AdjValue*     adSecond_;

  // Widget- and LayoutKit.
  WidgetKit *kit_;
  LayoutKit *layout_;

  // AdjValue which had the last focus.
  AdjValue* lastAdj_;

  // Length of febrauary in respect to year.
  int lenFeb(int);

  // Month changed -> check contraints for days.
  void monChanged();

  // Date, Time or DateTime editor.
  int type_;

  // Month lengths.
  static const int monLength[MONTH_END];
};

#endif /* harmony_widgets_dateeditor_h */
