// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1993,94,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        hg3dopt.h
//
// Purpose:     Scene viewer options and their default values
//
// Created:      7 Jun 93   Michael Pichler
//
// Changed:     23 May 97   Michael Pichler
//
//
// Description
// -----------
//
// Commandline options description and
// default properties (X attributes)
// for the Hyper-G 3D scene viewer
//
// see SceneViewer.ad for documentation of X attributes
//
// should only be included into one file to avoid multiple string definitions
// (otherwhise have to split into .h and .C)
//
// $Id: hg3dopt.h,v 1.22 1997/05/26 17:30:22 mpichler Exp $
//
//</file>


#ifndef harmony_scene_hg3dopt_h
#define harmony_scene_hg3dopt_h

#include <InterViews/session.h>



// command line options

OptionDesc hg3d_options [] =
{
  { "-bg3d",        "*Scene.3D.background", OptionValueNext },
  { "-demos",       "*DemoMenuItems",     OptionValueImplicit, "on" },
  { "-draw",        "*drawmode",          OptionValueNext },
  { "-drawmode",    "*drawmode",          OptionValueNext },
  { "-indirect",    "*indirectRendering", OptionValueImplicit, "on" },
  { "-singlebuf",   "*single_buffered",   OptionValueImplicit, "on" },
  { "-mesabackbuf", "*mesabackbuf",       OptionValueNext },
  { "-alphaplanes", "*alphaBitplanes",    OptionValueImplicit, "on" },
  { "-intdraw",     "*intdrawmode",       OptionValueNext },
  { "-intdrawmode", "*intdrawmode",       OptionValueNext },
  { "-noasmooth",   "*autosmooth",        OptionValueImplicit, "off" },
  { "-noconvexify", "*convexify",         OptionValueImplicit, "off" },
  { "-speed",       "*speedFactor",       OptionValueNext },
  { "-lang",        "*language",          OptionValueNext },
  { "-language",    "*language",          OptionValueNext },
  { "-URL",         "*URL",               OptionValueNext },
  { "-remote",      "*remote",            OptionValueNext },
  { "-getRemoteID", "*getRemoteID",       OptionValueImplicit, "on" },
  { "-remoteView",  "*remoteView",        OptionValueImplicit, "on" },
  { "-helpDir",     "*helpDir",           OptionValueNext },
  { "-fontDir",     "*fontDir",           OptionValueNext },
  { "-fontFileBase","*fontFileBase",      OptionValueNext },
  { "-proxy",       "*proxy",             OptionValueNext },
  { "-mosaic",      "*mosaic",            OptionValueImplicit, "on" },
  { "-local",       "*localInlines",      OptionValueImplicit, "on" },
  { "-nouseragent", "*sendUserAgent",     OptionValueImplicit, "off" },
  { "-special",     "*SpecialMenuItems",  OptionValueImplicit, "on" },
  { "-verbose",     "*verbose",           OptionValueImplicit, "on" },
  { "-h",           "*commandlinehelp",   OptionValueImplicit, "on" },
  { "-help",        "*commandlinehelp",   OptionValueImplicit, "on" },
  { "--help",       "*commandlinehelp",   OptionValueImplicit, "on" },
  { nil }
};



// explanation of command line options common to standalone and integrated viewer

const char* const commonViewerOptions =
  "  -verbose       verbose output (incl. IPC communication)\n"
  "  -lang[uage] lg [english|german|french|italian|spanish|korean|japanese|styrian]\n"
  "  -URL url       base url for relative references\n"
  "  -helpDir dir   directory of (or URL pointing to) on-line help files\n"
  "  -bg3d color    scene area background color\n"
  "  -draw[mode]    drawing mode: [wireframe|hiddenline|flat|smooth|texturing]\n"
  "  -intdraw[mode] interactive: one of the above or \"same\"\n"
  "  -speed         (overall) speed factor for navigation\n"
  "  -alphaplanes   inquire visual with alpha-bitplanes\n"
  "  -mesabackbuf   backbuffer for Mesa: [pixmap|image|auto]\n"
  "  -singlebuf     turn off double buffering for 3D renderings\n"
  "  -indirect      render OpenGL through X-server (slower)\n"
  "  -proxy host:p  proxy host and port number\n"
  "  -mosaic        use mosaic for anchor requests (else netscape)\n"
  "  -local         read WWWInline and Texture2 from local files\n"
  "\n"
  "  -bg background, -fg foreground, -flat col, -font fn,\n"
  "  -display dis, -visual vClass, -visual_id 0xID, -dbuf, -nodbuf,\n"
  "  -sgimotif, -motif, -openlook, -xrm '*attribute:value'\n";



// default properties (X attributes)

// X attributes have the following priority order:
// 1. command line arguments
// 2. user defaults, loaded with xrdb (usually .Xdefaults)
// 3. application defaults (usually in /usr/lib/X11/app-defaults)
// 4. the values set below


PropertyData hg3d_props [] =
{
  // global Harmony resources (same for all viewers)
  { "*gui",                       "SGIMotif" },
  { "*double_buffered",           "on" },
  { "*PopupWindow*overlay",       "false" },
  { "*PopupWindow*saveUnder",     "on" },
  { "*TransientWindow*saveUnder", "on" },
  { "*foreground",                "black" },
  { "*background",                "#EEEEEE" },
  { "*flat",                      "#BBBBBB" },
  { "*font",                      "-*-new century schoolbook-medium-r-*-*-17-*-*-*-*-*-*-*" },
  { "*FieldEditor.flat",          "#FFB6B7" },
  { "*FieldEditor.background",    "#FFB6B7" },
  { "*FieldEditor.modifiedColour","#FFCEFF" },
  { "*Progress.foreground",       "#001B48" },
  { "*Progress.background",       "#888888" },
  { "*ProgressLabel.foreground",  "white" },
  { "*sliderSize",                "18" },
  { "*moverSize",                 "18" },
  { "*icons",                     "on" },
  { "*BubbleWindow.shape",        "rectangle" },
  { "*BubbleWindow.brush",        "1.0" },
  { "*BubbleWindow.background",   "#ffe4b7" },
  { "*clickDelay",                "500" },

  // Scene Viewer specific resources
//{ "*3D.background",             "#CCCCCC" },  // for 6x6x6 color map
  { "*3D.background",             "#C0C0C0" },  // for 5x9x5 color map
  { "*pointerColor",              "red" },
  // TrueColor only set when required by implementation (see gecontext.h)
  { "*collisionDetection",        "on" },
  { "*autosmooth",                "on" },
  { "*convexify",                 "on" },
  { "*sendUserAgent",             "on" },
  { "*VRML2_command",             "vrwave -URL '%u' %s" },
  { "*demoPath",                  "./data" },
//{ "*initialDemo",               "test.wrl" },
#ifdef HARMONY3DSCENE
/* integrated harmony 3D scene viewer only */
  { "*DocumentMenuItems",         "on" },
#else
/* standalone 3D scene viewer only */
//{ "*DemoMenuItems",             "on" },
#endif
  { nil }
};


#endif
