/*
 * Copyright (C) 1992 by Software Research Associates, Inc.
 *	Author:	Y. Kawabe <kawabe@sra.co.jp>
 *
 * Permission to use, copy, modify, and distribute, and sell this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Software Research Associates
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#ifndef nls_codeset_h
#define nls_codeset_h

#include <NLS/enter-scope.h>
#include <hyperg/OS/enter-scope.h>

class istream;
class ostream;
class Locale;
class String;
class WChar;

/*
 * class CodeCvt
 */

class CodeCvt {
  public:
    CodeCvt () {};
    virtual ~CodeCvt () {};

  public:
    virtual CodeCvt* duplicate() = 0;
    virtual void setparam(const char*, const char*) {};

  public:
    virtual int get(istream&, WChar&) = 0;
    virtual int put(ostream&, const WChar&) = 0;
};

/*
 * class CodeSet
 */

class CodeCvtTable;

class CodeSet {
  public:
    static WChar* Convert (const Locale& locale, const char*); 
    static WChar* Convert (const Locale& locale, const char*, int len); 
    static char* Convert (const Locale& locale, const WChar*); 
    static char* Convert (const Locale& locale, const WChar*, int len); 

  public:
    static CodeCvt* Find(const Locale&);
    
  private:
    static CodeCvtTable *table_;
};

#endif
