#ifndef WORLD_H
#define WORLD_H

#define WORLD_LEN	64
#define VR_CURR		1
#define VR_NEW		1
#define VR_OLD		0

#define WORLD_TOBUILD		1
#define WORLD_DOWNLOADED	2
#define WORLD_READY		0


/**
 * Universe Class
 */
class Universe {
 public:
  char nameinitial[WORLD_LEN];	///< http server name
  char urlinitial[URL_LEN];	///< url
  char worldinitial[WORLD_LEN];	///< rendez-vous
  char groupinitial[GROUP_LEN];	///< group addr
  uint16_t portinitial;		///< port
  uint8_t ttlorigin;		///< ttl
  uint8_t propinitial;		///< notused

  Universe();

};

class UDialog;
class UBox;

/**
 * World Class
 */
//pd class World : public Universe {	// latter
class World {
 public:
  char name[WORLD_LEN];		///< world name
  char chan[CHAN_LEN];		///< channel string addr/port/ttl
  char url[URL_LEN];		///< url of world descripton
  class User *plocaluser;	///< local user pointer
  class UBox *guip;		///< gui pointer
  class Clock *clock;		///< internal clock
  class Bgcolor *bgcolor;	///< background color
  class Vjc *vjc;		///< vjc
  uint32_t group;		///< current group addr
  uint32_t ssrc;		///< current ssrc id
  int state;			///< current state
  bool isdead;			///< alive or not
  bool islinked;		///< linked world or not
  uint16_t num;			///< world number
  class World *prev;		///< prev world
  class World *next;		///< next world

  World();
  /**< Constructor */

  virtual ~World();
  /**<
   * World destructor.
   * We should never call this method,
   * because worlds are cached in memory and kept in a list.
   */

  static void updateWorld(time_t sec, time_t usec);
  /**< Processes the world */

  virtual void quit();
  /**< Quits current world */

  static World * newWorld(const char *url, const char *chanstr, bool isnew);
  /**< 
   * New World initialization.
   */

  static void deleteObjects();
  /**< Deletes all objects dropped in the todeletelist */

  static void checkIcons();

  static void init(const char *urlvre, const char *localusername, const char *urlfront, const char *urlback);
  /**< General initialization of WO module */

  static void terminate();
  /**< Terminates WO module */

  virtual void addToList();
  /**< Adds world into world list */

  virtual bool call(World *wprev);
  /**<
   * Switch channels.
   * deleteChannel -> newWorld() -> join()
   */

  static World * back();
  /**< Go to the previous World */

  static World * forward();
  /**< Go to the next World */

  static World * swap(World *w);
  /**< Exchange Worlds in the list */

  static bool isLoaded(const char *_url);
  static World * getWorldByUrl(const char *_url);
  static World * getWorldByGroup(const uint32_t group);
  static World * getWorldBySsrc(const uint32_t ssrc);

  static void setLocalName(const char *worldname);
  /**< Sets local world name */

  static World * getCurrentWorld();
  /**< Gets current world */

  static const char * getCurrentName();
  /**< Gets current world name */

  static void setState(int state);
  static int getState();
  static void setDead(bool is);
  static bool isDead();
  static void clearLists();

  static void clearGrid();
  static void freeGrid();

  static void sourceDialog(class UBox *source_box);
  static void worldsDialog(class UBox *worlds_box);

  static void setChannelName(const char *chanstr);
  /**< Sets the channel name */

  static void setChannelNameAndJoin(const char *chanstr);
  /**< Sets the channel name and Join the new channel */

  static const char * getChannelName();
  /**< Gets the current channel string */

  static void setManagerChannelName(const char *chanstr);
  /**< Sets the manager channel name */

  static void setManagerChannelNameAndJoin(const char *chanstr);
  static const char * getManagerChannelName();

};

void cfgHttpReader(void *avre, class Http *http);
int parseCfgLines(char *buf, int size);
char * parseFileLine(char *l);

extern Universe *universe;
extern World *worlds, *manager;

#endif // WORLD_H
