#include "global.h"
#include "wo.h"
#include "names.h"	// initObjectsMame
#include "http.h"	// httpOpen
#include "user.h"	// USER_TYPE
#include "clock.h"	// Clock
#include "bgcolor.h"	// Bgcolor
#include "icon.h"	// ICON_TYPE
#include "vjc.h"	// Vjc
#include "world.h"

#include "net.h"	// createNetObject
#include "vgl.h"	// ~Solid
#include "gui.h"	// GuiUpdateWorld
#include "app.h"	// quitTools 
#include "channel.h"	// Channel::join

#include <ubit/ubit.hpp>	// UDialog


// global variables
World *worlds = NULL;	// World list
World *manager;

// local variables
static User *localUser = NULL;
static uint16_t worldCount = 0;
static uint8_t worldState = 0;
static bool worldIsDead = 0;


/* World constructor */
World::World()
{
  new_world++;
  guip = NULL;
  group = 0;
  ssrc = 0;
  state = 0;
  islinked = false;
  isdead = false;
  clock = new Clock();
  bgcolor = new Bgcolor();
  vjc = NULL;
  prev = NULL;
  next = NULL;
  memset(name, 0, sizeof(name));
  memset(chan, 0, sizeof(chan));
  memset(url, 0, sizeof(url));

  if (worldCount == 0) {
    num = worldCount++;
    return;		// manager case, not in list
  }
  num = worldCount++;	// unused
  trace(DBG_WO, "World: this=%p num=%d", this, num);

  addToList();
}

/* World destructor */
World::~World()
{
  del_world++;
  trace(DBG_FORCE, "~World: Abnormal this=%p name=%s", this, name);
}

/* add world into world list */
void World::addToList()
{
  if (! worlds) {	// first world encountered
    next = prev = NULL;
  }
  else if (worlds != this) {
    next = worlds;
    worlds->prev = this;
    prev = NULL;
  }
  worlds = this;
}

/* Gets current world */
World * World::getCurrentWorld()
{
  return worlds;
}

/* Sets local world name */
void World::setLocalName(const char *_url)
{
  char *p, *q;
  char *tmp = strdup(_url);

  if (!tmp) {
    error("setLocalName: can't strdup url=%s", _url);
    return;
  }
  p = strrchr(tmp, '/') + 1;
  if ((q = strrchr(p, '.')) != NULL)
    *q = '\0';
  strcpy(worlds->name, p);
  free(tmp);
  trace(DBG_WO, "setLocalName: %s", worlds->name);
}

/* Gets current world name */
const char * World::getCurrentName()
{
  return worlds->name;
}

bool World::isLoaded(const char *_url)
{
  for (World *w = worlds; w ; w = w->next) {
    if (! strcmp(w->url, _url))
      return true;
  }
  return false;
}

World * World::getWorldByUrl(const char *_url)
{
  for (World *w = worlds; w ; w = w->next) {
    if (! strcmp(w->url, _url))
      return w;
  }
  return NULL;
}

World * World::getWorldByGroup(const uint32_t _group)
{
  for (World *w = worlds; w ; w = w->next) {
    if (w->group == _group)
      return w;
  }
  return NULL;
}

World * World::getWorldBySsrc(const uint32_t _ssrc)
{
  for (World *w = worlds; w ; w = w->next) {
    if (w->ssrc == _ssrc)
      return w;
  }
  return NULL;
}

int World::getState()
{
  return worldState;
}

void World::setState(int _state)
{
  worldState = _state;
}

bool World::isDead()
{
  return worldIsDead;
}

void World::setDead(bool is)
{
  worldIsDead = is;
}

void World::setManagerChannelName(const char *chan_str)
{
  strcpy(manager->chan, chan_str);
}

void World::setManagerChannelNameAndJoin(const char *chan_str)
{
  strcpy(manager->chan, Channel::joinManager(chan_str));
}

const char * World::getManagerChannelName()
{
  return manager->chan;
}

/* Sets the channel name */
void World::setChannelName(const char *chan_str)
{
  if (!chan_str) {
    error("setChannelName: chan_str NULL");
    return;
  }
  if (*chan_str == '\0') {
    error("setChannelName: chan_str EMPTY");
    return;
  }
  if (worlds)
    strcpy(worlds->chan, chan_str);
  else
    error("setChannelName: worlds NULL");
}

/* Sets the channel name and Join the new channel */
void World::setChannelNameAndJoin(const char *chan_str)
{
  setChannelName(chan_str);
  Channel::join(chan_str);
}

/* Gets the current channel string */
const char * World::getChannelName()
{
  if (worlds)
    return worlds->chan;
  else {
    error("getChannelName: worlds NULL");
    return NULL;
  }
}

/**
 * Updates the World
 */
void World::updateWorld(time_t sec, time_t usec)
{
  ObjectList *pl = NULL;

  switch (getState()) {
  case WORLD_TOBUILD:
    warning("updateWorld: no [end] encountered");
    return;
  case WORLD_DOWNLOADED:
    setState(WORLD_READY);
    worlds->plocaluser->move.perm_sec = sec;
    worlds->plocaluser->move.perm_usec = usec;
    //pd if (stillList)
      stillList->clearIspointedFlag();
    mobileList->clearIspointedFlag();
    return;
  case WORLD_READY:

    //
    // user motions
    //
    worlds->plocaluser->userMovement(sec, usec);

    //
    // objects with imposed motions
    //
    for (pl = mobileList; pl && ! World::isDead(); pl = pl->next)
      pl->pobject->imposedMovement(sec, usec);

    //
    // objects with permanent motions
    //
    for (pl = mobileList; pl ; pl = pl->next)
      pl->pobject->permanentMovement(sec, usec);

    //
    // objects with special motions if any
    //

    //
    // deletes delayed objects to be deleted
    //
    deleteObjects();
    setDead(false);
  }
}

/* Switch channels */
bool World::call(World *wpred)
{
  if (wpred->islinked) {
    newWorld(url, NULL, VR_OLD);
    setChannelName(wpred->chan);
  }
  else {
    trace(DBG_IPMC, "call: leave chan=%s", wpred->chan);
    delete Channel::getCurrentChannel();	// leave current channel
    newWorld(url, NULL, VR_OLD);

    trace(DBG_IPMC, "call: join chan=%s", chan);
    if (Channel::join(chan) == NULL) {	// join previous channel
      trace(DBG_IPMC, "call: can't join chan=%s", chan);
      return 0;
    }
    GuiUpdateWorld(this, VR_CURR);
  }
  return 1;
}

void dumpworldlist(const char *note)
{
  int i=0;
  printf("%s: ", note);
  for (World *wp = worlds; wp && i<10; wp = wp->next, i++) {
    printf("%s -> ", wp->name);
    if (wp == wp->next) {
      printf("loop\n");
      return;
    }
  }
  if (i==10)
    printf("LOOP\n");
  else
    printf("null\n");
}

/* Go to the back World */
World * World::back()
{
  World *worldcurr = worlds;
  World *worldback = worlds->next;

  if (!worldcurr || !worldback) return NULL;

  worldcurr->quit();	// quit current world first

  World *wp;
  for (wp = worldback; wp->next ; wp = wp->next) {
    if (wp == wp->next)
      break;
  }
  wp->next = worldcurr;
  worldcurr->next = NULL;
  worldback->prev = NULL;
  worldcurr->prev = worldback;
  worlds = worldback;
#if 0
  dumpworldlist("back");
#endif

  if (worldback->call(worldcurr))
    return worlds;
  return NULL;
}

/* Go to the next World */
World * World::forward()
{
  World *worldcurr = worlds;
  World *worldforw;

  if (!worldcurr || !worlds->next) return NULL;

  worldcurr->quit();	// quit current world first

  World *wp;
  for (wp = worldcurr; (worldforw = wp->next)->next; wp = wp->next) ;
  worldforw->next = worldcurr;
  worldforw->prev = NULL;
  worldcurr->prev = worldforw;
  wp->next = NULL;
  worlds = worldforw;
#if 0
  dumpworldlist("forw");
#endif

  if (worldforw->call(worldcurr))
    return worlds;
  return NULL;
}

/* Exchange Worlds in the list */
World * World::swap(World *w)
{
  if (worlds == w)
    return worlds;

  if (w->prev)
    w->prev->next = worlds;	// 1
  if (w->next)
    w->next->prev = worlds;	// 2
  if (worlds->next)
    worlds->next->prev = w;	// 3
  worlds->prev = w->prev;	// 4
  World *tmp = worlds->next;
  worlds->next = w->next;	// 5
  w->next = tmp;		// 6
  w->prev = NULL;		// 7
  worlds = w;			// 8
  return worlds;
}

void World::checkIcons()
{
  chdir(vrengicons);
#if HAVE_READDIR
  DIR *dirw = opendir(".");
  if (dirw) {
    struct dirent *dw;

    // find if current world is there
    for (dw = readdir(dirw); dw; dw = readdir(dirw)) {
      struct stat bufstat;
      if (stat(dw->d_name, &bufstat) == 0) {
        if (S_ISDIR(bufstat.st_mode)) {
          if (! strcmp(dw->d_name, worlds->name)) {
            chdir(dw->d_name);
            DIR *diri = opendir(".");
            if (diri) {
              struct dirent *di;

              // find icons in this world
              for (di = readdir(diri); di; di = readdir(diri)) {
                if (stat(di->d_name, &bufstat) == 0) {
                  if (S_ISREG(bufstat.st_mode)) {
                    FILE *fp;
                    if ((fp = fopen(di->d_name, "r")) == NULL) {
                      error("can't open %s/%s/%s", vrengicons, worlds->name, di->d_name);
                      continue;
                    }
                    char vref[BUFSIZ], infos[BUFSIZ], url[URL_LEN];
                    fgets(vref, sizeof(vref), fp);
                    fclose(fp);
                    filename2url(di->d_name, url);
                    sprintf(infos, "<url=\"%s\">&<vref=%s>", url, vref);
                    if (generalActionList[ICON_CREAT][ICON_TYPE].method)
                      generalActionList[ICON_CREAT][ICON_TYPE].method(worlds->plocaluser, infos, 0, 0);
                  }
                }
              }
              closedir(diri);
            }
            break;
          }
        }
      }
    }
    closedir(dirw);
  }
#endif
  chdir(vrengcwd);
}

/* New World initialization */
World * World::newWorld(const char *_url, const char *_chanstr, bool isNewWorld)
{
  clearGrid();
  clearLists();

  if (worlds->plocaluser)
    worlds->plocaluser->clearKeyTab();
  else {
    error("newWorld: plocaluser NULL User=%s url=%s", worlds->plocaluser->name.instance_name, _url);
  }

  if (isLoaded(_url) && isNewWorld) {
    // world already in memory
    World *w = getWorldByUrl(_url);
    worlds = swap(w);
#if 0
  dumpworldlist("old ");
#endif
    if (worlds->guip)
      GuiUpdateWorld(worlds, VR_CURR);
  }

  else if (isNewWorld) {
    // world to be initialized
    new World();

    if (_url) {
      strcpy(worlds->url, _url);
      setLocalName(worlds->url);
    }
#if 0
  dumpworldlist("new ");
#endif
    if (_chanstr) {
      setChannelName(_chanstr);
    }
    worlds->plocaluser = localUser;
    worlds->plocaluser->name.world_name = getCurrentName();

    //usergeom force solid id=2
    worlds->plocaluser->userGeometry(options->skinf, options->skinb);
    worlds->plocaluser->setObjectToSolid();
    worlds->plocaluser->soh->setSolidVisible(false);

    worlds->guip = GuiAddWorld(worlds, VR_CURR);
  }

  else {
    // world already exists
    if (worlds->guip)
      GuiUpdateWorld(worlds, VR_CURR);
  }

  //
  // Place the local user in this world
  //
  if (worlds->plocaluser->have_entry) {
    worlds->plocaluser->pos.z += worlds->plocaluser->height + 0.15;
  }
  else {
    worlds->plocaluser->pos.x = 0;
    worlds->plocaluser->pos.y = 0;
    worlds->plocaluser->pos.z = worlds->plocaluser->height + 0.15;
    worlds->plocaluser->pos.az = 0;
    worlds->plocaluser->pos.ax = 0;
  }

  worlds->plocaluser->enablePermanentMovement();
  worlds->plocaluser->update3D();
  worlds->plocaluser->getBB();
  mobileList = worlds->plocaluser->addObjectToList(mobileList);
  worlds->plocaluser->insertObjectIntoGrid();

  //
  // Download the description file of the new world
  //
  setState(WORLD_TOBUILD);
  httpOpen(worlds->url, cfgHttpReader, NULL, THREAD_NO_BLOCK);
  //trace(DBG_FORCE, "newWorld: %s downloaded", worlds->url);

  GuiUpdateUser(worlds->plocaluser);
  worlds->plocaluser->updateCamera();

  // declare user to network
  if (! worlds->plocaluser->noh) {
    error("newWorld: noh NULL world=%s num=%d", worlds->name, worlds->num);
    return worlds;
  }
  worlds->plocaluser->noh->createNetObject(NET_VOLATILE);
  // not necessary to publish the whole object now
  //worlds->plocaluser->noh->declareObjCreation();

  // check if icons are presents
  checkIcons();

  return worlds;
}

void declareJoinWorldToManager(const char *_url, const char *chan, const char *localusername)
{
  // TODO
}

void declareLeaveWorldToManager(const char *wname, const char *chan, const char *localusername)
{
  // TODO
}

/* Quits the current World */
void World::quit()
{
  trace(DBG_WO, "World::quit: %s", getCurrentName());

  declareLeaveWorldToManager(getCurrentName(), getChannelName(), plocaluser->name.instance_name);

  freeGrid();
  WObject::resetObjectsNumber();

  // delete objects

  for (ObjectList *pl = invisibleList; pl ; ) {
    ObjectList *tmppl = pl;
    if (pl->pobject) {
      pl->pobject->quit();
      delete pl->pobject;		// delete WObject
      pl->pobject = NULL;;
    }
    pl = pl->next;
    delete tmppl;
  }
  invisibleList = NULL;

  for (ObjectList *pl = stillList; pl ; ) {
    ObjectList *tmppl = pl;
    if (pl->pobject) {
      if (pl->pobject->soh) {
        pl->pobject->soh->clearObjectBar();
        delete pl->pobject->soh;	// delete Solid
        pl->pobject->soh = NULL;
      }
      pl->pobject->quit();
      delete pl->pobject;		// delete WObject
      pl->pobject = NULL;;
    }
    pl = pl->next;
    delete tmppl;
  }
  stillList = NULL;

  for (ObjectList *pl = mobileList; pl && pl->pobject != worlds->plocaluser; ) {
    ObjectList *tmppl = pl;
    if (pl->pobject) {
      if (pl->pobject->soh) {
        pl->pobject->soh->clearObjectBar();
        delete pl->pobject->soh;	// delete Solid
        pl->pobject->soh = NULL;
      }
      if (pl->pobject->noh) {
        if (! pl->pobject->isPermanent())
          pl->pobject->noh->declareDeletion();
        delete pl->pobject->noh;	// delete NetObject
        pl->pobject->noh = NULL;;
      }
      pl->pobject->quit();
      delete pl->pobject;		// delete WObject
      pl->pobject = NULL;;
    }
    pl = pl->next;
    delete tmppl;
  }
  //pd mobileList = NULL;	// localUser ever in mobilList

  // reset solids
  Solid::resetSolid();		// solid_id = 1 (localUser preserved)

  // update GUI
  if (guip)
    GuiUpdateWorld(worlds, VR_OLD);

  if (plocaluser->noh) {
    plocaluser->noh->declareDeletion();	// publishes I leave
    plocaluser->noh->deleteNetObjectFromList();
  }
  setDead(true);
  if (islinked)
    return;
  App::quitTools();
}

/* Deletes all objects dropped in the deleteList */
void World::deleteObjects()
{
  while (deleteList) {
    ObjectList *next = deleteList->next;

    deleteList->pobject->deleteObjectFromGrid();
    mobileList = deleteList->pobject->deleteObjectFromList(mobileList);
    if (deleteList->pobject->soh) {
      delete deleteList->pobject->soh;	// delete Solid
      deleteList->pobject->soh = NULL;
    }
    if (deleteList->pobject->noh) {
      if (! deleteList->pobject->isPermanent())
        deleteList->pobject->noh->declareDeletion();
      delete deleteList->pobject->noh;	// delete NetObject
      deleteList->pobject->noh = NULL;
    }
    deleteList->pobject->quit();
    delete deleteList->pobject;		// delete WObject
    deleteList->pobject = NULL;
    delete deleteList;
    deleteList = next;
  }
}

/* WO General Initialization */
void World::init(const char *_url, const char *localusername, const char *urlfront, const char *urlback)
{
  clearGrid();
  clearLists();
  initObjectsName();
  initGeneralFuncList();

  //pd worlds->num = 1;	// initial world
  strcpy(worlds->url, _url);
  setLocalName(worlds->url);
  worlds->guip = GuiAddWorld(worlds, VR_CURR);
  trace(DBG_INIT, "initWO: worldname = %s", getCurrentName());

  //
  // Create local user
  //
  worlds->plocaluser = new User(localusername, urlfront, urlback);

  trace(DBG_WO, "init: worlds->plocaluser->noh=%p", worlds->plocaluser->noh);
  // localUser: global variable
  localUser = worlds->plocaluser;	// temp

  //usergeom force solid id = 2
  worlds->plocaluser->userGeometry(options->skinf, options->skinb);
  worlds->plocaluser->soh->setSolidVisible(false);

  //
  // Download initial world (rendez-vous.vre)
  //
  setState(WORLD_TOBUILD);
  httpOpen(worlds->url, cfgHttpReader, NULL, THREAD_NO_BLOCK);

  //
  // Update local user in 3D
  //
  worlds->plocaluser->update3D();
  worlds->plocaluser->updateCamera();

  // check if icons are presents
  checkIcons();

  declareJoinWorldToManager(worlds->url, getChannelName(), localusername);
}

/* WO terminaison */
void World::terminate()
{
  if (worlds->plocaluser && worlds->plocaluser->name.world_name)
    declareLeaveWorldToManager(worlds->plocaluser->name.world_name,
                               getChannelName(),
                               worlds->plocaluser->name.instance_name);
  freeGrid();

  for (ObjectList *pl = invisibleList; pl; ) {
    ObjectList *tmppl = pl;
    if (pl->pobject) {
      delete pl->pobject;
      pl->pobject = NULL;
    }
    pl = pl->next;
    delete tmppl;
  }

  for (ObjectList *pl = stillList; pl; ) {
    ObjectList *tmppl = pl;
    if (pl->pobject) {
      if (pl->pobject->soh) {
        delete pl->pobject->soh;	// delete Solid
        pl->pobject->soh = NULL;
      }
      delete pl->pobject;
      pl->pobject = NULL;
    }
    pl = pl->next;
    delete tmppl;
  }

  for (ObjectList *pl = mobileList; pl && pl->pobject != worlds->plocaluser; ) {
    ObjectList *tmppl = pl;
    if (pl->pobject) {
      if (pl->pobject->soh) {
        delete pl->pobject->soh;	// delete Solid
        pl->pobject->soh = NULL;
      }
      if (pl->pobject->noh) {
        if (! pl->pobject->isPermanent())
          pl->pobject->noh->declareDeletion();
        delete pl->pobject->noh;	// delete NetObject
        pl->pobject->noh = NULL;
      }
      delete pl->pobject;		// delete WObject
      pl->pobject = NULL;
    }
    pl = pl->next;
    delete tmppl;
  }

  // destroy local user
  if (worlds->plocaluser) {
    delete worlds->plocaluser;		// delete localUser
    worlds->plocaluser = NULL;
  }

  // quit all channels
  delete Channel::getCurrentChannel();	// delete Channel
  delete Channel::getManager();

  // quit all tools
  App::quitAllTools();
}

void World::clearLists()
{
  stillList = NULL;
  mobileList = NULL;
  invisibleList = NULL;
  deleteList = NULL;
  cartList = NULL;
}

void sourceHttpReader(void *_box, Http *http)
{
  UBox *source_box = (UBox *) _box;

  if (! http) {
    error("sourceHttpReader: unable to open http connection");
    return;
  }
  char line[BUFSIZ];

  while (http->NextLine(line)) {
    if (*line == '[')
      source_box->add(uitem(UColor::red + UFont::bold + line));
    else if (*line == '#')
      source_box->add(uitem(UColor::green + line), false);
    else
      source_box->add(uitem(UColor::black + line), false);
  }
}

void worldsHttpReader(void *_box, Http *http)
{
  UBox *worlds_box = (UBox *) _box;

  if (! http) {
    error("worldsHttpReader: unable to open http connection");
    return;
  }
  char line[BUFSIZ];

  while (http->NextLine(line)) {
    if (*line == '[') continue;
    worlds_box->add(uitem(UColor::red + line), false);
  }
}

void World::sourceDialog(UBox *source_box)
{
  World *pw = getCurrentWorld();
  if (! pw)
    return;

  source_box->removeAll(true);

  httpOpen(pw->url, sourceHttpReader, source_box, THREAD_NO_BLOCK);

  source_box->update();
  source_box->show(true);
}

void World::worldsDialog(UBox *worlds_box)
{
  worlds_box->removeAll(true);

  char worlds_url[URL_LEN];
  sprintf(worlds_url, "http://%s%svre/v%d/worlds.vre", DEF_HTTP_SERVER, DEF_URL_PREFIX, VRE_VERSION);

  httpOpen(worlds_url, worldsHttpReader, worlds_box, THREAD_NO_BLOCK);

  worlds_box->update();
  worlds_box->show(true);
}
