#include "global.h"
#include "wo.h"
#include "world.h"	// getCurrentName
#include "user.h"	// plocaluser

#include "net.h"	// NetObject
#include "vgl.h"	// Solid

#include "vrmysql.h"	// VRSql


// local variables
static uint32_t objectNum = 0;
static char methodname[ACTIONSNUMBER][HNAME_LEN];

// global variables
struct GeneralActionList generalActionList[ACTIONSNUMBER][OBJECTSNUMBER+1];
struct GeneralActionList2 generalActionList2[ACTIONSNUMBER][OBJECTSNUMBER+1];

ObjectList *stillList, *mobileList, *invisibleList, *deleteList, *cartList;


bool isValidType(const int type_id)
{
  if (type_id < 0 || type_id > OBJECTSNUMBER)
    return false;
  return true;
}

bool WObject::isValid()
{
  return isValidType(type);
}

void WObject::setType(const int _type)
{
  type = _type;
}

void WObject::resetObjectsNumber()
{
  objectNum = 0;
}

uint32_t WObject::getObjectsNumber()
{
  return objectNum;
}

bool WObject::isPermanent()
{
  if (noh)
    return noh->isPermanent();
  return 0;
}

void WObject::setSrcId(const uint32_t _src_id)
{
  noid.src_id = _src_id;
}

uint32_t WObject::getSrcId()
{
  return noid.src_id;
}

void WObject::setPortId(const uint16_t _port_id)
{
  noid.port_id = _port_id;
}

uint16_t WObject::getPortId()
{
  return noid.port_id;
}

void WObject::setObjId(const uint16_t _obj_id)
{
  noid.obj_id = _obj_id;
}

uint16_t WObject::getObjId()
{
  return noid.obj_id;
}

/* Assigns a unique identifier to each Vreng object */
void WObject::setWObjectId()
{
  noid.src_id = getMySsrcId();		// Application's identifier
  noid.port_id = getMyPortId();		// Comm port identifier
  setMyObjId(getMyObjId() + 1);		// myObjId++
  noid.obj_id = htons(getMyObjId());	// Application wide unique number
}

/* Copies NetObjectId in WObjectId */
void WObject::copyNetObjectId(const NetObjectId _noid)
{
  noid.src_id = _noid.src_id;
  noid.port_id = _noid.port_id;
  noid.obj_id = _noid.obj_id;
}

WObject * WObject::getWObjectbyWObject(WObject *po)
{
  for (ObjectList *pl = mobileList; pl ; pl = pl->next) {
    if (pl->pobject == po)
      return po;
  }
  for (ObjectList *pl = stillList; pl ; pl = pl->next) {
    if (pl->pobject == po)
      return po;
  }
  return NULL;
}

/* WObject constructor */
WObject::WObject()
{
  new_wobject++;

  noh = NULL;
  soh = NULL;
  guip = NULL;

  type = 0;
  num = 0;
  list_id = 0;
  //pd props = 0;
  behavior = 0;

  name.class_name[0] = 0;
  name.given_name[0] = 0;
  name.instance_name = NULL;
  name.world_name = NULL;
  name.infos = NULL;
  name.url[0] = 0;
  name.owner[0] = 0;

  pos.x = 0.;
  pos.y = 0.;
  pos.z = 0.;
  pos.ax = 0.;
  pos.ay = 0.;
  pos.az = 0.;
  pos.old_x = 0.;
  pos.old_y = 0.;
  pos.old_z = 0.;
  pos.rel_x = 0.;
  pos.rel_y = 0.;
  pos.rel_z = 0.;
  pos.rel_ax = 0.;
  pos.rel_ay = 0.;
  pos.rel_az = 0.;
  pos.state = 0;
  pos.group = 0;

  move.perm_sec = 0;
  move.perm_usec = 0;
  move.ttl = 0.;

  nature.density = 0;
  nature.viscuosity = 0;

  state.state = 0;
  state.collide = 0;
  state.carrying = 0;
  state.ispointed = 0;
  state.moving = 0;

  noid.src_id = 0;
  noid.port_id = 0;
  noid.obj_id = 0;

  up_p = NULL;
  next_p = NULL;
  down_p = NULL;
  nextg = NULL;
  prevg = NULL;
}

/* WObject destructor */
WObject::~WObject()
{
  del_wobject++;
  if (soh) {
    if (soh->object == this)
      soh->object = NULL;
    //else if (soh->id == 1)	// Myself
    //  return;
    else
      error("delete: bad link soh->object=%p this=%p name=%s", soh->object, this, name.class_name);
  }
}

void WObject::enableBehavior(const uint32_t flag)
{
  behavior |= flag;

  switch (flag) {
  case INVISIBLE:
    if (soh)
      soh->setSolidVisible(false);
    break;
  case COLLIDE_ONCE:
    behavior &= ~COLLIDE_NEVER;
    behavior &= ~COLLIDE_GHOST;
    break;
  case COLLIDE_NEVER:
    behavior &= ~COLLIDE_ONCE;
    behavior &= ~COLLIDE_GHOST;
    break;
  case COLLIDE_GHOST:
    behavior &= ~COLLIDE_ONCE;
    behavior &= ~COLLIDE_NEVER;
    break;
  }
}

void WObject::disableBehavior(const uint32_t flag)
{
  behavior &= ~flag;

  switch (flag) {
  case INVISIBLE:
    if (soh)
      soh->setSolidVisible(true);
    break;
  }
}

bool WObject::isBehavior(const uint32_t flag)
{
  return (behavior & flag);
}

uint32_t WObject::collideBehavior()
{
  return (behavior & (COLLIDE_ONCE | COLLIDE_NEVER | COLLIDE_GHOST));
}

/* Initializes Object */
void WObject::initializeObject(const uint8_t _list_id)
{
  num = objectNum++;
  if (!type)
    type = getTypeId();
  list_id = _list_id; // PLD: initialize the object's list_id value
  setWObjectId();
  updateNames();

  if (isBehavior(NO_SELECTABLE))
    enableBehavior(NO_BBABLE);	//FIXME: BB may exist even if not selectable

  switch (_list_id) {

  case LIST_STILL:
    //pd setObjectToSolid();
    update3D();
    if (! isBehavior(NO_BBABLE)) {
      getBB();
      insertObjectIntoGrid();
    }
    enableBehavior(NO_ELEMENTARY_MOVE);
    stillList = addObjectToList(stillList);
    trace(DBG_WO, "addObjectToStill: p=%p n=%s", this, name.instance_name);
    break;

  case LIST_MOBILE:
    //pd setObjectToSolid();
    update3D();
    if (! isBehavior(NO_BBABLE)) {
      getBB();
      insertObjectIntoGrid();
    }
    mobileList = addObjectToList(mobileList);
    trace(DBG_WO, "addObjectToMobile: p=%p n=%s", this, name.instance_name);
    break;

  case LIST_INVISIBLE:
    enableBehavior(NO_BBABLE);
    enableBehavior(NO_SELECTABLE);
    enableBehavior(NO_ELEMENTARY_MOVE);
    invisibleList = addObjectToList(invisibleList);
    break;
  }

  if (isBehavior(NO_BBABLE)) {
    //D soh->setSolidBBFlag(false);
    enableBehavior(COLLIDE_NEVER);
  }
}

/* Creates local permanent NetObject */
void WObject::createPermanentNetObject(const uint8_t props, const uint16_t oid)
{
  noh = new NetObject(this, props, oid);
}

/* Creates local volatile NetObject */
void WObject::createVolatileNetObject(const uint8_t props)
{
  noh = new NetObject(this, props);
}

/* Replicates distant volatile NetObject */
void WObject::replicateVolatileNetObject(const uint8_t props, NetObjectId _noid)
{
  noh = new NetObject(this, props, _noid);
}

void WObject::getObjectNameById(const uint8_t type_id, char *name)
{
  const WClass *wclass = WClass::getWClass(type_id);
  if (! wclass)
    warning("getObjectNameById: no name found for type=%d", type_id);
  else
    strcpy(name, wclass->type_name);
  return;
}

/* Updates Object names */
void WObject::updateNames()
{
  getObjectNameById(type, name.class_name);
  if (*name.class_name == 0)
    return;

  if (! isprint(name.given_name[0])) {	// no explicit name
    if (soh)
      sprintf(name.given_name, "%s%d", name.class_name, soh->id);
    else
      sprintf(name.given_name, "%s", name.class_name);
  }
  name.instance_name = name.given_name;
  setObjectName(name.instance_name);
  name.world_name = World::getCurrentName();
}

void WObject::updateObject(const Pos &oldpos)
{
  update3D();
  getBB();
  updateObjectIntoGrid(oldpos);
}

void WObject::setSqlStatus()
{
#if WITH_MYSQL && defined(HAVE_LIBMYSQLCLIENT)
  if (isBehavior(PERSISTENT) && *name.given_name) {
    int st = VRSql::getVRSql()->getStateObject(World::getCurrentName(), name.given_name);
    trace(DBG_WO, "setSqlStatus: name=%s state=%d", name.given_name, st);
    if (st != -1) {
      state.state = st;
    }
  }
#endif
}

/* Returns how mamy actions have this object */
int WObject::numberAction()
{
  int i;
  for (i=0; generalActionList[i][getTypeId()].method ; i++)
    ;
  return i;
}

/* Checks if this object have actions */
bool WObject::haveAction()
{
  if (generalActionList[0][getTypeId()].method)
    return true;
  return false;
}

#if 0
void setActionFunc(int type_id, int action_id, void (*action_method)(void *, time_t, time_t), const char *action_name)
#else
void setActionFunc(int type_id, int action_id, void (*action_method)(WObject *, void *, time_t, time_t), const char *action_name)
#endif
{
  strcpy(generalActionList[action_id][type_id].type_name, action_name);
  generalActionList[action_id][type_id].method = action_method;
}

void setActionHandler(int type_id, int action_id, void (*action_method)(void *, time_t, time_t), const char *action_name)
{
  strcpy(generalActionList[action_id][type_id].type_name, action_name);
  generalActionList2[action_id][type_id].method = action_method;
}

/* Calls special methods for each object */
void Solid::specialAction(int action_id, void *data, time_t sec, time_t usec)
{
  WObject *po = (this==NULL) ? worlds->plocaluser : getObjectFromSolid();
  if (this && (int) object < 1000) { // HACK! when objbar already stuck
    error("solid corrupted");
    return;
  }
  if (po) {
    if (generalActionList[action_id][po->type].method)
      generalActionList[action_id][po->type].method(po, data, sec, usec);
    //pd if (generalActionList2[action_id][po->type].method)
    //pd   generalActionList2[action_id][po->type].method(data, sec, usec);
  }
}

/*
 * Gives instance_name or class_name and method names of an object if they exist
 * called by GUI
 */
void Solid::getObjectHumanName(char **classname, char **instancename, char **actionnames)
{
  WObject *po = NULL;
  if ((po = getObjectFromSolid()) == NULL) {
    *classname = *instancename = *actionnames = NULL;
    trace(DBG_FORCE, "getObjectHumanName: NULL sid=%d object=%p", id, object);
    return;
  }

  *classname = po->name.class_name;
  *instancename = po->name.instance_name;
  *actionnames = (char *)methodname;
  trace(DBG_WO, "getObjectHumanName: %s:%s", *classname, *instancename);

  // find method names
  int i;
  for (i=0; generalActionList[i][po->type].type_name[0] != '\0'; i++) {
    strcpy(methodname[i], generalActionList[i][po->type].type_name);
    trace(DBG_WO, "getObjectHumanName: type_id=%d i=%d name=%s", po->type, i, methodname[i]);
  }
  methodname[i][0] = '\0';
}

/* Adds an object into the deleteList */
void WObject::toDelete()
{
  for (ObjectList *pl = deleteList; pl ; pl = pl->next) {
    if (pl->pobject == this)
      return;	// already deleted
  }
  deleteList = addObjectToList(deleteList);
}

void WObject::traceSolidObject(const char *where)
{
  if (!soh)	// not yet created
    return; 
  if (soh->id == 1)	// Myself
    return; 
  if (!soh->object)
    error("%s: po=%p name=%s tid=%d sid=%d sohobject=NULL",
          where, this, name.class_name, type, soh->id);
  else
    error("%s: po=%p name=%s tid=%d sid=%d sohobject=%p",
          where, this, name.class_name, type, soh->id, soh->object);
}


/** Created on 15 June 2002 by HP for MOVE project */

/**
 * Head linking (will crash if there is no displayable object in tree !)
 */
WObject * WObject::prev()
{
  if (!up_p) {
    warning("tried to prev() on an ungrouped object!");
    return this;
  }

  WObject *p = up_p;
  while (p->up_p) {
    p = p->up_p;
  } // go up to the root of the tree

  while (p->down_p) {
    p = p->down_p;
  } // go down to the first element
  return p;
}

/** Go to the next WObject in tree till WObject has a soh */
WObject * WObject::next()
{
  WObject *p = this;
  
  do {
    if (p->down_p) {	// first, go down (down_p)
      p = p->down_p;
    }
    else {	// then to the right (next_p)
      if (p->next_p) {
        p = p->next_p;
      }
      else {	// finally go up till you have a WObject on the right (next_p)
        while (!(p->next_p)) {
          if (p->up_p) { // WObjects up this one have already been checked
            p = p->up_p;
          }
          else {	// nowhere left to go -> End of "tree mapped to list"
            return NULL;
          }
        }
      }
    }
  } while (! p->soh) ;
  return p;
}

/* FIFO Version */
void WObject::add_son(WObject *po)
{
  if (!down_p) { // First child
    down_p = po;
    // computes relative coords of this child
    po->pos.rel_x = pos.x - po->pos.x;
    po->pos.rel_y = pos.y - po->pos.y;
    po->pos.rel_z = pos.z - po->pos.z;
    return;
  }
  else {
    WObject *p = down_p;
    while (p->next_p) {
      p = p->next_p;
    } // ptr on last child that doesnt have a brother
    p->next_p = po;	// this one now has a new brother
  }
}

void WObject::changeComplexePosition()
{
  // we add child's coords
  if (isValid() && up_p) {
    Pos position_pere = up_p->pos;
    translateCoords();
  }
}

void WObject::translateCoords()
{
  WObject *father = this;

  while (father->up_p) {
    father = father->up_p;
  }
  pos.x = father->pos.x + pos.rel_x;
  pos.y = father->pos.y + pos.rel_y;
  pos.z = father->pos.z + pos.rel_z;
}
