#include "global.h"
#include "wo.h"
#include "web.h"

#include "app.h"	// startbrowser


const WClass Web::wclass(WEB_TYPE, "Web", Web::creator);


/* creation from a file */
WObject * Web::creator(char *l)
{
  return new Web(l);
}

Web::Web(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  l = parseUrl(l, name.url);

  initializeObject(LIST_STILL);
} 

/* object intersects: projection */
void Web::whenIntersect(WObject *pcur, WObject *pold)
{
  if (projectMovementOnObject(pcur->pos, pold->pos, pos))
    pcur->updateObject(pold->pos);
  else 
    pold->copyPositionAndBB(pcur);
}

/* browser */
#if WEBC
void Web::Open(void *d, time_t s, time_t u)
{
  trace(DBG_TOOL, "Open: browser on %s", name.url);
  char *purl;
  if ((purl = strrchr(name.url, '.')) != NULL) {
    purl++;
    if (!strncmp(purl, "wrl", 3) || !strncmp(purl, "vrm", 3)) {
      App::startvrml(name.url);
      return;
    }
  }
  App::startbrowser(name.url);
}
#else
void Open(Web *po, void *d, time_t s, time_t u)
{
  trace(DBG_TOOL, "Open: browser on %s", po->name.url);
  char *purl;
  if ((purl = strrchr(po->name.url, '.')) != NULL) {
    purl++;
    if (!strncmp(purl, "wrl", 3) || !strncmp(purl, "vrm", 3)) {
      App::startvrml(po->name.url);
      return;
    }
  }
  App::startbrowser(po->name.url);
}
#endif //WEBC

void webInitFuncList(void)
{
#if WEBC
  setActionHandler(WEB_TYPE, 0, WO_ACTION2 Web::Open, "Open");
#else
  setActionFunc(WEB_TYPE, 0, WO_ACTION Open, "Open");
#endif //WEBC
}
