#include "global.h"
#include "wo.h"
#include "user.h"	// USER_TYPE
#include "ball.h"	// BALL_TYPE
#include "caul.h"	// CAULDRON_TYPE
#include "gcontext.h"	// gcontext
#include "water.h"

#include "texture.h"	// TextureCacheEntry::getCurrentNumber
#include "app.h"	// playSound

#include "gui.h"


const WClass Water::wclass(WATER_TYPE, "Water", Water::creator);

static float tcolor[] = {0.4, 0.7, 1.0, WATER_DEF_TRANSP}; // triangles color

static int first = 1;

/* creation from a file */
WObject * Water::creator(char *l)
{
  return new Water(l);
}

void Water::setDefaults()
{
  amplitude = WATER_DEF_AMPLITUDE;
  freq = WATER_DEF_FREQ;
  phase = WATER_DEF_PHASE;
  height = WATER_DEF_HEIGHT;
  transparency = WATER_DEF_TRANSP;
  fogdensity = WATER_DEF_FOG;
  first = 1;
  play = true;
  accel = false;
}

Water::Water(char *l)
{
  setDefaults();

  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);

  while (l) {
    if (!strncmp(l, "amplitude", 9))
      l = parseFloat(l, &amplitude, "amplitude");
    else if (!strncmp(l, "freq", 4))
      l = parseFloat(l, &freq, "freq");
    else if (!strncmp(l, "phase", 5))
      l = parseFloat(l, &phase, "phase");
    else if (!strncmp(l, "height", 6))
      l = parseFloat(l, &height, "height");
  }

  //enableBehavior(COLLIDE_ONCE);
  enableBehavior(NO_ELEMENTARY_MOVE);
  initializeObject(LIST_MOBILE);

  rotx = RADIAN2DEGREE(pos.ax);
  roty = 90.;
  rotz = RADIAN2DEGREE(pos.az);
  trace(DBG_WO, "Water1: bbsize=%.2f,%.2f,%.2f bbcenter=%.2f,%.2f,%.2f",
        pos.bbsize.v[0], pos.bbsize.v[1], pos.bbsize.v[2],
        pos.bbcenter.v[0], pos.bbcenter.v[1], pos.bbcenter.v[2]);
  depth = pos.bbsize.v[0];
  width = pos.bbsize.v[1];
#if 0 //pdbbox
  pos.bbsize.v[2] += height/2;
  pos.bbcenter.v[2] += height/2;
  gcontext->bbox_min.v[2] = MIN(gcontext->bbox_min.v[2], -height/2);
  gcontext->bbox_max.v[2] = MAX(gcontext->bbox_max.v[2], height/2);
  //getBB();
#endif //pdbbox

  //updateObjectIntoGrid(pos);

  enablePermanentMovement();

#if 0 //pdtex
  texnum = TextureCacheEntry::getCurrentNumber();
  glBindTexture(GL_TEXTURE_2D, texnum);
  float texture_color[] = {0.8, 0.8, 1., 0};	// texture color
  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
  glTexEnvfv(GL_TEXTURE_ENV, GL_TEXTURE_ENV_COLOR, texture_color);
  glEnable(GL_TEXTURE_2D);
#endif //pdtex

  /* blending */
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  /* fog */
  GLfloat fog[5] = {WATER_DEF_FOG, .1, .2, .2, .1};
  glFogi(GL_FOG_MODE, GL_EXP);
  glFogf(GL_FOG_DENSITY, fog[0]);
  glFogfv(GL_FOG_COLOR, fog+1);
  //pd glHint(GL_FOG_HINT, GL_FASTEST);
  trace(DBG_WO, "Water2: bbsize=%.2f,%.2f,%.2f bbcenter=%.2f,%.2f,%.2f",
        pos.bbsize.v[0], pos.bbsize.v[1], pos.bbsize.v[2],
        pos.bbcenter.v[0], pos.bbcenter.v[1], pos.bbcenter.v[2]);
}

void Water::draw()
{
  float d = 1./WATER_MESH;
  for (int i=0; i < WATER_MESH; i++) {
    glBegin(GL_TRIANGLE_STRIP);
    for (int j=0; j < WATER_MESH; j++) {
      float s, t, x, y, z;
      s = j * d;
      t = i * d;
      x = -1. + 2. * s;
      z = -1. + 2. * t;
      y = amplitude * Sin(freq * M_2PI * t + off);
      glTexCoord2f(s, t); glVertex3f(x, y, z);
      s += d;
      t += d;
      x = -1. + 2. * s;
      z = -1. + 2. * t;
      y = amplitude * Sin(freq * M_2PI * t + off);
      glTexCoord2f(s, t); glVertex3f(x, y, z);
      if (play) {
        off += phase;
        if (off > WATER_MAX_OFF)
          off = 0.;
      }
    }
    glEnd();
  }
}

void Water::changePermanent(float lasting)
{
  play = accel || checkRate(WATER_RATE);
}

void Water::render()
{
  glPushMatrix();
   glTranslatef(pos.x, pos.y, pos.z + height);
   glRotatef(rotx, 1, 0, 0);
   glRotatef(roty, 0, 1, 0);
   glRotatef(rotz, 0, 0, 1);
   glScalef(width, 1, depth);

   glEnable(GL_BLEND);
   glEnable(GL_FOG);
   glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, tcolor);
   draw();
   glDisable(GL_FOG);
   glDisable(GL_BLEND);
  glPopMatrix();
}

void Water::whenIntersect(WObject *pcur, WObject *pold)
{
  switch (pcur->type) {
  case BALL_TYPE:
    pcur->pos.z += BALL_DELTAZ;
    disableBehavior(COLLIDE_ONCE);
    break;
  case USER_TYPE:
    enableBehavior(COLLIDE_ONCE);
    App::playSound(BUBBLESSND);
    break;
  case CAULDRON_TYPE:
    if (first) {
    trace(DBG_WO, "WaterC: bbsize=%.2f,%.2f,%.2f bbcenter=%.2f,%.2f,%.2f",
          pos.bbsize.v[0], pos.bbsize.v[1], pos.bbsize.v[2],
          pos.bbcenter.v[0], pos.bbcenter.v[1], pos.bbcenter.v[2]);
    first = 0;
    }
    pcur->pos.z += BALL_DELTAZ;
    //pd pcur->pos.z += height;
    //pcur->pos.z = pold->pos.z;	// no motion
    pcur->pos.ay = DEGREE2RADIAN((float) floor(5 * amplitude * freq * (off-WATER_MAX_OFF/2)));
    break;
  }
  pcur->updateAll3D();
  pcur->getBB();
}

void waterAccel(Water *po, void *d, time_t s, time_t u)
{
  po->accel = 1 - po->accel;
}

void waterMoreAmplitude(Water *po, void *d, time_t s, time_t u)
{
  po->amplitude += WATER_INCR_AMPLITUDE;
}

void waterLessAmplitude(Water *po, void *d, time_t s, time_t u)
{
  po->amplitude -= WATER_INCR_AMPLITUDE;
  if (po->amplitude < 0.)
    po->amplitude = WATER_INCR_AMPLITUDE;
}

void waterMoreFrequence(Water *po, void *d, time_t s, time_t u)
{
  po->freq += WATER_INCR_FREQ;
}

void waterLessFrequence(Water *po, void *d, time_t s, time_t u)
{
  po->freq -= WATER_INCR_FREQ;
  if (po->freq < 0.)
    po->freq = WATER_INCR_FREQ;
}

void waterMorePhase(Water *po, void *d, time_t s, time_t u)
{
  po->phase += WATER_INCR_PHASE;
}

void waterLessPhase(Water *po, void *d, time_t s, time_t u)
{
  po->phase -= WATER_INCR_PHASE;
  if (po->phase < 0.)
    po->phase = WATER_INCR_PHASE;
}

void waterMoreTransp(Water *po, void *d, time_t s, time_t u)
{
  po->transparency -= WATER_INCR_TRANSP;
  po->transparency = MAX(po->transparency, 0);
  tcolor[3] = po->transparency;
}

void waterLessTransp(Water *po, void *d, time_t s, time_t u)
{
  po->transparency += WATER_INCR_TRANSP;
  po->transparency = MIN(po->transparency, 1);
  tcolor[3] = po->transparency;
}

void waterMoreFog(Water *po, void *d, time_t s, time_t u)
{
  po->fogdensity += WATER_INCR_FOG;
  po->fogdensity = MIN(po->fogdensity, 1);
  glFogf(GL_FOG_DENSITY, po->fogdensity);
}

void waterLessFog(Water *po, void *d, time_t s, time_t u)
{
  po->fogdensity -= WATER_INCR_FOG;
  po->fogdensity = MAX(po->fogdensity, 0);
  glFogf(GL_FOG_DENSITY, po->fogdensity);
}

void waterReset(Water *po, void *d, time_t s, time_t u)
{
  po->amplitude = WATER_DEF_AMPLITUDE;
  po->freq = WATER_DEF_FREQ;
  po->phase = WATER_DEF_PHASE;
  po->transparency = WATER_DEF_TRANSP;
  tcolor[3] = po->transparency;
  po->fogdensity = WATER_DEF_FOG;
  glFogf(GL_FOG_DENSITY, po->fogdensity);
}

void waterInitFuncList(void)
{
  setActionFunc(WATER_TYPE, 0, WO_ACTION waterAccel, "Accel");
  setActionFunc(WATER_TYPE, 1, WO_ACTION waterMoreAmplitude, "Ampl+");
  setActionFunc(WATER_TYPE, 2, WO_ACTION waterLessAmplitude, "Ampl-");
  setActionFunc(WATER_TYPE, 3, WO_ACTION waterMoreFrequence, "Freq+");
  setActionFunc(WATER_TYPE, 4, WO_ACTION waterLessFrequence, "Freq-");
  setActionFunc(WATER_TYPE, 5, WO_ACTION waterMorePhase, "Phase+");
  setActionFunc(WATER_TYPE, 6, WO_ACTION waterLessPhase, "Phase-");
  setActionFunc(WATER_TYPE, 7, WO_ACTION waterMoreTransp, "Transp+");
  setActionFunc(WATER_TYPE, 8, WO_ACTION waterLessTransp, "Transp-");
  setActionFunc(WATER_TYPE, 9, WO_ACTION waterMoreFog, "Fog+");
  setActionFunc(WATER_TYPE, 10, WO_ACTION waterLessFog, "Fog-");
  setActionFunc(WATER_TYPE, 11, WO_ACTION waterReset, "Defaults");
}
