#ifndef USER_H
#define USER_H

#include "config.h"
#include "keys.h"


#define USER_TYPE		1
#define USER_NAME		"Avatar"
#define	USER_INIT		userInitFuncList
#define USER_LASTING		0.015	// 15 ms
#define USER_PROPS		(USER_PROPCOLOR + 1) /* 20 */

#define USER_PROPHNAME		0			/*  0 */
#define USER_PROPMAPFRONT	1			/*  1 */
#define USER_PROPMAPBACK	2			/*  2 */

#define USER_PROPBEGINVAR	(USER_PROPMAPBACK  + 1)
#define USER_PROPXY		(USER_PROPBEGINVAR + 0)	/*  3 */
#define USER_PROPZ		(USER_PROPBEGINVAR + 1)	/*  4 */
#define USER_PROPAZ		(USER_PROPBEGINVAR + 2)	/*  5 */
#define USER_PROPAY		(USER_PROPBEGINVAR + 3)	/*  6 */
#define USER_PROPAX		(USER_PROPBEGINVAR + 4)	/*  7 */
#define USER_PROPMSG		(USER_PROPBEGINVAR + 5)	/*  8 */
#define USER_PROPENDVAR		USER_PROPMSG

#define USER_PROPMENSURATION	(USER_PROPENDVAR + 1)	/*  9 */
#define USER_PROPMAPLEFT	(USER_PROPENDVAR + 2)	/* 10 */
#define USER_PROPMAPRIGHT	(USER_PROPENDVAR + 3)	/* 11 */
#define USER_PROPVRE		(USER_PROPENDVAR + 4)	/* 12 */
#define USER_PROPWEB		(USER_PROPENDVAR + 5)	/* 13 */
#define USER_PROPSSRC		(USER_PROPENDVAR + 6)	/* 14 */
#define USER_PROPRTCPNAME	(USER_PROPENDVAR + 7)	/* 15 */
#define USER_PROPRTCPEMAIL	(USER_PROPENDVAR + 8)	/* 16 */
#define USER_PROPMODEL		(USER_PROPENDVAR + 9)	/* 17 */
#define USER_PROPFACE		(USER_PROPENDVAR + 10)	/* 18 */
#define USER_PROPCOLOR		(USER_PROPENDVAR + 11)	/* 19 */


#define USER_MENSURATIONLEN	64

#define USER_DEFAULTWIDTH	0.26	// width = 26 cm
#define USER_DEFAULTDEPTH	0.16	// depth = 16 cm
#define USER_DEFAULTHEIGHT	1.70	// height= 170 cm
#define USER_LSPEED		4.0	// linear speed: 4 m/s
#define USER_ASPEED		1.0	// angular speed
#define USER_EXTLSPEED		8.0
#define USER_EXTASPEED		2.0
#define USER_DELTAZ		0.02	// 2 cm
#define USER_GOTHROUGH		0.05	// 5 cm
#define USER_FOVY		26.0	// 26 deg
#define USER_NEAR		0.30	// 10cm orig=40cm
#define USER_FAR		300.0	// 300m
#define USER_DENSITY		1.0

/* actions */
#define BULLETUSER	0
#define DARTUSER	1
#define FOVYORIGINAL	2
#define FOVYLESS	3
#define FOVYGREATER	4
#define LSPEEDORIGINAL	5
#define LSPEEDLESS	6
#define LSPEEDGREATER	7
#define ASPEEDORIGINAL	8
#define ASPEEDLESS	9
#define ASPEEDGREATER	10
#define USERPAUSE	11
#define USERPAUSEON	12
#define USERPAUSEOFF	13
#define USERSETLSPEED	14
#define USERSETASPEED	15

/**
 * User Class
 */
class User: public WObject {

 public:
  float lspeed;
  float aspeed;
  float width;
  float depth;
  float height;
  uint32_t ssrc;
  char  *urlfront;
  char  *urlback;
  char  *urlleft;
  char  *urlright;
  char  *vre;
  char  *host;
  char  *web;
  char  *model;
  char  *face;
  char  *color;
  char  *baps;
  char  *cname;
  char  *rtcpname;
  char  *email;
  char  *tool;
  char  mensuration[USER_MENSURATIONLEN];
  char  message[MESS_LEN];
  int   lastmess;
  bool  have_entry;
  uint8_t hit;
  class Carrier *car;	///< Carrier
  class Cart *cart;	///< Cart

  bool   kpressed[MAXKEYS];	///< is the key pressed ?
  time_t kpstart_s[MAXKEYS];	///< key press starting time (sec)
  time_t kpstart_u[MAXKEYS];	///< key press starting time (usec)
  time_t kpdur_s[MAXKEYS];	///< key press duration from starting time sec
  time_t kpdur_u[MAXKEYS];	///< key press duration from starting time usec
#if 0
  uint8_t weight;
  /* Adding aura (=sphere) of user object */
  float aura_center[3]; // center of sphere
  float aura_radius;    // sphere's radius
#endif

  static const WClass wclass;	///< class variable
  static const uint8_t props;
  virtual const WClass* getWClass() {return &wclass;};
  /**< Returns instance of this class */

  User(const char *name, const char *front, const char *back);
  User(uint8_t type_id, NetObjectId noid, Payload *pp);
  User() {};
  /**< Constructors */

  virtual ~User();
  /**< Destructor */

  // factory methods
  static User * createLocal(const char *localusername,
                            const char *front, const char *back);
  static void updateTime2(WObject *pu, time_t sec, time_t usec, float *lasting);
  static WObject * replicator(uint8_t type_id, NetObjectId noid, Payload *pp);

  virtual bool isMoving();
  virtual void changePermanent(float lasting);
  virtual void updateTime(time_t sec, time_t usec, float *last);
  virtual bool updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void whenWallIntersect(WObject *pold, V3 *norm);

  static void userWriting(const char *usermsg);
  /**< Signals a message sent by an user */

  virtual void clearKeyTab();
  /** Clears keys times array */

  virtual void updateKeysTimes(time_t sec, time_t usec);
  /** Updates the keydifftime arrays */

  virtual void changePositionOneDir(const int move_type, const float last);
  /** Modifies user position in one direction */

  virtual void updateTime(float lasting[]);
  /** Fills delays's array for each user motion direction */

  virtual void changePosition(const float lasting[]);
  /** Does the motion in each direction */

  virtual void elementaryUserMovement(const float lastings[]);
  /** User motion limited by the maxlast */

  virtual void userMovement(time_t sec, time_t usec);
  /** User general motion */

  virtual void userGeometry(const char *front, const char *back);
  /** User geometry */

protected:
  void userMemory();
};

void USER_INIT(void);

void bulletPutHit(class Bullet *po, Payload *pp);
void dartPutHit(class Dart *po, Payload *pp);


#endif // USER_H
