#include "global.h"
#include "wo.h"
#include "world.h"	// getCurrentName
#include "ball.h"	// BALL_TYPE
#include "dart.h"	// DART_TYPE
#include "bullet.h"	// BULLET_TYPE
#include "thing.h"	// THING_TYPE
#include "move.h"	// GRAVITY
#include "walls.h"	// wallsIntersectObject
#include "carrier.h"	// Carrier
#include "cart.h"	// Cart
#include "user.h"

#include "net.h"	// NetObject
#include "vgl.h"	// Solid
#include "gui.h"	// GuiAddUser
#include "rtpsess.h"	// CNAME_LEN


const WClass User::wclass(USER_TYPE, "User", NULL, User::replicator);
const uint8_t User::props = USER_PROPS;


void User::userMemory()
{
  urlfront = new char[URL_LEN];
  urlback  = new char[URL_LEN];
  urlleft  = new char[URL_LEN];
  urlright = new char[URL_LEN];
  vre      = new char[URL_LEN];
  web      = new char[URL_LEN];
  model    = new char[URL_LEN];
  face     = new char[URL_LEN];
  color    = new char[URL_LEN];
  baps     = new char[URL_LEN];
  rtcpname = new char[RTPNAME_LEN];
  email    = new char[EMAIL_LEN];
  tool     = new char[TOOL_LEN];
}

void User::userGeometry(const char *front, const char *back)
{
  char geom[BUFSIZ];

  /* fill mapping fields */
  if (my_widthstr)	width = atof(my_widthstr) / 2;
  if (my_depthstr)	depth = atof(my_depthstr) / 2;
  if (my_heightstr)	height = atof(my_heightstr) / 2;
  if (my_mapfrontstr)	strcpy(urlfront, my_mapfrontstr);
  else			strcpy(urlfront, front);
  if (my_mapbackstr)	strcpy(urlback, my_mapbackstr);
  else			strcpy(urlback, back);
  if (my_mapleftstr)	strcpy(urlleft, my_mapleftstr);
  else			*urlleft = 0;
  if (my_maprightstr)	strcpy(urlright, my_maprightstr);
  else			*urlright = 0;
  if (my_vrestr)	strcpy(vre, my_vrestr);
  else			*vre = 0;
  if (my_webstr)	strcpy(web, my_webstr);
  else			*web = 0;
  if (my_modelstr)	strcpy(model, my_modelstr);
  else			*model = 0;
  if (my_facestr)	strcpy(face, my_facestr);
  else			*face = 0;
  if (my_colorstr)	strcpy(color, my_colorstr);
  else			*color = 0;
  if (my_bapsstr)	strcpy(baps, my_bapsstr);

  if (isalpha(*model)) {	// not tested
    sprintf(mensuration, "bbox,size=%.2f,%.2f,%.2f", depth, width, height);
    sprintf(geom, "%s", mensuration);
  }
  else {
    sprintf(mensuration, "box,size=%.2f,%.2f,%.2f", depth, width, height);
            //BUG-4.4.0 width, depth, height);		//x and y inverted
    //BUG-4.4.0 sprintf(geom, "%s,tex_xp=%s,tex_xn=%s", mensuration, urlfront, urlback);
    sprintf(geom, "%s,tex_yp=%s,tex_xp=%s", mensuration, urlfront, urlback);
    if (*urlleft) {
      char leftstr[URL_LEN];
      sprintf(leftstr, ",tex_xn=%s", urlleft);		//orig yp <4.4.0
      strcat(geom, leftstr);
    }
    if (*urlright) {
      char rightstr[URL_LEN];
      sprintf(rightstr, ",tex_yn=%s", urlright);	//orig yn <4.4.0
      strcat(geom, rightstr);
    }
  }
  trace(DBG_WO, "User: geom=%s", geom);
  parseGeometry(geom);
}

/** Creates localuser */
User * User::createLocal(const char *localusername, const char *front, const char *back)
{
  return new User(localusername, front, back);
}

User::User(const char *localusername, const char *front, const char *back)
{
  lastmess = 0;
  have_entry = false;
  hit = 0;
  lspeed = USER_LSPEED;
  aspeed = USER_ASPEED;
  width = USER_DEFAULTWIDTH / 2;
  depth = USER_DEFAULTDEPTH / 2;
  height = USER_DEFAULTHEIGHT / 2;

  userMemory();
  clearKeyTab();

  ssrc = getMySsrcId();
  strcpy(name.class_name, localusername);	// to review: USER_NAME
  name.instance_name = name.class_name;		// temporally
  name.world_name = World::getCurrentName();
  strcpy(rtcpname, Rtp::getRtcpName());
  strcpy(email, Rtp::getRtcpEmail());
  strcpy(tool, Rtp::getRtcpTool());

  trace(DBG_WO, "User: name=%s ssrc=%x rtcpname=%s email=%s", name.instance_name, ssrc, rtcpname, email);

#ifdef RANDOM_ORIGIN
  pos.x = (float) drand48() * 2 -1;
  pos.y = (float) drand48() * 2 -1;
  pos.az = (float) drand48() * M_2PI;
#else
  pos.x = 0;
  pos.y = 0;
  pos.az = 0;
#endif
  pos.z = height + 0.15;	// jump to fall down on the floor

  userGeometry(front, back);

  type = USER_TYPE;
  setWObjectId();
  update3D();
  getBB();
  insertObjectIntoGrid();
  enableBehavior(INVISIBLE);	// not visible by myself
  setMaxLasting(USER_LASTING);	// 15 ms

  mobileList = addObjectToList(mobileList);

  enablePermanentMovement();	// gravity
  cameraProjection(USER_FOVY, USER_NEAR, USER_FAR); // view from user

  createVolatileNetObject(props);
  //pd noh->declareObjCreation(); // we don't need because delta

  guip = GuiAddUser(this);	// inform GUI

  // PLD : initialize cart
  cart = new Cart("name=\"caddy\"");
  car = new Carrier();
}

/** Replicates an user from the network */
WObject * User::replicator(uint8_t type_id, NetObjectId _noid, Payload *pp)
{
  return new User(type_id, _noid, pp);
}

User::User(uint8_t type_id, NetObjectId _noid, Payload *pp)
{
  type = type_id;

  userMemory();

  replicateVolatileNetObject(props, _noid);
  copyNetObjectId(_noid);

  /* hack to retrieve the name and the mapping */ 
  noh->getProperty(/*  0 */ USER_PROPHNAME, pp);
  noh->getProperty(/*  1 */ USER_PROPMAPFRONT, pp);
  noh->getProperty(/*  2 */ USER_PROPMAPBACK, pp);

  int idxgeom, idxend = 0;
  char geometry[BUFSIZ];

  int idxvar = pp->tellPayload();	// note begin of var
  trace(DBG_WO, "idxvar=%d[%02x]", idxvar, idxvar);
  if ((idxgeom = pp->tellStrInPayload("box,size=")) > 0) {
    /* get replicated user characteristics from the network */
    trace(DBG_WO, "idxgeom=%d[%02x]", idxgeom, idxgeom);
    noh->getProperty(/* 09 */ USER_PROPMENSURATION, pp);
    noh->getProperty(/* 10 */ USER_PROPMAPLEFT, pp);
    noh->getProperty(/* 11 */ USER_PROPMAPRIGHT, pp);
    noh->getProperty(/* 12 */ USER_PROPVRE, pp);
    noh->getProperty(/* 13 */ USER_PROPWEB, pp);
    noh->getProperty(/* 14 */ USER_PROPSSRC, pp);
    noh->getProperty(/* 15 */ USER_PROPRTCPNAME, pp);
    noh->getProperty(/* 16 */ USER_PROPRTCPEMAIL, pp);
    noh->getProperty(/* 17 */ USER_PROPMODEL, pp);
    noh->getProperty(/* 18 */ USER_PROPFACE, pp);
    noh->getProperty(/* 19 */ USER_PROPCOLOR, pp);
    idxend = pp->tellPayload();	// note end of properties

    if (isalpha(*model)) {
      sprintf(geometry, "%s", mensuration);
    }
    else {
      //BUG-4.4.0 sprintf(geometry,"%s,tex_xp=%s,tex_xn=%s,tex_yp=%s,tex_yn=%s",
      sprintf(geometry, "%s,tex_yp=%s,tex_xp=%s", mensuration, urlfront, urlback);
      if (*urlleft) {
        strcat(geometry, ",tex_xn=");
        strcat(geometry, urlleft);
      }
      if (*urlright) {
        strcat(geometry, ",tex_yn=");
        strcat(geometry, urlright);
      }

    }
  }
  else {
    /* builtin user geometry */
    sprintf(geometry, "box,size=%.2f,%.2f,%.2f,tex_xp=%s,tex_xn=%s",
            USER_DEFAULTWIDTH/2, USER_DEFAULTDEPTH/2, USER_DEFAULTHEIGHT/2,
            urlfront, urlback);
  }
  trace(DBG_WO, "Replica: geom=%s", geometry);

  /*
   * solid creation
   */

  /* get the variable properties */
  if (idxend > 0) {
    trace(DBG_WO, "Replica: read var props, idxend=%d", idxend);
    pp->seekPayload(idxvar);	// begin prop var
    for (int np = USER_PROPBEGINVAR; np <= USER_PROPENDVAR; np++)
      noh->getProperty(np, pp);
    pp->seekPayload(idxend);	// end properties
  }
  else {	// never executed
    uint8_t _nbprop = noh->propertiesNumber();
    trace(DBG_WO, "Replica: read all props");
    for (int np = USER_PROPBEGINVAR; np < _nbprop; np++)
      noh->getProperty(np, pp);
  }

  notice("Avatar: ssrc=%x rctpname=%s", ssrc, rtcpname);
  trace(DBG_WO, "Replica: web=%s vre=%s", web, vre);
  trace(DBG_WO, "Replica: model=%s face=%s color=%s", model, face, color);
#if 0
  if (Rtp::getRtcpNameBySsrc(ssrc)) {
    error("Replica: ssrc=%s", Rtp::getRtcpNameBySsrc(ssrc));
  }
#endif

  parseGeometry(geometry);

  initBB(pos);
#if 1
  update3D();
  getBB();
  setObjectToSolid();
  insertObjectIntoGrid();
  mobileList = addObjectToList(mobileList);
#else
  initializeObject(LIST_MOBILE);
#endif

  disablePermanentMovement();

  clearKeyTab();
  lastmess = 0;
  lspeed = USER_EXTLSPEED;	// 10
  aspeed = USER_EXTASPEED;	// 5.0

  name.instance_name = name.class_name;	// a revoir
  name.world_name = World::getCurrentName();
  //rtcpname = Rtp::getRtcpNameBySsrc(ssrc);
  //email = Rtp::getRtcpEmailBySsrc(ssrc);
  tool = Rtp::getRtcpToolBySsrc(ssrc);
  if (tool)
    error("Replica: tool=%s", tool);

  guip = GuiAddUser(this);

#if 0 //obsolete
  /* network ACK = sending fictive Delta (PD - 1998) */
  if (strcmp(worlds->name, worlds->plocaluser->vre) == 0) {
    trace(DBG_FORCE, "netack: %s/%s", worlds->name, worlds->plocaluser->vre);
    declareObjDelta(&(worlds->plocaluser->noh), USER_PROPXY);
    declareObjDelta(&(worlds->plocaluser->noh), USER_PROPZ);
    declareObjDelta(&(worlds->plocaluser->noh), USER_PROPAZ);
  }
#endif //obsolete
} 

User::~User()
{
  trace(DBG_WO, "User %s quits", worlds->plocaluser->name.instance_name);
  GuiRemoveUser(this);

  // MS. if this destructor is called for a remote user,
  // we should not declare the deletion: it's not our problem.
  if (this == worlds->plocaluser && noh)
    noh->declareDeletion();

  if (noh)
    delete noh;		// delete NetObject
  if (soh)
    delete soh;		// delete Solid
  soh = NULL;
}

/** Updates local user towards the network */
bool User::updateToNetwork(const Pos &oldpos)
{
  bool change = false;
  
  if ((pos.x != oldpos.x) || (pos.y != oldpos.y)) {
    noh->declareObjDelta(USER_PROPXY); change = true;
  }
  if (ABSF(pos.z - oldpos.z) > USER_DELTAZ) { // if d < 2cm => not sent
    noh->declareObjDelta(USER_PROPZ); change = true;
  }
  if (pos.az != oldpos.az) {
    noh->declareObjDelta(USER_PROPAZ); change = true;
  }
  if (pos.ay != oldpos.ay) {
    noh->declareObjDelta(USER_PROPAY); change = true;
  }
  if (pos.ax != oldpos.ax) {
    noh->declareObjDelta(USER_PROPAX); change = true;
  }
  return change;
}

/** Updates times array */
void User::updateTime(time_t sec, time_t usec, float *lasting)
{
  *lasting = diffTime(sec, usec);
  if (*lasting < move.ttl) {
    move.ttl -= *lasting;
    move.sec = sec;
    move.usec = usec;
  }
  else {
    *lasting = move.ttl;
    stopImposedMovement();
  }
}

/**
 * Informs a message sent by user
 */
void User::userWriting(const char *usermsg)
{
  strcpy(worlds->plocaluser->message, usermsg);
  worlds->plocaluser->lastmess++;
  worlds->plocaluser->noh->declareObjDelta(USER_PROPMSG); // pkt property
}

static bool pause_gravity = false;

/** equations system handling permanent motions */
void User::changePermanent(float lasting)
{
  if (pause_gravity == false)
    pos.z -= lasting * GRAVITY;
#if 0
  if (Rtp::getRtcpNameBySsrc(ssrc)) {
    error("Replica: Rtp::getRtcpNameBySsrc = %s", Rtp::getRtcpNameBySsrc(ssrc));
  }
#endif
}

/** condition to do position modifications */
bool User::isMoving()
{
  return (move.ttl > 0.0005);
}

void bulletPutHit(Bullet *pbullet, Payload *pp)
{
  pp->putPayload("c", pbullet->hit);
#if 0
  if (pbullet->hit == 1) {
    trace(DBG_FORCE, "bulletPutHit:");
    // pbullet->noh->declareObjDelta(BULLETPROPHIT);
    pp->putPayload("c", pbullet->hit);
    pp->dumpPayload(stdout);
  }
#endif
}

void dartPutHit(Dart *pdart, Payload *pp)
{
  pp->putPayload("c", pdart->hit);
#if 0
  if (pdart->hit == 1) {
    trace(DBG_FORCE, "dartPutHit:");
    // pdart->noh->declareObjDelta(DARTPROPHIT);
    pp->putPayload("c", pdart->hit);
    pp->dumpPayload(stdout);
  }
#endif
}

void User::whenIntersect(WObject *pcur, WObject *pold)
{
  // User has no control over ghost objects
  if (pcur->isBehavior(COLLIDE_GHOST))
    return;

  switch (pcur->type) {
  case BULLET_TYPE:
  case DART_TYPE:
    /* projectile intersects a stopped user: hit */
    if (hit == 0) {
      hit = 1;
#if 1
      if (pcur->type == DART_TYPE) {
        ((Dart *)pcur)->hit = 1;
        noh->sendDelta(DART_PROPHIT);
        ((Dart *)pcur)->hit = 0;
      } else if (pcur->type == DART_TYPE) {
        ((Bullet *)pcur)->hit = 1;
        noh->sendDelta(BULLET_PROPHIT);
        ((Bullet *)pcur)->hit = 0;
      }
#else // FIXME
      Payload *pp = new Payload();

      notice("%s:%s hits %s",
             pcur->name.class_name, pcur->name.instance_name, name.instance_name);
      hit = 1;
      if (pcur->type == BULLET_TYPE) {
        pcur->hit = 1;
        bulletPutHit((Bullet *) pcur, pp);
        pcur->hit = 0;
      }
      if (pcur->type == DART_TYPE) {
        pcur->hit = 1;
        dartPutHit((Dart *) pcur, pp);
        pcur->hit = 0;
      }
#endif
    }
    pold->copyPositionAndBB(pcur);
    pcur->toDelete();	// delete projectile
    break;
  case BALL_TYPE:
#if 0 // FIXME X hangs
    pcur->update3D();
    pcur->getBB();
#else
    pcur->pos.x += BALL_SHIFTX;	// ball shifts
    pcur->pos.y += BALL_SHIFTY;
    pcur->updateObject(pold->pos);
#endif
    break;
  case THING_TYPE:
  case USER_TYPE:
    /* user intersects an other user: slide */
    pcur->pos.x += USER_GOTHROUGH; // step to shift
    pcur->pos.y += USER_GOTHROUGH;
    pcur->update3D();
    pcur->getBB();
    break;
  default:
    pold->copyPositionAndBB(pcur);
  }
}

void User::whenWallIntersect(WObject *puold, V3 *norm)
{
  float nx = norm->v[0];
  float ny = norm->v[1];
  float cx = pos.x;
  float cy = pos.y;
  float ox = puold->pos.x;
  float oy = puold->pos.y;

  if ((ox != cx) || (oy != cy)) {
    float nn = nx*nx + ny*ny;
    if (nn == 0)
      return;
    //trace(DBG_WO, "(ox=%.2f oy=%.2f) (cx=%.2f cy=%.2f)", ox, oy, cx, cy);
    pos.y = ((nx*ny) * (ox-cx) + ny*ny*oy + nx*nx*cy) / nn;
    pos.x = ((nx*ny) * (oy-cy) + nx*nx*ox + ny*ny*cx) / nn;

    /* Changed user position => need to update BBs */
    update3D();
    getBB();
  }
  if (wallsIntersectObject(&pos.bbcenter, &pos.bbsize, norm))
    puold->copyPositionAndBB(this);
}

void userCreateBullet(User *pu, void *d, time_t s, time_t u)
{
  if (generalActionList[BULLET_CREAT][BULLET_TYPE].method != NULL)
#if 0
    generalActionList[BULLET_CREAT][BULLET_TYPE].pu->method(d, s, u);
#else
    generalActionList[BULLET_CREAT][BULLET_TYPE].method(pu, d, s, u);
#endif
}

void userCreateDart(User *pu, void *d, time_t s, time_t u)
{
  if (generalActionList[DART_CREAT][DART_TYPE].method != NULL)
#if 0
    generalActionList[DART_CREAT][DART_TYPE].pu->method(d, s, u);
#else
    generalActionList[DART_CREAT][DART_TYPE].method(pu, d, s, u);
#endif
}

static float fovy = USER_FOVY;
static float near = USER_NEAR;

void userDefaultZoom(User *pu, void *d, time_t s, time_t u)
{
  fovy = USER_FOVY;
  near = USER_NEAR;
  cameraProjection(fovy, near, USER_FAR);
}

void userIncreaseZoom(User *pu, void *d, time_t s, time_t u)
{
  fovy -= 1.0;
  if (fovy <= 1.0) fovy = 1.0;
  cameraProjection(fovy, near, USER_FAR);
}

void userDecreaseZoom(User *pu, void *d, time_t s, time_t u)
{
  fovy += 1.0;
  if (fovy >= 135.0) fovy = 135.0;
  cameraProjection(fovy, near, USER_FAR);
}

void userDefaultLinearSpeed(User *pu, void *d, time_t s, time_t u)
{
  pu->lspeed = USER_LSPEED;
}

void userDecreaseLinearSpeed(User *pu, void *d, time_t s, time_t u)
{
  if (pu->lspeed > 1.0)
    pu->lspeed -= 1.0;
}

void userIncreaseLinearSpeed(User *pu, void *d, time_t s, time_t u)
{
  pu->lspeed += 1.0;
}

void userSetLspeed(User *pu, void *d, time_t s, time_t u)
{
  float *lspeed = (float *) d;
  pu->lspeed = *lspeed;
}

void userDefaultAngularSpeed(User *pu, void *d, time_t s, time_t u)
{
  pu->aspeed = USER_ASPEED;
}

void userDecreaseAngularSpeed(User *pu, void *d, time_t s, time_t u)
{
  if (pu->aspeed > 0.3)
    pu->aspeed -= 0.2;
}

void userIncreaseAngularSpeed(User *pu, void *d, time_t s, time_t u)
{
  pu->aspeed += 0.2;
}

void userSetAspeed(User *pu, void *d, time_t s, time_t u)
{
  float *aspeed = (float *) d;
  pu->aspeed = *aspeed;
}

void userPause(User *pu, void *d, time_t s, time_t u)
{
  pause_gravity ^= 1;
}

void userPauseOn(User *pu, void *d, time_t s, time_t u)
{
  pause_gravity = 1;
}

void userPauseOff(User *pu, void *d, time_t s, time_t u)
{
  pause_gravity = 0;
}

void u_get_xy(WObject *po, Payload *pp)
{
  get_xy(po, pp);
  if (po == worlds->plocaluser) {
    notice("Something's pushing me!");
    po->updateCamera();
  }
}

void u_get_z(WObject *po, Payload *pp)
{
  get_z(po, pp);
  if (po == worlds->plocaluser) {
    notice("Something's lifting me!");
    po->updateCamera();
  }
}

void u_get_ax(WObject *po, Payload *pp)
{
  get_ax(po, pp);
  if (po == worlds->plocaluser) {
    notice("Something's twisting me!");
    po->updateCamera();
  }
}

void u_get_ay(WObject *po, Payload *pp)
{
  get_ay(po, pp);
  if (po == worlds->plocaluser) {
    notice("Something's twisting me!");
    po->updateCamera();
  }
}

void u_get_az(WObject *po, Payload *pp)
{
  get_az(po, pp);
  if (po == worlds->plocaluser) {
    notice("Something's twisting me!");
    po->updateCamera();
  }
}

void get_msg(User *pu, Payload *pp)
{
  if (pu) {
    int mess;
    char msg[MESS_LEN];

    pp->getPayload("ds", &mess, msg);
    if (mess != pu->lastmess) {
      GuiWriteMessage("chat", pu->name.instance_name, msg);
      pu->lastmess = mess;
    }
  }
}

void get_infos(WObject *po, Payload *pp)
{
  if (po) {
    pp->getPayload("s", po->name.infos);
    trace(DBG_WO, "get_infos: %s", po->name.infos);
  }
}

void get_mensuration(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->mensuration);
    trace(DBG_WO, "get_mensuration: %s", pu->mensuration);
  }
}

void get_mapfront(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->urlfront);
    trace(DBG_WO, "get_urlfront: %s", pu->urlfront);
  }
}

void get_mapback(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->urlback);
    trace(DBG_WO, "get_urlback: %s", pu->urlback);
  }
}

void get_mapleft(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->urlleft);
    trace(DBG_WO, "get_urlleft: %s", pu->urlleft);
  }
}

void get_mapright(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->urlright);
    trace(DBG_WO, "get_urlright: %s", pu->urlright);
  }
}

void get_vre(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->vre);
    trace(DBG_WO, "get_vre: %s", pu->vre);
  }
}

void get_web(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->web);
    trace(DBG_WO, "get_web: %s", pu->web);
  }
}

void get_model(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->model);
    trace(DBG_WO, "get_model: %s", pu->model);
  }
}

void get_face(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->face);
    trace(DBG_WO, "get_face: %s", pu->face);
  }
}

void get_color(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->color);
    trace(DBG_WO, "get_color: %s", pu->color);
  }
}

void get_ssrc(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("d", &(pu->ssrc));
    trace(DBG_WO, "get_ssrc: %x", pu->ssrc);
  }
}

void get_rtcpname(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->rtcpname);
    trace(DBG_WO, "get_rtcpname: %s", pu->rtcpname);
  }
}

void get_rtcpemail(User *pu, Payload *pp)
{
  if (pu) {
    pp->getPayload("s", pu->email);
    trace(DBG_WO, "get_rtcpemail: %s", pu->email);
  }
}

void put_msg(User *pu, Payload *pp)
{
  if (pu)
    pp->putPayload("ds", pu->lastmess, pu->message);
}

void put_infos(WObject *po, Payload *pp)
{
  if (po) {
    pp->putPayload("s", po->name.infos);
    trace(DBG_WO, "infos: %s", po->name.infos);
  }
}

void put_mensuration(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->mensuration);
    trace(DBG_WO, "put_mensuration: %s", pu->mensuration);
  }
}

void put_mapfront(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->urlfront);
    trace(DBG_WO, "put_mapfront: %s", pu->urlfront);
  }
}

void put_mapback(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->urlback);
    trace(DBG_WO, "put_mapback: %s", pu->urlback);
  }
}

void put_mapleft(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->urlleft);
    trace(DBG_WO, "put_mapleft: %s", pu->urlleft);
  }
}

void put_mapright(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->urlright);
    trace(DBG_WO, "put_mapright: %s", pu->urlright);
  }
}

void put_vre(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->vre);
    trace(DBG_WO, "put_vre: %s", pu->vre);
  }
}

void put_web(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->web);
    trace(DBG_WO, "put_web: %s", pu->web);
  }
}

void put_model(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->model);
    trace(DBG_WO, "put_model: %s", pu->model);
  }
}

void put_face(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->face);
    trace(DBG_WO, "put_face: %s", pu->face);
  }
}

void put_color(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->color);
    trace(DBG_WO, "put_color: %s", pu->color);
  }
}

void put_ssrc(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("d", pu->ssrc);
    trace(DBG_WO, "put_ssrc: %x", pu->ssrc);
  }
}

void put_rtcpname(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->rtcpname);
    trace(DBG_WO, "put_rtcpname: %s", pu->rtcpname);
  }
}

void put_rtcpemail(User *pu, Payload *pp)
{
  if (pu) {
    pp->putPayload("s", pu->email);
    trace(DBG_WO, "put_rtcpemail: %s", pu->email);
  }
}

/** user functions initialization */
void userInitFuncList(void)
{
  getPropertyFunc[USER_PROPHNAME][USER_TYPE].pf = WO_PAYLOAD get_hname;
  getPropertyFunc[USER_PROPMENSURATION][USER_TYPE].pf = WO_PAYLOAD get_mensuration;
  getPropertyFunc[USER_PROPMAPFRONT][USER_TYPE].pf = WO_PAYLOAD get_mapfront;
  getPropertyFunc[USER_PROPMAPBACK][USER_TYPE].pf = WO_PAYLOAD get_mapback;
  getPropertyFunc[USER_PROPMAPLEFT][USER_TYPE].pf = WO_PAYLOAD get_mapleft;
  getPropertyFunc[USER_PROPMAPRIGHT][USER_TYPE].pf = WO_PAYLOAD get_mapright;
  getPropertyFunc[USER_PROPXY][USER_TYPE].pf = WO_PAYLOAD u_get_xy;
  getPropertyFunc[USER_PROPZ][USER_TYPE].pf = WO_PAYLOAD u_get_z;
  getPropertyFunc[USER_PROPAZ][USER_TYPE].pf = WO_PAYLOAD u_get_az;
  getPropertyFunc[USER_PROPAY][USER_TYPE].pf = WO_PAYLOAD u_get_ay;
  getPropertyFunc[USER_PROPAX][USER_TYPE].pf = WO_PAYLOAD u_get_ax;
  getPropertyFunc[USER_PROPMSG][USER_TYPE].pf = WO_PAYLOAD get_msg;
  getPropertyFunc[USER_PROPVRE][USER_TYPE].pf = WO_PAYLOAD get_vre;
  getPropertyFunc[USER_PROPWEB][USER_TYPE].pf = WO_PAYLOAD get_web;
  getPropertyFunc[USER_PROPSSRC][USER_TYPE].pf = WO_PAYLOAD get_ssrc;
  getPropertyFunc[USER_PROPRTCPNAME][USER_TYPE].pf = WO_PAYLOAD get_rtcpname;
  getPropertyFunc[USER_PROPRTCPEMAIL][USER_TYPE].pf = WO_PAYLOAD get_rtcpemail;
  getPropertyFunc[USER_PROPMODEL][USER_TYPE].pf = WO_PAYLOAD get_model;
  getPropertyFunc[USER_PROPFACE][USER_TYPE].pf = WO_PAYLOAD get_face;
  getPropertyFunc[USER_PROPCOLOR][USER_TYPE].pf = WO_PAYLOAD get_color;

  putPropertyFunc[USER_PROPHNAME][USER_TYPE].pf = WO_PAYLOAD put_hname;
  putPropertyFunc[USER_PROPMENSURATION][USER_TYPE].pf = WO_PAYLOAD put_mensuration;
  putPropertyFunc[USER_PROPMAPFRONT][USER_TYPE].pf = WO_PAYLOAD put_mapfront;
  putPropertyFunc[USER_PROPMAPBACK][USER_TYPE].pf = WO_PAYLOAD put_mapback;
  putPropertyFunc[USER_PROPMAPLEFT][USER_TYPE].pf = WO_PAYLOAD put_mapleft;
  putPropertyFunc[USER_PROPMAPRIGHT][USER_TYPE].pf = WO_PAYLOAD put_mapright;
  putPropertyFunc[USER_PROPXY][USER_TYPE].pf = WO_PAYLOAD put_xy;
  putPropertyFunc[USER_PROPZ][USER_TYPE].pf = WO_PAYLOAD put_z;
  putPropertyFunc[USER_PROPAZ][USER_TYPE].pf = WO_PAYLOAD put_az;
  putPropertyFunc[USER_PROPAY][USER_TYPE].pf = WO_PAYLOAD put_ay;
  putPropertyFunc[USER_PROPAX][USER_TYPE].pf = WO_PAYLOAD put_ax;
  putPropertyFunc[USER_PROPMSG][USER_TYPE].pf = WO_PAYLOAD put_msg;
  putPropertyFunc[USER_PROPVRE][USER_TYPE].pf = WO_PAYLOAD put_vre;
  putPropertyFunc[USER_PROPWEB][USER_TYPE].pf = WO_PAYLOAD put_web;
  putPropertyFunc[USER_PROPSSRC][USER_TYPE].pf = WO_PAYLOAD put_ssrc;
  putPropertyFunc[USER_PROPRTCPNAME][USER_TYPE].pf = WO_PAYLOAD put_rtcpname;
  putPropertyFunc[USER_PROPRTCPEMAIL][USER_TYPE].pf = WO_PAYLOAD put_rtcpemail;
  putPropertyFunc[USER_PROPMODEL][USER_TYPE].pf = WO_PAYLOAD put_model;
  putPropertyFunc[USER_PROPFACE][USER_TYPE].pf = WO_PAYLOAD put_face;
  putPropertyFunc[USER_PROPCOLOR][USER_TYPE].pf = WO_PAYLOAD put_color;

  setActionFunc(USER_TYPE, BULLETUSER, WO_ACTION userCreateBullet, "");
  setActionFunc(USER_TYPE, DARTUSER, WO_ACTION userCreateDart, "");
  setActionFunc(USER_TYPE, FOVYORIGINAL, WO_ACTION userDefaultZoom, "");
  setActionFunc(USER_TYPE, FOVYLESS, WO_ACTION userIncreaseZoom, "");
  setActionFunc(USER_TYPE, FOVYGREATER, WO_ACTION userDecreaseZoom, "");
  setActionFunc(USER_TYPE, LSPEEDORIGINAL, WO_ACTION userDefaultLinearSpeed, "");
  setActionFunc(USER_TYPE, LSPEEDLESS, WO_ACTION userDecreaseLinearSpeed, "");
  setActionFunc(USER_TYPE, LSPEEDGREATER, WO_ACTION userIncreaseLinearSpeed, "");
  setActionFunc(USER_TYPE, ASPEEDORIGINAL, WO_ACTION userDefaultAngularSpeed, "");
  setActionFunc(USER_TYPE, ASPEEDLESS, WO_ACTION userDecreaseAngularSpeed, "");
  setActionFunc(USER_TYPE, ASPEEDGREATER, WO_ACTION userIncreaseAngularSpeed, "");
  setActionFunc(USER_TYPE, USERPAUSE, WO_ACTION userPause, "");
  setActionFunc(USER_TYPE, USERPAUSEON, WO_ACTION userPauseOn, "");
  setActionFunc(USER_TYPE, USERPAUSEOFF, WO_ACTION userPauseOff, "");
  setActionFunc(USER_TYPE, USERSETLSPEED, WO_ACTION userSetLspeed, "");
  setActionFunc(USER_TYPE, USERSETASPEED, WO_ACTION userSetAspeed, "");
}
