#ifndef THING_H
#define THING_H

#define THING_TYPE	39
#define THING_NAME	"Thing"
#define	THING_INIT	thingInitFuncList
#define THING_LASTING	3.0	// 3 s
#define THING_PROPS	4

#define THING_PROPHNAME	0
#define THING_PROPXY	1
#define THING_PROPZ	2
#define THING_PROPAZ	3

#define THING_LSPEED	0.25	// 0.25 m/s
#define THING_TTL	2.0	// 2 s

#define THING_INACTIVE	0
#define THING_TAKEN	1
#define THING_DROP	2

/**
 * Thing Class
 */
class Thing: public WObject {
 public:
  float lspeed;	///< linear speed
  float aspeed;	///< angular speed

  static const WClass wclass;	// class variable
  static const uint8_t props;
  virtual const WClass* getWClass() {return &wclass;};

  Thing(char *l);

  static WObject * (creator)(char *l);

  virtual bool isMoving();
  virtual void changePosition(float lasting);
  virtual void changePermanent(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual bool updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void quit();
};

void THING_INIT(void);

#endif // THING_H
