#ifndef SHEET_H
#define SHEET_H

#include "book.h"    // classe Book

#define SHEET_TYPE	44
#define SHEET_NAME	"Sheet"
#define SHEET_INIT	sheetInitFuncList
#define SHEET_LASTING	0.07	// 70 ms
#define SHEET_PROPS	4

#define SHEET_PROPHNAME	0
#define SHEET_PROPXY	1
#define SHEET_PROPZ	2
#define SHEET_PROPAZ	3

#define SHEET_RIGHT	0 
#define SHEET_LEFT	1 

#define SHEET_ARIGHT	0	
#define SHEET_ALEFT	3.14	
#define SHEET_LSPEED	1.0	// 1 m/s
#define SHEET_ASPEED	1.0	// 1 rd/s

/* actions */
#define SHEET_CREATE    	0
#define SHEET_DESTROY	        1
#define SHEET_TURN_RIGHT	2
#define SHEET_TURN_LEFT 	3
#define SHEET_PULL      	4
#define SHEET_ROTATE	        5

#define SHEET_MP3	"/net/vreng/mp3/sheet.mp3"

/**
 * Sheet Class
 */
class Sheet: public WObject {
public:
  static const uint8_t props;

  Book* book;		///< book pointer
  uint8_t status;	///< right | left 
  float aright;		///< right angle
  float aleft;		///< left angle
  float aspeed;		///< angular speed
  float lspeed;		///< linear speed
  V3 center;
  V3 size;

  static const uint8_t propCount;

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};

  Sheet(Book* _book, char* l, uint8_t _status, void* d, time_t s, time_t us);
  /**< Constructor called by Book */
#if 0
  Sheet(uint8_t type_id, NetObjectId _noid, Payload *pp);
  /**< Constructor replicator */

  static WObject * replicator(uint8_t type_id, NetObjectId noid, Payload *pp);
#endif

  virtual bool isMoving();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual bool updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void quit();
};

void SHEET_INIT(void);

#endif // SHEET_H
