#ifndef PARTICLE_H
#define PARTICLE_H

#define PARTICLE_TYPE	31
#define PARTICLE_NAME	"Particle"
#define PARTICLE_INIT	particleInitFuncList

#define PARTICLE_DEF_NUM	5000
#define PARTICLE_DEF_FLOW	500.
#define PARTICLE_DEF_SPEED	1.
#define PARTICLE_DEF_PTSIZE	2
#define PARTICLE_GRAVITY	-9.8
#define PARTICLE_WATERFALL	0
#define PARTICLE_FOUNTAIN	1
#define PARTICLE_RAIN		2
#define PARTICLE_SNOW		3

#if 0 //MacOS-10.2.6
extern "C" {
extern double drand48();        // MacOSX
}
#endif

typedef struct {
  float position[3];	/* current position */
  float previous[3];	/* previous position */
  float velocity[3];	/* velocity (magnitude & direction) */
  float dampening;	/* % of energy lost on collision */
  int alive;		/* is this particle alive? */
} Particles;


/**
 * Particle Class
 */
class Particle: public WObject {
 public:
  Particles *particles;
  uint16_t number;
  uint16_t living;
  uint8_t mode;
  uint8_t pt_size;
  float color[3];
  float flow;
  float speed;
  float ground;
  bool points;

  static const WClass wclass;   // class variable
  virtual const WClass* getWClass() {return &wclass;};

  Particle(char *l);

  static WObject * (creator)(char *l);

  virtual void changePermanent(float lasting);
  virtual void render();
  virtual void quit();
  virtual void init();
  virtual void timeStep(Particles *p, float dt);
  virtual void newParticle(Particles *p, float dt);
  virtual void bounce(Particles *p, float dt);
  //pd virtual void collide(Particles *p);

};

void PARTICLE_INIT(void);

#endif // PARTICLE_H
