#include "global.h"
#include "wo.h"
#include "names.h"


static struct hash_elt hashtable[NAME_HASH_SIZE];


void initObjectsName(void)
{
  for (int i=0; i < NAME_HASH_SIZE; i++)
    memset(hashtable[i].name, 0, OBJNAME_LEN);
}

uint32_t hash_name(const char *str)
{
  uint32_t hval;

  for (hval = 0; *str ; str++)
    hval = ((hval << 8) + *str) % NAME_HASH_SIZE;
  return hval;
}

void WObject::setObjectName(const char *str)
{
  if (! str) {
    error("setObjectName: type=%s name=NULL", name.class_name);
    return;
  }
  uint32_t hval = hash_name(str);
  trace(DBG_WO, "setObjectName: hval=%d name=%s", hval, str);
  while (1) {
    if ((*(hashtable[hval].name) == '\0') ||
	(!strcmp(hashtable[hval].name, NAME_DELETED))) {
      strcpy(hashtable[hval].name, str);
      hashtable[hval].po = this;
      return;
    }
    hval++;
  }
}

WObject * getObjectByName(const char *str)
{
  if (! str) {
    error("getObjectByName: name NULL");
    return NULL;
  }
  uint32_t hval = hash_name(str);
  trace(DBG_WO, "getObjectByName: hval=%d name=%s", hval, str);
  while (1) {
    if (*(hashtable[hval].name) == '\0')
      return NULL;
    if (!strcmp(hashtable[hval].name, str))
      return hashtable[hval].po;
    hval++;
  }
}

void delObjectName(const char *str)
{
  if (! str) {
    error("delObjectName: name NULL");
    return;
  }
  uint32_t hval = hash_name(str);
  while (1) {
    if (*(hashtable[hval].name) == '\0')
      return;
    if (!strcmp(hashtable[hval].name, str)) {
      strcpy(hashtable[hval].name, NAME_DELETED);
      return;
    }
    hval++;
  }
}
