#ifndef MUSIC_H
#define MUSIC_H

#define MUSIC_TYPE	24
#define MUSIC_NAME	"Music"
#define	MUSIC_INIT	musicInitFuncList

#define MUSIC_FMT_MP3	1
#define MUSIC_FMT_MIDI	2

#define MUSIC_INACTIVE 	0
#define MUSIC_PLAYING  	1
#define MUSIC_PAUSE    	2
#define MUSIC_LOOP     	16

#define MUSICC 0

/**
 * Music Class
 */
class Music: public WObject {
 public:
  uint8_t fmt;
  uint8_t status;

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Music(char *l);

  static WObject * (creator)(char *l);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void quit();

#if MUSICC
  virtual void Play(void *data, time_t s, time_t us);
  virtual void Stop(void *data, time_t s, time_t us);
  virtual void Pause(void *data, time_t s, time_t us);
  virtual void Cont(void *data, time_t s, time_t us);
  virtual void Loop(void *data, time_t s, time_t us);
#endif
};

void MUSIC_INIT(void);

#endif // MUSIC_H
