#ifndef MOVIE_H
#define MOVIE_H

#define MOVIE_TYPE	25
#define MOVIE_NAME	"Movie"
#define	MOVIE_INIT	movieInitFuncList


#if HAVE_LIBMPEG
/*
 * Warning! there is a typedef conflict with Boolean type
 * between mpeg.h and X11/Intrinsic.h
 */
#define Boolean Fuck_Boolean_X11
#include <mpeg.h>
#endif

#define MOVIE_INACTIVE	0	// To indicate
#define MOVIE_PLAYING	1	// the screen
#define MOVIE_PAUSE	2	// status
#define MOVIE_LOOP	16	// Loop or stop at end of film

#define MOVIE_FPS	10	// max number of frames decoded per rendering
#define MOVIE_FULL	0	// modify this value then recompile if you
				//  dont want your image to be resized to
                                //  fill the screen
/**
 * Movie Class
 */
class Movie: public WObject {
 public:
  uint8_t status;		// status
  uint8_t first;		// first frame
  uint8_t fps;			// frame per sec
  uint8_t rate;			// mpeg frames per second
  int texnum;			// texture number
  uint16_t mpegwidth;		// mpeg width in pixels
  uint16_t mpegheight;		// mpeg height in pixels
  uint16_t screensize;		// screen width/height in pixels
  uint16_t frame;		// the current frame being displayed
  char *cachempeg;		// name of the mpeg file in cache
  FILE *fpmpeg;			// the corresponding file pointer
  struct timeval start;		// video starting time
  GLubyte *pixscreen;		// pixmap of the screen
  uint8_t *pixmpeg;		// pixmap of the video
#if HAVE_LIBMPEG
  ImageDesc *imgmpeg;		// this is a structure used by mpeg_lib to
				// store infos, see mpeg_lib for more info
#endif

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};

  Movie(char *l);

  static WObject * (creator)(char *l);
  virtual void changePermanent(float lasting);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void quit();

#if 0 //TODO
  virtual void play(void *data, time_t s, time_t us);
  virtual void stop(void *data, time_t s, time_t us);
  virtual void pause(void *data, time_t s, time_t us);
  virtual void rewind(void *data, time_t s, time_t us);
  virtual void loop(void *data, time_t s, time_t us);
#endif

  virtual int mpegInit();

};

void MOVIE_INIT(void);

#endif // MOVIE_H

