#ifndef MODEL_H
#define MODEL_H

#include "lwo.h"	// lwObject

#define MODEL_TYPE 	46
#define MODEL_NAME 	"Model"
#define	MODEL_INIT 	modelInitFuncList

#define	MODEL_EXT_LWO	"lwo"
#define	MODEL_EXT_3DS	"3ds"
#define	MODEL_EXT_AC3D	"ac3d"

#define	MODEL_MIME_LWO	"x-lwo"
#define	MODEL_MIME_3DS	"x-3ds"
#define	MODEL_MIME_AC3D	"x-ac3d"

enum {
  MODEL_TYPE_UNKNOWN=1,
  MODEL_TYPE_LWO,
  MODEL_TYPE_3DS,
  MODEL_TYPE_AC3D
};

/**
 * Model Class
 */
class Model: public WObject {
 public:
  int model_type;
  float scale;
  lwObject *lwomodel;

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};

  Model(char *l);
  virtual ~Model();

  static WObject * (creator)(char *l);

  virtual void render();

  static int getModelTypeByMime(char *str);
  static int getModelTypeByExt(char *str);
};

void MODEL_INIT(void);

#endif // MODEL_H
