#include "global.h"
#include "wo.h"
#include "world.h"
#include "http.h"	// httpOpen
#include "model.h"


const WClass Model::wclass(MODEL_TYPE, "Model", Model::creator);
void modelInitFuncList(void) {}

static const char *model_types[] = {
  MODEL_EXT_LWO,  MODEL_MIME_LWO,  (char *) MODEL_TYPE_LWO,
  MODEL_EXT_3DS,  MODEL_MIME_3DS,  (char *) MODEL_TYPE_3DS,
  MODEL_EXT_AC3D, MODEL_MIME_AC3D, (char *) MODEL_TYPE_AC3D,
  NULL,		  NULL,		   (char *) MODEL_TYPE_UNKNOWN
};

int Model::getModelTypeByMime(char *str)
{ 
  const char **t = model_types;
    
  while (t[1]) {
    if (!strcmp(t[1], str))
      return (int32_t) t[2];
    t += 3;
  }
  return (int32_t) t[2];
}

int Model::getModelTypeByExt(char *str)
{
  char *p = str + strlen(str)-1;
  const char **t = model_types;
  
  while (p>str && *p != '.') p--;
  if (*p == '.') {
    p++;
    while (t[0]) {
      if (!strcmp(t[0], p))
        return (int32_t) t[2];
      t += 3;
    }
  } 
  return (int32_t) t[2];
}

WObject * Model::creator(char *l)
{
  return new Model(l);
}

Model::Model(char *l)
{
  scale = 1.;

  l = parseObject(l);
  l = parseString(l, name.url, "url");

  model_type = getModelTypeByExt(name.url);

  switch (model_type) {
  case MODEL_TYPE_LWO:
    httpOpen(name.url, lwoHttpReader, &lwomodel, THREAD_NO_BLOCK);
    if (! lwomodel) {
      error("Model: error loading LWO");
      return;
    }
    break;
  default:
    warning("Model: unknown type=%d url=%s", model_type, name.url);
    return;
  }

  if (l) {
    if (!strncmp(l, "scale", 5))
      l = parseFloat(l, &scale, "scale");
  }
  else {
    switch (model_type) {
    case MODEL_TYPE_LWO:
      if (lwomodel)
        scale = lw_object_radius(lwomodel);
      break;
    default:
      break;
    }
  }
  switch (model_type) {
  case MODEL_TYPE_LWO:
    if (lwomodel)
      lw_object_scale(lwomodel, scale);
    break;
  default:
    break;
  }

  enableBehavior(NO_SELECTABLE);	// should be selectable
  initializeObject(LIST_STILL);
} 

Model::~Model()
{
  switch (model_type) {
  case MODEL_TYPE_LWO:
    if (lwomodel)
      lw_object_free(lwomodel);
    break;
  default:
    break;
  }
}

void Model::render()
{
  switch (model_type) {
  case MODEL_TYPE_LWO:
    if (lwomodel)
      lw_object_show(lwomodel);
    break;
  default:
    break;
  }
}
