#include "global.h"
#include "wo.h"
#include "user.h"	// USER_TYPE
#include "mirror.h"

#include "vgl.h"	// setSolidReflexive

const WClass Mirror::wclass(MIRROR_TYPE, "Mirror", Mirror::creator);


WObject * Mirror::creator(char *l)
{
  return new Mirror(l);
}

Mirror::Mirror(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);

  enableBehavior(COLLIDE_ONCE);
  initializeObject(LIST_STILL);

  soh->setSolidReflexive(true);
} 

void Mirror::whenIntersect(WObject *pcur, WObject *pold)
{
  switch (pcur->type) {
  case USER_TYPE:
    if (projectMovementOnObject(pcur->pos, pold->pos, pos))
      pcur->updateObject(pold->pos);
    else
      pold->copyPositionAndBB(pcur);
    break;
  default:
    pold->copyPositionAndBB(pcur);
  }
}

void mirrorOn(Mirror *po, void *d, time_t s, time_t u)
{
  po-> soh->setSolidReflexive(true);
}

void mirrorOff(Mirror *po, void *d, time_t s, time_t u)
{
  po-> soh->setSolidReflexive(false);
}

void mirrorInitFuncList(void)
{
  setActionFunc(MIRROR_TYPE, 0, WO_ACTION mirrorOn, "On");
  setActionFunc(MIRROR_TYPE, 1, WO_ACTION mirrorOff, "Off");
}
