#include "global.h"
#include "wo.h"
#include "mirage.h"

#define MOON_INCR	1.0 // 1m

const WClass Mirage::wclass(MIRAGE_TYPE, "Mirage", Mirage::creator);
void mirageInitFuncList(void) {}

static float x0x0y0y0, maxx, maxy, minx, miny;

WObject * Mirage::creator(char *l)
{
  return new Mirage(l);
}

Mirage::Mirage(char *l)
{
  self = false;
  orbit = false;
  aspeed = MIRAGE_ASPEED;

  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  while (l) {
    if (!strncmp(l, "aspeed", 6))
      l = parseFloat(l, &aspeed, "aspeed");
    else if (!strncmp(l, "mode=\"self\"", 11) || !strncmp(l, "mode=\"earth\"", 12)) {
      self = true;
      l = strtok(NULL, SEP);
    }
    else if (!strncmp(l, "mode=\"orbit\"", 12)) {
      orbit = true;
      x0x0y0y0 = pos.x*pos.x + pos.y*pos.y;
      maxx = maxy = (float) sqrt(x0x0y0y0);
      minx = miny = -maxx;
      l = strtok(NULL, SEP);
    }
  }

  enableBehavior(COLLIDE_NEVER);
  if (self || orbit) {
    initializeObject(LIST_MOBILE);
    enablePermanentMovement();
  }
  else
    initializeObject(LIST_STILL);
} 

/* system of equations handling permanent motion */
void Mirage::changePermanent(float lasting)
{
  if (self) {
    pos.az -= lasting * aspeed;
    pos.az -= M_2PI * (float) floor(pos.az / M_2PI);
  }
  if (orbit) {
    float sx, sy, dx, dy;
  
    if (pos.x >= maxx || pos.y <= miny) {
      //trace(DBG_WO, "pi/2, 2pi");
      sx = +1; sy = +1;
    }
    else if (pos.y >= maxy || pos.x <= minx) {
      //trace(DBG_WO, "pi, 3pi/2");
      sx = -1; sy = -1;
    }
    else if ((pos.y >= 0 && pos.x <= 0) || (pos.y <= 0 && pos.x <= 0)) {
      //trace(DBG_WO, "pi -> 3pi/2, 3pi/2 -> 2pi");
      sx = -1; sy = -1;
    }
    else {
      //trace(DBG_WO, "pi/2 -> pi, 2pi -> pi/2");
      sx = +1; sy = +1;
    }
    //pd dy = sy * MOON_INCR;
    dy = sy / getRate();
    pos.y += dy;
    dx = (float) sqrt(fabs(x0x0y0y0 - pos.y*pos.y));
    pos.x = sx * dx;
    //trace(DBG_WO, "x=%.1f y=%.1f dx=%.1f dy=%.1f %.0f", pos.x, pos.y, dx, dy, (float) sqrt(pos.x*pos.x + pos.y*pos.y));

    update3D();
    getBB();
  }
}
