#ifndef MATRIX_H
#define MATRIX_H

#define MATRIX_TYPE	47
#define MATRIX_NAME	"Matrix"
#define	MATRIX_INIT	matrixInitFuncList

enum {
  MATRIX_NONE = 0,
  MATRIX_PUSH,
  MATRIX_POP,
  MATRIX_ROT,
  MATRIX_TRANS,
  MATRIX_SCALE
};

/**
 * Matrix Class
 * Push, Pop, Rot, Trans  operate a change
 * - either local repere
 * - either a change on the local repere
 */
class Matrix: public WObject {
 public:
  uint8_t op;	///< matrix operation

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};

  Matrix(char *l);

  static WObject * (creator)(char *l);

  virtual void render();
};

void MATRIX_INIT(void);

#endif	// MATRIX_H

