#include "global.h"
#include "wo.h"


ObjectList::ObjectList()
{
  new_objectlist++;
}

/** Adds a pointer to an object in a list */
ObjectList * WObject::addObjectToList(ObjectList *_list)
{
  ObjectList *list = new ObjectList();

  list->pobject = this;
  list->next = _list;
  return list;
}

#if 0 //todo
ObjectList * WObject::addToMobileList()
{
  mobileList = addObjectToList(mobileList);
}
#endif

/** Adds a pointer to a list if it's not already there */
ObjectList * WObject::addObjectToListOnce(ObjectList *list, int _id)
{
  for (ObjectList *pl = list; pl ; pl = pl->next) {
    if (pl->pobject == this) {
      if (_id == 1)
        error("addObjectToListOnce: duplicated insert (%p %d)", this, this->type);
      else
        error("addObjectToListOnce%d: duplicated update (%p %d)", _id, this, this->type);
      return list;
    }
  }
  return addObjectToList(list);
}

/** Deletes a pointer to an object in a list */
ObjectList * WObject::deleteObjectFromList(ObjectList *list)
{
  ObjectList *firstelt = list, *nextelt = list, *tmplist = list;

  if (! list) {
    warning("deleteObjectFromList: object %s:%s from a NULL list",
            name.class_name, name.instance_name);
    return NULL;
  }
  if (! list->pobject) {
    warning("deleteObjectFromList: list->pobj NULL");
    return NULL;
  }
  if (list->pobject == this) {
    firstelt = list->next;
    delete list;
    list = NULL;
    return firstelt;
  }
  while (tmplist && tmplist->pobject != this) {
    nextelt = tmplist;
    tmplist = tmplist->next;
  }
  if (! tmplist) {
    return firstelt;
  }

  nextelt->next = tmplist->next;
  delete tmplist;
  tmplist = NULL;
  return firstelt;
}

ObjectList::~ObjectList()
{
  del_objectlist++;
}

/** Frees an object list */
void ObjectList::freeObjectList()
{
  for (ObjectList *pl = this; pl ; ) {
    ObjectList *nextelt;

    nextelt = pl->next;
    if (pl->pobject && pl->pobject->type)	//FIXME: BUG! macosx iconStick
#if DARWIN
#endif
      delete pl;
    pl = nextelt;
  }
}

/** Concatenates a pointers list on an object */
ObjectList * addObjectList(ObjectList *l1, ObjectList *l2)
{
  if (! l1)
    return l2;
  return addObjectList(l1->next, l1->pobject->addObjectToList(l2));
}

/** Concatenates (with test of ispointed & object) pointers list on an object */
ObjectList * WObject::addObjectListToList(ObjectList *l1, ObjectList *l2)
{
  if (! l1) {
    if (l2) {
      if (l2->pobject != this)
	return l2;
      else
        return NULL;
    }
    else
      return NULL;
  }
  else {
    if (l1->pobject->isValid() && !(l1->pobject->state.ispointed) && (l1->pobject != this)) {
      l1->pobject->state.ispointed = true;
      return addObjectListToList(l1->next, l1->pobject->addObjectToList(l2));
    }
    else
      return addObjectListToList(l1->next, l2);
  }
}

/** Clears flags "ispointed" of all objects in a list */
void ObjectList::clearIspointedFlag()
{
  for (ObjectList *pl = this; pl && pl->pobject; pl = pl->next)
    pl->pobject->state.ispointed = false;
}

/** Returns the list of objects with the given type id in the given list */
ObjectList * ObjectList::getObjectsWithType(int _type)
{
  ObjectList *list = NULL;

  for (ObjectList *pl = mobileList; pl ; pl = pl->next) {
    if (pl->pobject->type == _type)
      list = pl->pobject->addObjectToList(list);
  }
  return list;
}

/** Returns the object from the mobile list */
WObject * ObjectList::findObjectInMobile(uint8_t _type, uint32_t src_id, uint16_t port_id, uint16_t obj_id)
{
  for (ObjectList *pl = mobileList; pl ; pl = pl->next) {
    if ((pl->pobject->type == _type)
    &&  (pl->pobject->getSrcId() == src_id)
    &&  (pl->pobject->getPortId() == port_id)
    &&  (pl->pobject->getObjId() == obj_id)) {
      return pl->pobject;
    }
  }
  return NULL;
}
