#include "global.h"
#include "wo.h"
#include "light.h"


const WClass Light::wclass(LIGHT_TYPE, "Light", Light::creator);
void lightInitFuncList(void) {}


/* creation from a file */
WObject * Light::creator(char *l)
{
  return new Light(l);
}

Light::Light(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);

  initializeObject(LIST_INVISIBLE);

  float light_position[4];
  static float light_diffuse[4] = {1, 1, 1, 1};
  static float light_ambient[4] = {1, 1, 1, 1};
  static float light_specular[4] = {1, 1, 1, 1};
  static float light_spot_direction[4] = {-1, 0, 0, 0};
  static float light_spot_cutoff[1] = {180};

  light_position[0] = pos.x;
  light_position[1] = pos.y;
  light_position[2] = pos.z;
  light_position[3] = pos.az;
  light_spot_cutoff[0] = pos.ax;

  glDisable(GL_LIGHT0);
  glDisable(GL_LIGHT1);
  glEnable(GL_LIGHT2);
  glLightfv(GL_LIGHT2, GL_POSITION, light_position);
  glLightfv(GL_LIGHT2, GL_DIFFUSE, light_diffuse);
  glLightfv(GL_LIGHT2, GL_AMBIENT, light_ambient);
  glLightfv(GL_LIGHT2, GL_SPECULAR, light_specular);
  glLightfv(GL_LIGHT2, GL_SPOT_DIRECTION, light_spot_direction);
  glLightfv(GL_LIGHT2, GL_SPOT_CUTOFF, light_spot_cutoff);
} 

void Light::quit()
{
  glDisable(GL_LIGHT2);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHT1);
}
