#include "global.h"
#include "wo.h"
#include "move.h"	// setmaxlasting

#include "net.h"	// NetObject::setPropertiesNumber

/***    object includes    ***/
#include "user.h"	/* 01 */
#include "wall.h"	/* 02 */
#include "door.h"	/* 03 */
#include "caul.h"	/* 04 */
#include "ball.h"	/* 05 */
#include "step.h"	/* 06 */
#include "mirage.h"	/* 07 */
#include "gate.h"	/* 08 */
#include "host.h"	/* 09 */
#include "board.h"	/* 10 */
#include "web.h"	/* 11 */
#include "button.h"	/* 12 */
#include "anim.h"	/* 13 */
#include "lift.h"	/* 14 */
#include "bullet.h"	/* 15 */
#include "dart.h"	/* 16 */
#include "text.h"	/* 17 */
#include "aoi.h"	/* 18 */
#include "doc.h"	/* 19 */
#include "walls.h"	/* 20 */
#include "entry.h"	/* 21 */
#include "bgcolor.h"	/* 22 */
#include "light.h"	/* 23 */
#include "music.h"  	/* 24 */
#include "movie.h"	/* 25 */
#include "clip.h"	/* 26 */
#include "clock.h"	/* 27 */
#include "ftp.h"	/* 28 */
#include "mirror.h"	/* 29 */
#include "stars.h"	/* 30 */
#include "particle.h" 	/* 31 */
#include "water.h"	/* 32 */
#include "mech.h"	/* 33 */
#include "guy.h"	/* 34 */
#include "vnc.h"	/* 35 */
#include "vrelet.h"	/* 36 */
#include "vjc.h"	/* 37 */
#include "dbs.h" 	/* 38 */
#include "thing.h"	/* 39 */
#include "android.h"	/* 40 */
#include "carrier.h" 	/* 41 */
#include "cart.h" 	/* 42 */
#include "book.h" 	/* 43 */
#include "sheet.h" 	/* 44 */
#include "icon.h" 	/* 45 */
#include "model.h" 	/* 46 */
#include "matrix.h" 	/* 47 */
//#include "elc.h" 	/* 48 */
//#include "fish.h" 	/* .. */

const struct GeneralInitList generalInitList[] = {
/* 00 */	{END_NAME,	END_TYPE,	NULL},
/* 01 */	{USER_NAME,	USER_TYPE,	USER_INIT},
/* 02 */	{WALL_NAME,	WALL_TYPE,	WALL_INIT},
/* 03 */	{DOOR_NAME,	DOOR_TYPE,	DOOR_INIT},
/* 04 */	{CAULDRON_NAME,	CAULDRON_TYPE,	CAULDRON_INIT},
/* 05 */	{BALL_NAME,	BALL_TYPE,	BALL_INIT},
/* 06 */	{STEP_NAME,	STEP_TYPE,	STEP_INIT},
/* 07 */	{MIRAGE_NAME,	MIRAGE_TYPE,	MIRAGE_INIT},
/* 08 */	{GATE_NAME,	GATE_TYPE,	GATE_INIT},
/* 09 */	{HOST_NAME,	HOST_TYPE,	HOST_INIT},
/* 10 */	{BOARD_NAME,	BOARD_TYPE,	BOARD_INIT},
/* 11 */	{WEB_NAME,	WEB_TYPE,	WEB_INIT},
/* 12 */	{BUTTON_NAME,	BUTTON_TYPE,	BUTTON_INIT},
/* 13 */	{ANIM_NAME,	ANIM_TYPE,	ANIM_INIT},
/* 14 */	{LIFT_NAME,	LIFT_TYPE,	LIFT_INIT},
/* 15 */	{BULLET_NAME,	BULLET_TYPE,	BULLET_INIT},
/* 16 */	{DART_NAME,	DART_TYPE,	DART_INIT},
/* 17 */	{TEXT_NAME,	TEXT_TYPE,	TEXT_INIT},
/* 18 */	{AOI_NAME,	AOI_TYPE,	AOI_INIT},
/* 19 */	{DOC_NAME,	DOC_TYPE,	DOC_INIT},
/* 20 */	{WALLS_NAME,	WALLS_TYPE,	WALLS_INIT},
/* 21 */	{ENTRY_NAME,	ENTRY_TYPE,	ENTRY_INIT},
/* 22 */	{BGCOLOR_NAME,	BGCOLOR_TYPE,	BGCOLOR_INIT},
/* 23 */	{LIGHT_NAME,	LIGHT_TYPE,	LIGHT_INIT},
/* 24 */	{MUSIC_NAME,	MUSIC_TYPE,	MUSIC_INIT},
/* 25 */	{MOVIE_NAME,	MOVIE_TYPE,	MOVIE_INIT},
/* 26 */	{CLIP_NAME,	CLIP_TYPE,	CLIP_INIT},
/* 27 */	{CLOCK_NAME,	CLOCK_TYPE,	CLOCK_INIT},
/* 28 */	{FTP_NAME,	FTP_TYPE,	FTP_INIT},
/* 29 */	{MIRROR_NAME,	MIRROR_TYPE,	MIRROR_INIT},
/* 30 */	{STARS_NAME,	STARS_TYPE,	STARS_INIT},
/* 31 */	{PARTICLE_NAME,	PARTICLE_TYPE,	PARTICLE_INIT},
/* 32 */	{WATER_NAME,	WATER_TYPE,	WATER_INIT},
/* 33 */	{MECH_NAME,	MECH_TYPE,	MECH_INIT},
/* 34 */	{GUY_NAME,	GUY_TYPE,	GUY_INIT},
/* 35 */	{VNC_NAME,	VNC_TYPE,	VNC_INIT},
/* 36 */	{VRELET_NAME,	VRELET_TYPE,	VRELET_INIT},
/* 37 */	{VJC_NAME,	VJC_TYPE,	VJC_INIT},
/* 38 */	{DBS_NAME,	DBS_TYPE,	DBS_INIT},
/* 39 */	{THING_NAME,	THING_TYPE,	THING_INIT},
/* 40 */	{ANDROID_NAME,	ANDROID_TYPE,	ANDROID_INIT},
/* 41 */	{CARRIER_NAME,	CARRIER_TYPE,	CARRIER_INIT},
/* 42 */	{CART_NAME,	CART_TYPE,	CART_INIT},
/* 43 */	{BOOK_NAME,	BOOK_TYPE,	BOOK_INIT},
/* 44 */	{SHEET_NAME,	SHEET_TYPE,	SHEET_INIT},
/* 45 */	{ICON_NAME,	ICON_TYPE,	ICON_INIT},
/* 46 */	{MODEL_NAME,	MODEL_TYPE,	MODEL_INIT},
/* 47 */	{MATRIX_NAME,	MATRIX_TYPE,	MATRIX_INIT},
// /* 48 */	{ELC_NAME,	ELC_TYPE,	ELC_INIT},
// /* .. */	{FISH_NAME,	FISH_TYPE,	FISH_INIT},
/* END */	{"",		UNKNOWN_TYPE,	NULL}

};


/* initialization array of functions pointers */
void initGeneralFuncList(void)
{
  for (int i = 0; i <= OBJECTSNUMBER; i++) {

    // action functions
    for (int j = 0; j < ACTIONSNUMBER; j++) {
      generalActionList[j][i].type_name[0] = '\0';
      generalActionList[j][i].method = NULL;
      //pd generalActionList2[j][i].type_name[0] = '\0';
      //pd generalActionList2[j][i].method = NULL;
    }

    // property functions
    for (int j = 0; j < PROPSNUMBER; j++) {
      getPropertyFunc[j][i].pf = NULL;
      putPropertyFunc[j][i].pf = NULL;
    }    

    // property & maxlasting values
    NetObject::setPropertiesNumber(i, 0);
    setMaxLasting(i, MAXFLOAT);

    // init functions
    if (generalInitList[i].initfunc) {
      trace(DBG_WO, "initfunc: i=%d f=%p", i, generalInitList[i].initfunc);
      generalInitList[i].initfunc();
    }
  }
}
