#include "global.h"
#include "wo.h"
#include "host.h"

#include "app.h"	// startxterm


const WClass Host::wclass(HOST_TYPE, "Host", Host::creator);


/* creation from a file */
WObject * Host::creator(char *l)
{
  return new Host(l);
}

Host::Host(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  l = parseUrl(l, name.url);

  initializeObject(LIST_STILL);
} 

/* object intersects: stop */
void Host::whenIntersect(WObject *pcur, WObject *pold)
{
  pold->copyPositionAndBB(pcur);
}

/* xterm */
void hostConnect(Host *po, void *d, time_t s, time_t u)
{
  char *host = strrchr(po->name.url, '/');

  host++;
  trace(DBG_TOOL, "hostConnect: to %s", host);
  App::startxterm(host);
}

void hostDisconnect(Host *po, void *d, time_t s, time_t u)
{
  App::quitxterm();
}

void Host::quit()
{
  App::quitxterm();
}

void hostInitFuncList(void)
{
  setActionFunc(HOST_TYPE, 0, WO_ACTION hostConnect, "Connect");
  setActionFunc(HOST_TYPE, 1, WO_ACTION hostDisconnect, "Disconnect");
}
