#include "global.h"
#include "wo.h"
#include "world.h"	// World

ObjectList *grid[GRIDL][GRIDW][GRIDH];


/** clear all pointers in the grid */
void World::clearGrid()
{
  for (int x=0; x < GRIDL; x++)
    for (int y=0; y < GRIDW; y++)
      for (int z=0; z < GRIDH; z++)
	grid[x][y][z] = NULL;
}

/** free all the grid */
void World::freeGrid()
{
  for (int x=0; x < GRIDL; x++)
    for (int y=0; y < GRIDW; y++)
      for (int z=0; z < GRIDH; z++) {
        if (grid[x][y][z])
	  grid[x][y][z]->freeObjectList();
	grid[x][y][z] = NULL;
      }
}

/**
 * evalue et remplit le tableau igrid, tableaux d'indices de la position
 * de pos dans la grille
 */
static
void calculateCoordinatesIntoGrid(float pos[3], int igrid[3])
{
  igrid[0] = (int) ((pos[0] + (float)GRIDdX * (GRIDL/2)) / GRIDdX);
  igrid[1] = (int) ((pos[1] + (float)GRIDdY * (GRIDW/2)) / GRIDdY);
  igrid[2] = (int) ((pos[2] + (float)GRIDdZ * (GRIDH/2)) / GRIDdZ);

  igrid[0] = MAX(0, igrid[0]);
  igrid[0] = MIN(GRIDL-1, igrid[0]);
  igrid[1] = MAX(0, igrid[1]);
  igrid[1] = MIN(GRIDW-1, igrid[1]);
  igrid[2] = MAX(0, igrid[2]);
  igrid[2] = MIN(GRIDH-1, igrid[2]);
}

/** add an object in the grid */
void WObject::insertObjectIntoGrid()
{
  if (!isValid()) {
    error("insertObjectIntoGrid: invalid type=%d p=%p", type, this);
    return;
  }

  float pmin[3], pmax[3];
  for (int i=0; i<3; i++) {
    pmin[i] = pos.bbcenter.v[i] - pos.bbsize.v[i]; // coord. min
    pmax[i] = pos.bbcenter.v[i] + pos.bbsize.v[i]; // coord. max
  }

  int imin[3], imax[3];
  calculateCoordinatesIntoGrid(pmin, imin);
  calculateCoordinatesIntoGrid(pmax, imax);

  for (int x=imin[0]; x <= imax[0]; x++)
    for (int y=imin[1]; y <= imax[1]; y++)
      for (int z=imin[2]; z <= imax[2]; z++)
	grid[x][y][z] = addObjectToListOnce(grid[x][y][z], 1);
}

/** delete an object in the grid */
void WObject::deleteObjectFromGrid()
{
#if 0 //MS
  if (!isValid()) {
    error("deleteObjectFromGrid: invalid type=%d p=%p", type, this);
    return;
  }
// M.S. : this estimation doesn't work 100%.
// Doing the above reduces crash rate when
// sending a bunch of darts.
  float pmin[3], pmax[3];

  for (int i=0; i<3; i++) {
    pmin[i] = pos.bbcenter.v[i] - pos.bbsize.v[i];
    pmax[i] = pos.bbcenter.v[i] + pos.bbsize.v[i];
  }

  int imin[3], imax[3];
  calculateCoordinatesIntoGrid(pmin, imin);
  calculateCoordinatesIntoGrid(pmax, imax);

  for (int x=imin[0]; x <= imax[0]; x++)
    for (int y=imin[1]; y <= imax[1]; y++)
      for (int z=imin[2]; z <= imax[2]; z++)
	grid[x][y][z] = deleteObjectFromList(grid[x][y][z]);    
#else
  for (int x=0; x < GRIDL; x++)
    for (int y=0; y < GRIDW; y++)
      for (int z=0; z < GRIDH; z++)
        if (grid[x][y][z])
          grid[x][y][z] = deleteObjectFromList(grid[x][y][z]);
#endif //MS
}

/** update an object in the grid */
void WObject::updateObjectIntoGrid(const Pos &oldpos)
{
  if (!isValid()) {
    error("updateObjectIntoGrid: invalid type=%d p=%p", type, this);
    return;
  }

  float pmin1[3], pmax1[3], pmin2[3], pmax2[3];
  for (int i=0; i<3; i++) {
    pmin1[i] = pos.bbcenter.v[i] - pos.bbsize.v[i];
    pmax1[i] = pos.bbcenter.v[i] + pos.bbsize.v[i];
    pmin2[i] = oldpos.bbcenter.v[i] - oldpos.bbsize.v[i];
    pmax2[i] = oldpos.bbcenter.v[i] + oldpos.bbsize.v[i];
  }

  int imin1[3], imax1[3], imin2[3], imax2[3];
  calculateCoordinatesIntoGrid(pmin1, imin1);
  calculateCoordinatesIntoGrid(pmax1, imax1);
  calculateCoordinatesIntoGrid(pmin2, imin2);
  calculateCoordinatesIntoGrid(pmax2, imax2);

  bool change = false;

  for (int i=0; i<3; i++) {
    if ((imin1[i] != imin2[i]) || (imax1[i] != imax2[i]))
      change = true;
  }

  if (change) {
#if 0
    for (int x=imin2[0]; x <= imax2[0]; x++)
      for (int y=imin2[1]; y <= imax2[1]; y++)
	for (int z=imin2[2]; z <= imax2[2]; z++) {
          //D if (grid[x][y][z] == NULL)
          //D   trace(DBG_WO, "updateObjectIntoGrid: grid[%d][%d][%d]=%x", x, y, z, grid[x][y][z]);
          //D   continue;
	  grid[x][y][z] = deleteObjectFromList(grid[x][y][z]);    
        }
#else
    deleteObjectFromGrid();
#endif
    for (int x=imin1[0]; x <= imax1[0]; x++)
      for (int y=imin1[1]; y <= imax1[1]; y++)
	for (int z=imin1[2]; z <= imax1[2]; z++)
	  grid[x][y][z] = addObjectToListOnce(grid[x][y][z], 2);
  }
}

/** place an object in the grid */
void initBB(Pos &pos)
{
  pos.bbcenter.v[0] = GRIDdX/2;
  pos.bbcenter.v[1] = GRIDdY/2;
  pos.bbcenter.v[2] = GRIDdZ/2;
  pos.bbsize.v[0] = GRIDdX/10;
  pos.bbsize.v[1] = GRIDdY/10;
  pos.bbsize.v[2] = GRIDdZ/10;
}

void testGrid(const char *label)
{
#if 0 //debug
  for (int x=0; x < GRIDL; x++)
    for (int y=0; y < GRIDW; y++)
      for (int z=0; z < GRIDH; z++) {
	ObjectList *tmp = grid[x][y][z];
	while (tmp) {
	  if ((unsigned long)tmp > (unsigned long)0x3000000) {
	    error("%s %d %d %d %p", label, x, y, z, tmp);
	    return;
	  }
	  tmp = tmp->next;
	}
      }
#endif //debug
}  

/**
 * renvoie la liste des pointeurs sur les objets touchant
 * la case des grilles intersectees par la BB englobante des 2 objets
 */
ObjectList * WObject::getVicinityObjectList(const Pos &oldpos)
{
  float pmin[3], pmax[3];
  for (int i=0; i<3; i++) {
    pmin[i] = MIN(pos.bbcenter.v[i] - pos.bbsize.v[i], 
		  oldpos.bbcenter.v[i] - oldpos.bbsize.v[i]);
    pmax[i] = MAX(pos.bbcenter.v[i] + pos.bbsize.v[i], 
		  oldpos.bbcenter.v[i] + oldpos.bbsize.v[i]);
  }

  int imin[3], imax[3];
  calculateCoordinatesIntoGrid(pmin, imin);
  calculateCoordinatesIntoGrid(pmax, imax);

  ObjectList *vicinityList = NULL;
  for (int x=imin[0]; x <= imax[0]; x++)
    for (int y=imin[1]; y <= imax[1]; y++)
      for (int z=imin[2]; z <= imax[2]; z++) {
        //error("x=%d y=%d z=%d", x, y, z);
        vicinityList = addObjectListToList(grid[x][y][z], vicinityList);
      }

  if (vicinityList)
    vicinityList->clearIspointedFlag();
  return vicinityList;
}  
