#include "global.h"
#include "wo.h"
#include "world.h"	// newWorld
#include "user.h"	// USER_TYPE
#include "ball.h"	// BALL_TYPE
#include "dart.h"	// DART_TYPE
#include "bullet.h"	// BULLET_TYPE
#include "gate.h"

#include "gui.h"	// GuiUpdateWorld
#include "channel.h"	// join
#include "app.h"	// playSound


const WClass Gate::wclass(GATE_TYPE, "Gate", Gate::creator);


/** creation from a file */
WObject * Gate::creator(char *l)
{
  return new Gate(l);
}

Gate::Gate(char *l)
{
  char modestr[6];

  autoEnter = false;
  link = false;
  specificEntry = false;
  memset(entry, 0, sizeof(entry));

  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  l = parseWorld(l, name.url);
  while (l) {
    if (!strncmp(l, "channel", 7))
      l = parseChannel(l, chan);
    else if (!strncmp(l, "mode", 4)) {
      l = parseString(l, modestr, "mode");
      if (!strncmp(modestr, "link", 4))
        link = true;
      else if (!strncmp(modestr, "auto", 4))
        autoEnter = true;
    }
    else if (!strncmp(l, "entry", 5)) {
      l = parseVector3f(l, entry, "entry");
      specificEntry = true;
      trace(DBG_WO, "gate: entry=%.2f,%.2f,%.2f,%.2f", entry[0], entry[1], entry[2], entry[3]);
    }
  }
  if (! autoEnter)
    specificEntry = false;

  enableBehavior(COLLIDE_ONCE);
  initializeObject(LIST_STILL);
} 

void gateEnter(Gate *po, void *d, time_t s, time_t u)
{
  if (po->link) {	// without channel
    char *new_url = strdup(po->name.url);
    if (! new_url) {
      error("linkFollow: can't strdup url=%s", new_url);
      return;
    }
    worlds->quit();
    World::newWorld(new_url, NULL, VR_NEW);
    worlds->islinked = true;	// linked world
    free(new_url);
  }
  else {	// with channel
    if (strcmp(po->name.url, universe->urlinitial) == 0) {
      sprintf(po->chan, "%s/%u/%d",
              universe->groupinitial, universe->portinitial, currentTtl());
      trace(DBG_IPMC, "world initial = %s", po->chan);
    }

    /* save url and chan, because World::quit frees po */
    char new_url[URL_LEN], new_chan_str[CHAN_LEN];
    memset(new_chan_str, 0, sizeof(new_chan_str));
    strcpy(new_url, po->name.url);

    // call here the WACS (World Address Cache Server) to get the channel string
    Vac::getChannel(po->name.url, po->chan);
    trace(DBG_WO, "gate: channel=%s", po->chan);

    strcpy(new_chan_str, po->chan);

    worlds->quit();
    delete Channel::getCurrentChannel();	// delete Channel
#if 0
    App::playSound(GATESND);
#endif

    World::newWorld(new_url, new_chan_str, VR_NEW);
    char *chanstr = strdup(Channel::join(new_chan_str));
    trace(DBG_WO, "gateEnter: join channel=%s url=%s", new_chan_str, new_url);

    GuiUpdateWorld(worlds, VR_CURR);

    //TODO declareJoinWorldToManager(new_url, chanstr, worlds->plocaluser->name.instance_name);

    if (audioactive)
      App::startaudio(chanstr);
    free(chanstr);
  }
}

/** when an intersection occurs */
void Gate::whenIntersect(WObject *pcur, WObject *pold)
{
  switch (pcur->type) {
  case USER_TYPE:
    if (autoEnter) {
      if (pcur != worlds->plocaluser) {
	notice("A user was just pushed out of this world");
        return;
      }
      else {
        pcur->state.collide = 0;
        if (specificEntry) {
          specificEntry = false;
          worlds->plocaluser->have_entry = true;
          pcur->pos.x = entry[0];
          pcur->pos.y = entry[1];
          pcur->pos.z = entry[2];
        }
        gateEnter(this, NULL, 0L, 0L);
      }
    }
    else {
      if (pcur->state.collide < 10) {
        pold->copyPositionAndBB(pcur);
        notice("Warning! You are near the gate %s in=%d", name.instance_name, pcur->state.collide);
        pcur->state.collide++;
      }
      else if (pcur->state.collide < 20) {
        pold->copyPositionAndBB(pcur);
        notice("Warning! If you insist you'll enter in the gate %s in=%d", name.instance_name, pcur->state.collide);
        pcur->state.collide++;
      }
      else {
        gateEnter(this, NULL, 0L, 0L);
        pcur->state.collide = 0;
      }
    }
    break;
  case BULLET_TYPE:
  case DART_TYPE:
    notice("%s:%s hits %s:%s",
            pcur->name.class_name, pcur->name.instance_name,
            name.class_name, name.instance_name);
    pold->copyPositionAndBB(pcur);
    pcur->toDelete();
    break;
  case BALL_TYPE:
    if (projectMovementOnObject(pcur->pos, pold->pos, pos))
      pcur->updateObject(pold->pos);
    else
      pold->copyPositionAndBB(pcur);
    break;
  default:	// other objects
    pold->copyPositionAndBB(pcur);
  }
}

void gateInitFuncList(void)
{
  setActionFunc(GATE_TYPE, 0, WO_ACTION gateEnter, "Enter");
}
