#include "global.h"
#include "wo.h"
#include "ftp.h"

#include "app.h"	// startwget

const WClass Ftp::wclass(FTP_TYPE, "Ftp", Ftp::creator);


WObject * Ftp::creator(char *l)
{
  return new Ftp(l);
}

Ftp::Ftp(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  l = parseUrl(l, name.url);

  enableBehavior(COLLIDE_NEVER);
  initializeObject(LIST_STILL);
} 

void ftpGet(Ftp *po, void *d, time_t s, time_t u)
{
  char *pfile = strrchr(po->name.url, '/');
  if (pfile)
    App::startwget(po->name.url, ++pfile, "-O");
}

void ftpInitFuncList(void)
{
  setActionFunc(FTP_TYPE, 0, WO_ACTION ftpGet, "Download");
}
