// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //
#include "global.h"
#include "wo.h"
#include "http.h"	// httpOpen
#include "android.h"
#include "face.h"


static const char headRoot[]		= "root";
static const char frontRoot[]		= "frontRoot";
static const char lipsRoot[]		= "lipsRoot";
static const char lipsTopRoot[]		= "lipsTopRoot";	//pd
static const char lipsBotRoot[]		= "lipsBotRoot";	//pd
static const char eyeLeftRoot[]		= "eyeLeftRoot";
static const char eyeRightRoot[]	= "eyeRightRoot";
static const char eyeLeftTopRoot[]	= "eyeLeftTopRoot";
static const char eyeRightTopRoot[]	= "eyeRightTopRoot";
static const char eyeLeftBotRoot[]	= "eyeLeftBotRoot";
static const char eyeRightBotRoot[]	= "eyeRightBotRoot";
static const char browLeftRoot[]	= "sourcilLeftRoot";
static const char browRightRoot[]	= "sourcilRightRoot";
static const char noseRoot[]		= "noseRoot";
static const char noseExtremity[]	= "noseExtremity";	//pd

static const char eyeLeftTopL[]		= "eyeLeftTopL";
static const char eyeRightTopL[]	= "eyeRightTopL";
static const char eyeLeftTopR[]		= "eyeLeftTopR";
static const char eyeRightTopR[]	= "eyeRightTopR";
static const char eyeLeftBotL[]		= "eyeLeftBotL";
static const char eyeRightBotL[]	= "eyeRightBotL";
static const char eyeLeftBotR[]		= "eyeLeftBotR";
static const char eyeRightBotR[]	= "eyeRightBotR";
static const char browLeftL[]		= "sourcilLeftL";	//pd
static const char browLeftR[]		= "sourcilLeftR";	//pd
static const char browRightL[]		= "sourcilRightL";
static const char browRightR[]		= "sourcilRightR";
static const char noseLeft[]		= "noseLeft";
static const char noseRight[]		= "noseRight";
static const char lipsTopL[]		= "lipsTopL";
static const char lipsTopR[]		= "lipsTopR";
static const char lipsBotL[]		= "lipsBotL";
static const char lipsBotR[]		= "lipsBotR";


/** Caching file */
void cacheFaceHttpReader(void *_url, Http *http)
{
  char *url = (char *) _url;
  char *purl = strrchr(url, '/');
  char tmpfile[MAXHOSTNAMELEN];
  sprintf(tmpfile, "%s/%s", vrengcache, ++purl);
  trace(DBG_MAN, "cacheFaceHttpReader: caching file %s in %s", purl, tmpfile);

  FILE *cache;
  if ((cache = fopen(tmpfile, "rb")) == NULL) {
    if (! http) {
      error("cacheFaceHttpReader: unable to open http connection");
      return;
    }
    if ((cache = fopen(tmpfile, "wb")) == NULL)
      return;

    trace(DBG_MAN, "cacheFaceHttpReader: download url %s", url);
    httpClearBuf();
    while (1) {
      int c = http->GetChar();
      if (c < 0)
        break;
      putc(c, cache);
    }
  }
  fclose(cache);
}

/** Download list of face url */
void urlFacesHttpReader(void *_po, Http *http)
{
  Face *po = (Face *) _po;

  if (! http) {
    error("urlFacesHttpReader: unable to open http connection");
    return;
  }

  char urlline[MAXHOSTNAMELEN];

  httpClearBuf();
  while (http->GetLine(urlline)) {
    char *faceurl = strdup(urlline);
    trace(DBG_MAN, "urlFacesHttpReader: add url=%s", faceurl);
    po->urlList.addElement(faceurl);
    free(faceurl);
  }
}

Face::Face(const char *urlFaces)
{
  mesh = NULL;
  root = NULL;
  moveYes = false;
  moveNo = false;
  moveMouth = false;
  moveSmile = false;
  moveSulk = false;
  moveEyeL = false;
  moveEyeR = false;
  moveNose = false;

  trace(DBG_MAN, "Faces: urlFaces=%s", urlFaces);
  urlList.empty();
  httpOpen(urlFaces, urlFacesHttpReader, this, THREAD_NO_BLOCK);
  currentUrl = rand() % urlList.count();
}

Face::~Face()
{
  smartDelete(mesh);
  smartDelete(root);
  //pd unlink(cachefile);
}

void Face::changeFace()
{
  currentUrl++;
  trace(DBG_MAN, "changeFace: currentUrl=%d count=%d", currentUrl, urlList.count());
  currentUrl %= urlList.count();
  char *urlface = urlList.getElementAt(currentUrl);
  trace(DBG_MAN, "changeFace: urlface=%s urlface=%p urlface[0]=%02x", urlface, urlface, urlface[0]);
  if (! isascii(urlface[0])) {
    error("changeFace: BUG here! urlface=%s", urlface);
    return;
  }
  loadFace(urlface);
}

void Face::loadFace(const char *url)
{
  Mesh3D     *newMesh = new Mesh3D();
  BoneVertex *newRoot = new BoneVertex();

  if (url2cache(url, cachefile) == 0)
    return;		// BUG!!!

  trace(DBG_MAN, "loadFace: url=%s", url);
  httpOpen(url, cacheFaceHttpReader, (void *)url, THREAD_NO_BLOCK);
#if 0
  Factory::readVRE3Dfile(newMesh, newRoot, cachefile, FACE_SCALE);
#else
  Factory::readVRE3Dfile(newMesh, newRoot, cachefile);
#endif
  animator.registerMesh(newMesh);
  animator.registerSkeleton(newRoot);
  animator.generateLinkList();

  smartDelete(mesh); mesh = newMesh;
  smartDelete(root); root = newRoot;
}

void Face::render()
{
  if (! mesh)
    changeFace();

  if (animator.meshToMove != NULL) {
    if (animator.skeleton != NULL) {
      //PD8 animate();
      animator.animate();
      animator.render();
    }
  }
}

void Face::animHead(float angle, int x, int y, int z)
{
  BoneVertex *temp;

  // 0,1,0 pitch (yes)
  // 1,0,0 yaw  (no)
  // 0,0,1 roll (maybe)
  trace(DBG_MAN, "animHead: angle=%.2f", angle);
  if ((temp = root->findChild(headRoot)) != NULL)
    temp->setCurrentRotation(sin(angle/50.0) /* *10 */, x, y, z);
}

void Face::animNose(float angle, const char *_side)
{
  BoneVertex *temp;
  float scale = 1 - cos(angle / 16.) / 4.;

  trace(DBG_MAN, "animNose: angle=%.2f scale=%.2f", angle, scale);
  if ((temp = root->findChild(noseRoot)) != NULL) {
    if ((temp = root->findChild(_side)) != NULL) {
      temp->resetCurrentPosition();
      temp->scaleCurrentPosition(scale, 1, 1);
    }
  }
}

void Face::animEyeBall(float angle, const char *_side, int dir)
{
  BoneVertex *temp;
  float scale = 1 - cos(angle / 16.) /* / 2. */;

  trace(DBG_MAN, "animEyeBall: angle=%.2f scale=%.2f dir=%d", angle, scale, dir);
    if ((temp = root->findChild(_side)) != NULL) {
      temp->resetCurrentPosition();
      temp->scaleCurrentPosition(scale, 1, 1);
      if (dir)
        temp->setCurrentRotation((1-scale) * 20., 0,1,0);	// pitch
      else
        temp->setCurrentRotation((1-scale) * 20., 1,0,0);	// yaw
      temp->resetCurrentPosition();
    }
}

void Face::animEyeLid(float angle, const char *root1, const char *lid, const char *left, const char *right)
{
  BoneVertex *temp;
  //pd float scale = (1 - cos(angle /* / 20. */)) /*/ 2.*/;
  //yr float scale = (1 - cos(angle / 20.)) / 2;
  //pd float scale = (1 - cos(angle / 10.)) / 2;
  float scale = (1 - cos(angle / 20.)) /* / 2 */;

  if ((temp = root->findChild(root1)) != NULL) {
    if ((temp = root->findChild(lid)) != NULL) {
      int sign;
      if (!strcmp(lid, eyeLeftTopRoot) || !strcmp(lid, eyeRightTopRoot))
        sign = 1;
      else
        sign = -1;
      trace(DBG_MAN, "animEyeLid: angle=%.2f scale=%.2f rot=%.2f", angle, scale, sign*(1-scale)*20);
      temp->resetCurrentPosition();
      temp->scaleCurrentPosition(1, scale, 1);
      temp->setCurrentRotation(sign * (1-scale) * 20., 1,0,0);
    }
    if ((temp = root->findChild(left)) != NULL) {
      temp->resetCurrentPosition();
      temp->scaleCurrentPosition(1, scale, 1);
    }
    if ((temp = root->findChild(right)) != NULL) {
      temp->resetCurrentPosition();
      temp->scaleCurrentPosition(1, scale, 1);
    }
  }
}

void Face::animEyeBrow(float angle, const char *_root, const char *_side)
{
  BoneVertex *temp;
  float scale = cos(angle / 5.0);

  trace(DBG_MAN, "animEyeBrow: angle=%.2f scale=%.2f", angle, scale);
  if ((temp = root->findChild(_root)) != NULL) {
    temp->resetCurrentPosition();
    temp->translateCurrentPosition(0, scale / 25.0, 0);
  }
  if ((temp = root->findChild(_side)) != NULL) {
    temp->resetCurrentPosition();
    temp->setCurrentRotation(scale * 10, 0,0,1);
    temp->translateCurrentPosition(0, scale / 25.0, 0);
  }
}

void Face::animLip(float angle, const char *_side)
{
  BoneVertex *temp;

  if ((temp = root->findChild(lipsRoot)) != NULL) {
    //pd Vect3D smileDelta(0, cos(angle/ 10.0) / 4., 0);
    Vect3D smileDelta(0, cos(angle/ 10.0) / 8., 0);
    float smile = cos(angle / 10.0) * 20;

    trace(DBG_MAN, "animLip: angle=%.2f smile=%.2f", angle, smile);
    if ((temp = root->findChild(_side)) != NULL) {
      temp->resetCurrentPosition();
      temp->translateCurrentPosition(smileDelta);
      temp->setCurrentRotation(smile, 0,0,1);
    }
  }
}

void Face::animate(int fapn, int angle)
{
  switch (fapn) {

  case VISEME:			// 1
    if (angle) trace(DBG_MAN, "VISEME %s", e_not_implemented);
    break;
  case EXPRESSION:		// 2
    if (angle) trace(DBG_MAN, "EXPRESSION %s", e_not_implemented);
    break;
  case OPEN_JAW:		// 3
    if (angle) trace(DBG_MAN, "OPEN_JAW %s", e_not_implemented);
    break;
  case LOWER_T_MIDLIP:		// 4
    if (angle) trace(DBG_MAN, "LOWER_T_MIDLIP %s a=%d", e_not_implemented, angle);
    break;
  case RAISE_B_MIDLIP:		// 5
    if (angle) trace(DBG_MAN, "RAISE_B_MIDLIP %s a=%d", e_not_implemented, angle);
    break;
  case STRETCH_L_CORNERLIP:	// 6
    if (angle) trace(DBG_MAN, "STRETCH_L_CORNERLIP %s a=%d", e_not_implemented, angle);
    break;
  case STRETCH_R_CORNERLIP:	// 7
    if (angle) trace(DBG_MAN, "STRETCH_R_CORNERLIP %s a=%d", e_not_implemented, angle);
    break;
  case LOWER_T_LIP_LM:		// 8
    if (angle) trace(DBG_MAN, "LOWER_T_LIP_LM a=%d", angle);
    animLip(angle, lipsTopL);
    break;
  case LOWER_T_LIP_RM:		// 9
    if (angle) trace(DBG_MAN, "LOWER_T_LIP_RM a=%d", angle);
    animLip(angle, lipsTopR);
    break;
  case RAISE_B_LIP_LM:		// 10
    if (angle) trace(DBG_MAN, "LOWER_B_LIP_LM a=%d", angle);
    animLip(angle, lipsBotL);
    break;
  case RAISE_B_LIP_RM:		// 11
    if (angle) trace(DBG_MAN, "LOWER_B_LIP_RM a=%d", angle);
    animLip(angle, lipsBotR);
    break;
  case RAISE_L_CORNERLIP:	// 12
  case RAISE_R_CORNERLIP:	// 13
    if (angle) trace(DBG_MAN, "RAISE_CORNERLIP %s a=%d", e_not_implemented, angle);
    break;
  case THRUST_JAW:		// 14
    if (angle) trace(DBG_MAN, "THRUST_JAW %s a=%d", e_not_implemented, angle);
    break;
  case SHIFT_JAW:		// 15
    if (angle) trace(DBG_MAN, "SHIFT_JAW %s a=%d", e_not_implemented, angle);
    break;
  case PUSH_B_LIP:		// 16
    if (angle) trace(DBG_MAN, "PUSH_B_LIP %s a=%d", e_not_implemented, angle);
    break;
  case PUSH_T_LIP:		// 17
    if (angle) trace(DBG_MAN, "PUSH_T_LIP %s a=%d", e_not_implemented, angle);
    break;
  case DEPRESS_CHIN:		// 18 menton
    if (angle) trace(DBG_MAN, "DEPRESS_CHIN %s a=%d", e_not_implemented, angle);
    break;
  case CLOSE_T_L_EYELID:	// 19
    animEyeLid(angle, eyeLeftRoot, eyeLeftTopRoot, eyeLeftTopL, eyeLeftTopR);
    break;
  case CLOSE_T_R_EYELID:	// 20
    animEyeLid(angle, eyeRightRoot, eyeRightTopRoot, eyeRightTopL, eyeRightTopR);
    break;
  case CLOSE_B_L_EYELID:	// 21
    animEyeLid(angle, eyeLeftRoot, eyeLeftBotRoot, eyeLeftBotL, eyeLeftBotR);
    break;
  case CLOSE_B_R_EYELID:	// 22
    animEyeLid(angle, eyeRightRoot, eyeRightBotRoot, eyeRightBotL, eyeRightBotR);
    break;
  case YAW_L_EYEBALL:		// 23
    if (angle) trace(DBG_MAN, "YAW_L_EYEBALL %s a=%d", e_not_implemented, angle);
    //pd animEyeBall(angle, eyeLeftRoot, 0);
    break;
  case YAW_R_EYEBALL:		// 24
    if (angle) trace(DBG_MAN, "YAW_R_EYEBALL %s a=%d", e_not_implemented, angle);
    //pd animEyeBall(angle, eyeRightRoot, 0);
    break;
  case PITCH_L_EYEBALL:		// 25
    if (angle) trace(DBG_MAN, "PITCH_L_EYEBALL %s a=%d", e_not_implemented, angle);
    //pd animEyeBall(angle, eyeLeftRoot, 1);
    break;
  case PITCH_R_EYEBALL:		// 26
    if (angle) trace(DBG_MAN, "PITCH_R_EYEBALL %s a=%d", e_not_implemented, angle);
    //pd animEyeBall(angle, eyeRightRoot, 1);
    break;
  case THRUST_L_EYEBALL:	// 27
  case THRUST_R_EYEBALL:	// 28
    if (angle) trace(DBG_MAN, "THRUST_EYEBALL %s a=%d", e_not_implemented, angle);
    break;
  case DILATE_L_PUPIL:		// 29
  case DILATE_R_PUPIL:		// 30
    if (angle) trace(DBG_MAN, "DILATE_PUPIL %s a=%d", e_not_implemented, angle);
    break;
  case RAISE_L_I_EYEBROW:	// 31
    if (angle) trace(DBG_MAN, "RAISE_L_I_EYEBROW a=%d", angle);
    animEyeBrow(angle, browLeftRoot, browRightL);
    break;
  case RAISE_R_I_EYEBROW:	// 32
    if (angle) trace(DBG_MAN, "RAISE_R_I_EYEBROW a=%d", angle);
    animEyeBrow(angle, browRightRoot, browRightR);
    break;
  case RAISE_L_M_EYEBROW:	// 33
    if (angle) trace(DBG_MAN, "RAISE_L_M_EYEBROW a=%d", angle);
    animEyeBrow(angle, browLeftRoot, browRightL);
    break;
  case RAISE_R_M_EYEBROW:	// 34
    if (angle) trace(DBG_MAN, "RAISE_R_M_EYEBROW a=%d", angle);
    animEyeBrow(angle, browRightRoot, browRightR);
    break;
  case RAISE_L_O_EYEBROW:	// 35
    if (angle) trace(DBG_MAN, "RAISE_L_O_EYEBROW a=%d", angle);
    animEyeBrow(angle, browLeftRoot, browRightL);
    break;
  case RAISE_R_O_EYEBROW:	// 36
    if (angle) trace(DBG_MAN, "RAISE_R_O_EYEBROW a=%d", angle);
    animEyeBrow(angle, browRightRoot, browRightR);
    break;
  case SQUEEZE_L_EYEBROW:	// 37
    if (angle) trace(DBG_MAN, "SQUEEZE_L_EYEBROW %s a=%d", e_not_implemented, angle);
    break;
  case SQUEEZE_R_EYEBROW:	// 38
    if (angle) trace(DBG_MAN, "SQUEEZE_R_EYEBROW %s a=%d", e_not_implemented, angle);
    break;
  case PUFF_L_CHEEK:		// 39
  case PUFF_R_CHEEK:		// 40
    if (angle) trace(DBG_MAN, "PUFF_CHEEK %s", e_not_implemented);
    break;
  case LIFT_L_CHEEK:		// 41
  case LIFT_R_CHEEK:		// 42
    if (angle) trace(DBG_MAN, "LIFT_CHEEK %s", e_not_implemented);
    break;
  case SHIFT_TONGUE_TIP:	// 43
  case RAISE_TONGUE_TIP:	// 44
  case THRUST_TONGUE_TIP:	// 45
  case RAISE_TONGUE:		// 46
  case TONGUE_ROLL:		// 47
    if (angle) trace(DBG_MAN, "TONGUE %s", e_not_implemented);
    break;
  case HEAD_PITCH:		// 48
    if (angle) trace(DBG_MAN, "HEAD_PITCH a=%d", angle);
    animHead(angle, 0, 1, 0);	// yes
    break;
  case HEAD_YAW:		// 49
    if (angle) trace(DBG_MAN, "HEAD_YAW a=%d", angle);
    animHead(angle, 1, 0, 0);	// no
    break;
  case HEAD_ROLL:		// 50
    if (angle) trace(DBG_MAN, "HEAD_ROLL a=%d", angle);
    animHead(angle, 0, 0, 1);	// maybe
    break;
  case LOWER_T_MIDLIP_O:	// 51
    if (angle) trace(DBG_MAN, "LOWER_T_MIDLIP_O %s a=%d", e_not_implemented, angle);
    break;
  case RAISE_B_MIDLIP_O:	// 52
    if (angle) trace(DBG_MAN, "RAISE_B_MIDLIP_O %s a=%d", e_not_implemented, angle);
    break;
  case STRETCH_L_CORNERLIP_O:	// 53
    if (angle) trace(DBG_MAN, "STRETCH_L_CORNERLIP_O %s a=%d", e_not_implemented, angle);
    break;
  case STRETCH_R_CORNERLIP_O:	// 54
    if (angle) trace(DBG_MAN, "STRETCH_R_CORNERLIP_O %s a=%d", e_not_implemented, angle);
    break;
  case LOWER_T_LIP_LM_O:	// 55
    if (angle) trace(DBG_MAN, "LOWER_T_LIP_LM_O a=%d", angle);
    animLip(angle, lipsTopL);
    break;
  case LOWER_T_LIP_RM_O:	// 56
    if (angle) trace(DBG_MAN, "LOWER_T_LIP_RM_O a=%d", angle);
    animLip(angle, lipsTopR);
    break;
  case RAISE_B_LIP_LM_O:	// 57
    if (angle) trace(DBG_MAN, "RAISE_B_LIP_LM_O a=%d", angle);
    animLip(angle, lipsBotL);
    break;
  case RAISE_B_LIP_RM_O:	// 58
    if (angle) trace(DBG_MAN, "RAISE_B_LIP_RM_O a=%d", angle);
    animLip(angle, lipsBotR);
    break;
  case RAISE_L_CORNERLIP_O:	// 59
    if (angle) trace(DBG_MAN, "RAISE_L_CORNERLIP_O %s implemented a=%d", e_not_implemented, angle);
    break;
  case RAISE_R_CORNERLIP_O:	// 60
    if (angle) trace(DBG_MAN, "RAISE_R_CORNERLIP_O %s a=%d", e_not_implemented, angle);
    break;
  case STRETCH_L_NOSE:		// 61
    if (angle) trace(DBG_MAN, "STRETCH_L_NOSE a=%d", angle);
    animNose(angle, noseLeft);
    break;
  case STRETCH_R_NOSE:		// 62
    if (angle) trace(DBG_MAN, "STRETCH_R_NOSE a=%d", angle);
    animNose(angle, noseRight);
    break;
  case RAISE_NOSE:		// 63
    if (angle) trace(DBG_MAN, "RAISE_NOSE %s", e_not_implemented);
    break;
  case BEND_NOSE:		// 64
    if (angle) trace(DBG_MAN, "BEND_NOSE %s", e_not_implemented);
    break;
  case RAISE_L_EAR:		// 65
  case RAISE_R_EAR:		// 66
  case PULL_L_EAR:		// 67
  case PULL_R_EAR:		// 68
    if (angle) trace(DBG_MAN, "EAR %s", e_not_implemented);
    break;
  default:
    error("animate: unknown fap number=%d", fapn);
  }
}

void Face::animate()
{
  static float angle = 0.0;
  angle += 5.0;

  BoneVertex * temp;
  // --- LIPS MANAGEMENT ---
  // == smile then sulk
  if ( moveMouth ) {
    if ((temp = root->findChild(lipsRoot)) != NULL) {
      Vect3D smileDelta(0, cos(angle/10.0) / 4.0, 0);
      float smile = 20 * cos(angle / 10.0);
      if ((temp = root->findChild(lipsTopL)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(smile, 0,0,1);
      }
      if ((temp = root->findChild(lipsTopR)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(-smile, 0,0,1);
      }
      if ((temp = root->findChild(lipsBotL)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(smile, 0,0,1);
      }
      if ((temp = root->findChild(lipsBotR)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(-smile, 0,0,1);
      }
    }
  }
  // == smile
  if ( moveSmile ) {
    if ((temp = root->findChild(lipsRoot)) != NULL) {
      Vect3D smileDelta(0, cos(angle/10.0) / 4.0, 0);
      float smile = 20 * cos(angle / 10.0);
      if ((temp = root->findChild(lipsTopL)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(smile, 0,0,1);
      }
      if ((temp = root->findChild(lipsTopR)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(-smile, 0,0,1);
      }
    }
  }
  // == sulk
  if ( moveSulk ) {
    if ((temp = root->findChild(lipsRoot)) != NULL) {
      Vect3D smileDelta(0, cos(angle/10.0) / 4.0, 0);
      float smile = 20 * cos(angle / 10.0);
      if ((temp = root->findChild(lipsBotL)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(smile, 0,0,1);
      }
      if ((temp = root->findChild(lipsBotR)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(-smile, 0,0,1);
      }
    }
  }

  // --- LEFT EYE MANAGEMENT ---
  // == eye glance
  if ( moveEyeL ) {
    if ((temp = root->findChild(eyeLeftRoot)) != NULL) {
      float eyeLeftScale = (1 - cos(angle / 20.0)) / 2.0;
      if ((temp = root->findChild(eyeLeftBotRoot)) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
        temp->setCurrentRotation(-(1-eyeLeftScale)*20.0, 1,0,0);
      }
      if ((temp = root->findChild(eyeLeftTopRoot)) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
        temp->setCurrentRotation((1-eyeLeftScale)*20.0, 1,0,0);
      }
      if ((temp = root->findChild(eyeLeftTopL)) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
      }
      if ((temp = root->findChild(eyeLeftTopR)) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
      }
      if ((temp = root->findChild(eyeLeftBotL)) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
      }
      if ((temp = root->findChild(eyeLeftBotR)) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
      }
    }
  }

  // --- RIGHT EYE MANAGEMENT ---
  // eye move
  if ( moveEyeR ) {
    if ((temp = root->findChild(eyeRightRoot)) != NULL) {
      float eyeRightScale = (1 + cos(angle / 5.0)) / 20.0;
      if ((temp = root->findChild(browRightRoot)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale / 2.0, 0);
      }
      if ((temp = root->findChild(eyeRightBotRoot)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale / 2.0, 0);
      }
      if ((temp = root->findChild(eyeRightTopRoot)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale, 0);
      }
      if ((temp = root->findChild(eyeRightTopL)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale, 0);
      }
      if ((temp = root->findChild(eyeRightTopR)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale, 0);
      }
      if ((temp = root->findChild(eyeRightBotL)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale / 2.0, 0);
      }
      if ((temp = root->findChild(eyeRightBotR)) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale / 2.0, 0);
      }
    }
  }

  // --- NOSE MANAGEMENT ---
  // == resserement narines
  if ( moveNose ) {
    if ((temp = root->findChild(noseRoot)) != NULL) {
      float noseScale = 1 - cos(angle / 16.0) / 4.0;
      if ((temp = root->findChild(noseLeft)) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(noseScale, 1, 1);
      }
      if ((temp = root->findChild(noseRight)) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(noseScale, 1, 1);
      }
    }
  }

  // --- ROOT MANAGEMENT ---
  if ( moveYes ) {
    if ((temp = root->findChild(headRoot)) != NULL)
      temp->setCurrentRotation(10 * sin(angle/50.0), 1, 0, 0);
  }
  if ( moveNo ) {
    if ((temp = root->findChild(headRoot)) != NULL)
      temp->setCurrentRotation(10 * sin(angle/50.0), 0, 1, 0);
  }

#undef BROW_MOTION
#ifdef BROW_MOTION
  float browRightScale = cos(angle / 5.0);
  if ((temp = root->findChild(browRightRoot)) != NULL) {
    temp->resetCurrentPosition();
    temp->translateCurrentPosition(0, browRightScale / 25.0, 0);
  }
  if ((temp = root->findChild(browRightL)) != NULL) {
    temp->resetCurrentPosition();
    temp->setCurrentRotation(10 * browRightScale, 0,0,1);
    temp->translateCurrentPosition(0, browRightScale / 25.0, 0);
  }
#endif
}

void changeMoveYes(Android *po, void *d, time_t s, time_t u)
{
  po->faceObject->moveYes = ! po->faceObject->moveYes;
}

void changeMoveNo(Android *po, void *d, time_t s, time_t u)
{
  po->faceObject->moveNo = ! po->faceObject->moveNo;
}

void changeMoveMouth(Android *po, void *d, time_t s, time_t u)
{
  po->faceObject->moveMouth = ! po->faceObject->moveMouth;
}

void changeMoveSmile(Android *po, void *d, time_t s, time_t u)
{
  po->faceObject->moveSmile = ! po->faceObject->moveSmile;
}

void changeMoveSulk(Android *po, void *d, time_t s, time_t u)
{
  po->faceObject->moveSulk = ! po->faceObject->moveSulk;
}

void changeMoveEyeR(Android *po, void *d, time_t s, time_t u)
{
  po->faceObject->moveEyeR = ! po->faceObject->moveEyeR;
}

void changeMoveEyeL(Android *po, void *d, time_t s, time_t u)
{
  po->faceObject->moveEyeL = ! po->faceObject->moveEyeL;
}

void changeMoveNose(Android *po, void *d, time_t s, time_t u)
{
  po->faceObject->moveNose = ! po->faceObject->moveNose;
}

void changeFace(Android *po, void *d, time_t s, time_t u)
{
  po->faceObject->changeFace();
}
