#ifndef DOOR_H
#define DOOR_H

#define DOOR_TYPE	3
#define DOOR_NAME	"Door"
#define DOOR_INIT	doorInitFuncList
#define DOOR_LASTING	0.07	// 70 ms
#define DOOR_PROPS	4

#define DOOR_PROPHNAME	0
#define DOOR_PROPXY	1
#define DOOR_PROPZ	2
#define DOOR_PROPAZ	3

#define DOOR_OPENED	0
#define DOOR_CLOSED	1
#define DOOR_UNLOCKED	2
#define DOOR_LOCKED	3

/**
 * Door Class
 */
class Door: public WObject {
 public:
  static const uint8_t props;
  float aopen;		///< open angle
  float aclose;		///< close angle
  float aspeed;		///< angular speed (radian)
  uint8_t status;	///< opened | closed | unlocked | locked
  V3 center;		///< center position
  V3 size;		///< dimension

  static const WClass wclass;	///< class variable
  virtual const WClass* getWClass() {return &wclass;};

  Door(char *l);

  static WObject * (creator)(char *l);
  virtual bool isMoving();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual bool updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void quit();
};

void DOOR_INIT(void);

#endif // DOOR_H
