#ifndef CLOCK_H
#define CLOCK_H

#define CLOCK_TYPE	27
#define	CLOCK_NAME	"Clock"
#define	CLOCK_INIT	clockInitFuncList
#define CLOCK_PROPS	0

#define CLOCK_SECOND	1
#define CLOCK_MINUTE	2
#define CLOCK_HOUR	0

/**
 * Clock Class
 */
class Clock: public WObject {
 private:
  uint8_t needle;	///< which needle: s | m | h
  uint8_t sec;		///< secondes
  uint8_t min;		///< minutes
  uint8_t hour;		///< hour
  uint16_t yday;	///< day number in year
  uint8_t sec_last;	///< last sec
  uint8_t min_last;	///< last min
  uint8_t hour_last;	///< last hour
  float daytime;	///< midday time
  float risetime;	///< rise time
  float falltime;	///< fall time

  void init();

 public:
  static const WClass wclass;	// class variable
  static const uint8_t props;
  virtual const WClass* getWClass() {return &wclass;};

  Clock(char *l);
  Clock();

  static WObject * (creator)(char *l);
  virtual bool isMoving();
  virtual void changePermanent(float lasting);
  virtual void updateTime(time_t s, time_t u, float *lasting);
  virtual void quit();
};

void CLOCK_INIT(void);

#endif // CLOCK_H
