#include "global.h"
#include "wo.h"
#include "world.h"
#include "user.h"
#include "carrier.h"
#include "cart.h"

#include "gcontext.h"	// VGContext
#include "vgl.h"	// addSolidToList
#include "net.h"	// NetObject
#include "gui.h"	// GuiAddCartItem


const WClass Cart::wclass(CART_TYPE, "Cart", NULL);
void cartInitFuncList(void) {}


Cart::Cart(char *l)
{
  l = parseObject(l);
  type = CART_TYPE;
} 

/**
 * Adds the object to the logical cart
 * and calls the GuiAddCartItem to manage the cart widget
 */
void Cart::addObjectToCart(WObject *po)
{
  // find object's world list and remove object from it
  switch(po->list_id) {
    case LIST_STILL:
      stillList = po->deleteObjectFromList(stillList);
      break;
    case LIST_MOBILE:
      mobileList = po->deleteObjectFromList(mobileList);
      break;
    case LIST_INVISIBLE:
      invisibleList = po->deleteObjectFromList(invisibleList);
      break;
    default:
      break;
  }
 
  // remove object from collision checking grid
  po->deleteObjectFromGrid();
  
  // remove physical objet from world
  if (po->soh->next)
    po->soh->next->prev = po->soh->prev;
  else
    gcontext->last_solid = po->soh->prev;
  if (po->soh->prev)
    po->soh->prev->next = po->soh->next;
  else
    gcontext->first_solid = po->soh->next;	// 3D: enlever du gcontext: on n'utilise pas deletesolidfromlist car cela supprimerait le solide

  // close the object's menu
  po->soh->clearObjectBar();	// GUI: faire disparatre le menu de l'objet
  
  // net deletion declaration
  if (! po->isPermanent())
    delete po->noh;
  
  po->state.moving = STATE_IN_CART;
  //add to cart
  cartList = po->addObjectToList(cartList);
  
  //GUI - cardwidget management
  po->guip = GuiAddCartItem(po);
}

/**
 * Removes the object, (GuiRemoveCartItem yet called)
 */
void Cart::removeObjectFromCart(WObject *po)
{
  // remove from cartList
  cartList = po->deleteObjectFromList(cartList);

  // destroy object
  po->toDelete();
}

/**
 * Drops the object in the current world
 */
void Cart::dropObjectIntoWorld(WObject *po)
{
  // set the object's new coordinates & state
  po->pos.x = worlds->plocaluser->pos.x + 0.5;
  po->pos.y = worlds->plocaluser->pos.y;
  po->pos.z = worlds->plocaluser->pos.z + 0.5;
  po->move.ttl = 0;
  
  // reinitialize the "new" object in the world 
  initializeObject(po->list_id);

  po->enablePermanentMovement();

  po->update3D();
  po->getBB();
  
  // declare the object creation to the network
  if (! po->isPermanent())
    po->noh->declareObjCreation();
  
  // update the object's world
  po->name.world_name = World::getCurrentName();
  
  // we assume the object is simple and not complex (sinon on l'a arrach)
  po->pos.group = false;
  po->soh->next = NULL;
  
  // put its solid in the gcontext list
  po->soh->addSolidToList();
  
  // passe en mode take & drop
  worlds->plocaluser->car->takefromcart(po);
  
  // remove it from cartlist
  cartList = po->deleteObjectFromList(cartList);
}
