#ifndef CARRIER_H
#define CARRIER_H

#define CARRIER_TYPE	41
#define CARRIER_NAME	"Carrier"
#define CARRIER_INIT	carrierInitFuncList	//pd

#define MOVE_LSPEED     1.0     // 3 m/s
#define MOVE_ZSPEED     1.0     // 3 m/s
#define MOVE_ASPEED     0.5     // 0.5 rd/s
#define CARRIER_TTL	2.0	// 2 sec

void CARRIER_INIT(void);

/**
 * Classe carrier sert pour le dplacement d'objet
 * L'objet transprot est point mais il est retir des listes d'objets
 * et le carrier lui est remplac
 * Le deplacement est effectu avec les flches directionelles et la souris
 * Le boutton 1 permet de relacher l'objet
 * Le boutton 3 permet de passer dans le mode suivant:
 * mode 1: translation selon les axes x' y' (coordonnes relatives a l'avatar)
 * mode 2: translation selon les axes y' z'
 * mode 3: rotation selon les axes x et z
 */
class Carrier: public WObject {
 private:
  class WObject *carriedObject;
  ///< pointeur vers l'obje't transprot

  int buttonmode;
  ///< switch hauteur/profondeur en appuyant sur le bouton 3 de la souris

  float lspeed, aspeed;
  ///< vitesse de deplacement de l'objet transporte

 public:

  static const WClass wclass;   // class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  bool iscarring;
  ///< true si un objet est transport
  
  Carrier();

  virtual void take(WObject *po);
  /**< gere les changement de position
   * si change vaut true alors changePosition sera lance
   * et l'objet sera mis  jour */

  virtual void takefromcart(WObject *po);

  virtual void drop();
  /**< appele lorsque l'on relache l'objet.
   * rend  nouveau l'objet transport actif et dsactive le carrier */

  virtual void redirectEvent(int x, int y, int button);
  /**< appele par mpress de ubnavig.cc pour rediriger les clic souris
   * lorsque l'on deplace l'objet
   * le boutton gauche lache l'objet
   * le boutton droit change le mode de deplacement */

  virtual void redirectkeyEvent(int vkey,float last);
  /**< appele par userChangePositionOneType de move.cc pour rediriger les
   * fleches directionelles pour deplacer l'objet
   *  et gre les intersections de l'objet. L'appel a cette fonction
   * remplace le changement de position de l'avatar. */

};

  void takend(WObject *po, void *data, time_t sec, time_t usec);
  /**< appele lorsque l'on prend un objet
   * elle place l'objet dans le carrier et ralise toutes les
   * oprations ncessaires pour le passage en mode transport */

#endif // CARRIER_H
