#include "global.h"
#include "wo.h"
#include "world.h"
#include "user.h"	// plocaluser
#include "carrier.h"

#include "gui.h"	// GuiRedirectToCarrier


const WClass Carrier::wclass(CARRIER_TYPE, "Carrier", NULL);
void carrierInitFuncList(void) {}


Carrier::Carrier() 
{
  iscarring = false;
  carriedObject = NULL; 
  buttonmode = 0; 
  lspeed = 0.5;
  aspeed = 0.5;
  type = CARRIER_TYPE;
  // initializeObject(LIST_INVISIBLE);
  GuiRedirectToCarrier(this);
}

void takend(WObject *po, void *data, time_t sec, time_t usec)
{
  worlds->plocaluser->car->take(po);
}

void Carrier::take(WObject *po)
{  
  printf("take\n");

  WObject *wo = NULL;

  // Parcours de l'arbre pour initialiser les coords relatives
  for (wo = po->prev(); wo && wo->prev() == po->prev(); wo = wo->next()) {
    wo->pos.rel_x = po->pos.x - wo->pos.x;
    wo->pos.rel_y = po->pos.y - wo->pos.y;
    wo->pos.rel_z = po->pos.z - wo->pos.z;
  }

  iscarring = true;
  carriedObject = po;
  buttonmode = 1;

  po->move.lspeed.v[0] = 0;
  po->move.aspeed.v[1] = 0;
  po->initImposedMovement(0);

  po->state.moving = STATE_IN_CARRIER;
}

void Carrier::takefromcart(WObject *po)
{
  iscarring = true;
  carriedObject = po;
  buttonmode = 1;
  po->state.moving = STATE_IN_CARRIER;
}

void Carrier::drop()
{
  printf("drop\n");

  carriedObject->enablePermanentMovement();
  carriedObject->initImposedMovement(CARRIER_TTL);

  carriedObject->state.moving = STATE_DROP;

  // reinitialize the carrier
  iscarring = false;
  carriedObject = NULL; 
  buttonmode = 0;
}

void Carrier::redirectEvent(int x, int y, int button) 
{
  printf("mouse pressed\n");
  if (button == 1)	//left clic => drop object
    drop();
  else {
    if (button == 3)	//(check n button) right clic => change mode
      if (buttonmode != 3)
        buttonmode++; 
      else 
        buttonmode = 1; 
    else
      error("Carrier::redirectEvent: bad value of buttonmode");
  }
}

void Carrier::redirectkeyEvent(int vkey, float last)
{
  WObject *poldobj = new WObject();

  carriedObject->copyPositionAndBB(poldobj);	// copy oldpos, oldangle

  switch (vkey) {
  case KEY_AV:
    switch (buttonmode) {
    case 1:
      carriedObject->pos.x += Cos(worlds->plocaluser->pos.az)*last*lspeed;
      carriedObject->pos.y += Sin(worlds->plocaluser->pos.az)*last*lspeed;
      break;
    case 2:
      carriedObject->pos.z += last*lspeed;
      break;
    case 3:
      carriedObject->pos.ax += last*aspeed;
      break;
    }
    break;
  case KEY_AR:
    switch (buttonmode) {
    case 1:
      carriedObject->pos.x -= Cos(worlds->plocaluser->pos.az)*last*lspeed;
      carriedObject->pos.y -= Sin(worlds->plocaluser->pos.az)*last*lspeed;
      break;
    case 2:
      carriedObject->pos.z -= last*lspeed;
      break;
    case 3:
      carriedObject->pos.ax -= last*aspeed;
      break;
    }
    break;
  case KEY_DR:
    switch (buttonmode) {
    case 3:
      carriedObject->pos.az -= last*aspeed;
      break;
    default:
      carriedObject->pos.x += Sin(worlds->plocaluser->pos.az)*last*lspeed;
      carriedObject->pos.y -= Cos(worlds->plocaluser->pos.az)*last*lspeed;
      break;
    }
    break;
  case KEY_GA:
    switch (buttonmode) {
    case 3:
      carriedObject->pos.az += last*aspeed;
      break;
    default:
      carriedObject->pos.x -= Sin(worlds->plocaluser->pos.az)*last*lspeed;
      carriedObject->pos.y += Cos(worlds->plocaluser->pos.az)*last*lspeed;
      break;
    }
    break;
  default:
    delete poldobj;
    return;
  }

  carriedObject->update3D();
  carriedObject->getBB();
  if (carriedObject->isBehavior(COLLIDE_NEVER)) {
    delete poldobj;
    return;
  }

  ObjectList *vicinitylist = carriedObject->getVicinityObjectList(poldobj->pos);
  carriedObject->generalIntersect(poldobj, vicinitylist);
    vicinitylist->freeObjectList();
  delete poldobj;
}
